/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.util.Optional;
import org.gradle.internal.execution.IncrementalChangesContext;
import org.gradle.internal.execution.InputChangesContext;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.work.InputChanges;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveInputChangesStep<C extends IncrementalChangesContext>
implements Step<C, Result> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolveInputChangesStep.class);
    private final Step<? super InputChangesContext, ? extends Result> delegate;

    public ResolveInputChangesStep(Step<? super InputChangesContext, ? extends Result> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Result execute(C context) {
        UnitOfWork work = context.getWork();
        final Optional inputChanges = work.getInputChangeTrackingStrategy().requiresInputChanges() ? Optional.of(this.determineInputChanges(work, (IncrementalChangesContext)context)) : Optional.empty();
        return this.delegate.execute(new InputChangesContext((IncrementalChangesContext)context, work){
            final /* synthetic */ IncrementalChangesContext val$context;
            final /* synthetic */ UnitOfWork val$work;
            {
                this.val$context = incrementalChangesContext;
                this.val$work = unitOfWork;
            }

            @Override
            public Optional<InputChangesInternal> getInputChanges() {
                return inputChanges;
            }

            @Override
            public boolean isIncrementalExecution() {
                return inputChanges.map(InputChanges::isIncremental).orElse(false);
            }

            @Override
            public Optional<String> getRebuildReason() {
                return this.val$context.getRebuildReason();
            }

            @Override
            public Optional<AfterPreviousExecutionState> getAfterPreviousExecutionState() {
                return this.val$context.getAfterPreviousExecutionState();
            }

            @Override
            public Optional<BeforeExecutionState> getBeforeExecutionState() {
                return this.val$context.getBeforeExecutionState();
            }

            @Override
            public UnitOfWork getWork() {
                return this.val$work;
            }
        });
    }

    private InputChangesInternal determineInputChanges(UnitOfWork work, IncrementalChangesContext context) {
        ExecutionStateChanges changes = context.getChanges().get();
        InputChangesInternal inputChanges = changes.createInputChanges();
        if (!inputChanges.isIncremental()) {
            LOGGER.info("The input changes require a full rebuild for incremental {}.", (Object)work.getDisplayName());
        }
        return inputChanges;
    }
}

