/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class DescriberSelector {
    public static AttributeDescriber selectDescriber(AttributeContainerInternal consumerAttributes, AttributesSchemaInternal consumerSchema) {
        List<AttributeDescriber> consumerDescribers = consumerSchema.getConsumerDescribers();
        Set<Attribute<?>> consumerAttributeSet = consumerAttributes.keySet();
        AttributeDescriber current = null;
        int maxSize = 0;
        for (AttributeDescriber consumerDescriber : consumerDescribers) {
            int size = Sets.intersection(consumerDescriber.getAttributes(), consumerAttributeSet).size();
            if (size <= maxSize) continue;
            current = consumerDescriber;
            maxSize = size;
        }
        if (current != null) {
            return new FallbackDescriber(current);
        }
        return DefaultDescriber.INSTANCE;
    }

    private static class DefaultDescriber
    implements AttributeDescriber {
        private static final DefaultDescriber INSTANCE = new DefaultDescriber();

        private DefaultDescriber() {
        }

        @Override
        public Set<Attribute<?>> getAttributes() {
            return Collections.emptySet();
        }

        @Override
        public String describeAttributeSet(Map<Attribute<?>, ?> attributes) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Attribute<?>, ?> entry : attributes.entrySet()) {
                Attribute<?> attribute = entry.getKey();
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("attribute '").append(attribute.getName()).append("' with value '").append(entry.getValue()).append("'");
            }
            return sb.toString();
        }

        @Override
        public String describeMissingAttribute(Attribute<?> attribute, Object consumerValue) {
            return attribute.getName() + " (required '" + consumerValue + "')";
        }

        @Override
        public String describeExtraAttribute(Attribute<?> attribute, Object producerValue) {
            return attribute.getName() + " '" + producerValue + "'";
        }
    }

    private static class FallbackDescriber
    implements AttributeDescriber {
        private final AttributeDescriber delegate;

        private FallbackDescriber(AttributeDescriber delegate) {
            this.delegate = delegate;
        }

        @Override
        public Set<Attribute<?>> getAttributes() {
            return this.delegate.getAttributes();
        }

        @Override
        public String describeAttributeSet(Map<Attribute<?>, ?> attributes) {
            String description = this.delegate.describeAttributeSet(attributes);
            return description == null ? DefaultDescriber.INSTANCE.describeAttributeSet(attributes) : description;
        }

        @Override
        public String describeMissingAttribute(Attribute<?> attribute, Object producerValue) {
            String description = this.delegate.describeMissingAttribute(attribute, producerValue);
            return description == null ? DefaultDescriber.INSTANCE.describeMissingAttribute(attribute, producerValue) : description;
        }

        @Override
        public String describeExtraAttribute(Attribute<?> attribute, Object producerValue) {
            String description = this.delegate.describeExtraAttribute(attribute, producerValue);
            return description == null ? DefaultDescriber.INSTANCE.describeExtraAttribute(attribute, producerValue) : description;
        }
    }
}

