/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.io.Closeable;
import java.util.function.Function;
import org.gradle.api.internal.BuildType;
import org.gradle.internal.buildtree.BuildTreeContext;
import org.gradle.internal.buildtree.BuildTreeScopeServices;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;

public class BuildTreeState
implements Closeable {
    private final ServiceRegistry services;

    public BuildTreeState(ServiceRegistry parent, BuildType buildType) {
        this.services = ServiceRegistryBuilder.builder().displayName("build tree services").parent(parent).provider(new BuildTreeScopeServices(this, buildType)).build();
    }

    public ServiceRegistry getServices() {
        return this.services;
    }

    public <T> T run(Function<BuildTreeContext, T> action) {
        return action.apply(() -> this.services);
    }

    @Override
    public void close() {
        CompositeStoppable.stoppable(this.services).stop();
    }
}

