/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.packaging.impl;

import java.io.File;
import java.io.IOException;
import org.gradle.caching.internal.packaging.impl.TarPackerFileSystemSupport;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.impldep.org.apache.commons.io.FileUtils;

public class DefaultTarPackerFileSystemSupport
implements TarPackerFileSystemSupport {
    private final Deleter deleter;

    public DefaultTarPackerFileSystemSupport(Deleter deleter) {
        this.deleter = deleter;
    }

    @Override
    public void ensureFileIsMissing(File entry) throws IOException {
        if (!this.makeDirectory(entry.getParentFile())) {
            this.deleter.deleteRecursively(entry);
        }
    }

    @Override
    public void ensureDirectoryForTree(TreeType type, File root) throws IOException {
        switch (type) {
            case DIRECTORY: {
                this.deleter.ensureEmptyDirectory(root);
                break;
            }
            case FILE: {
                if (this.makeDirectory(root.getParentFile()) || !root.exists()) break;
                this.deleter.deleteRecursively(root);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private boolean makeDirectory(File target) throws IOException {
        if (target.isDirectory()) {
            return false;
        }
        if (target.isFile()) {
            this.deleter.delete(target);
        }
        FileUtils.forceMkdir((File)target);
        return true;
    }
}

