/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import org.gradle.cache.internal.CacheKeyBuilder;
import org.gradle.internal.classloader.ClasspathHasher;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.HashFunction;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.hash.Hasher;

class DefaultCacheKeyBuilder
implements CacheKeyBuilder {
    private final HashFunction hashFunction;
    private final FileHasher fileHasher;
    private final ClasspathHasher classpathHasher;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;

    public DefaultCacheKeyBuilder(HashFunction hashFunction, FileHasher fileHasher, ClasspathHasher classpathHasher, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        this.hashFunction = hashFunction;
        this.fileHasher = fileHasher;
        this.classpathHasher = classpathHasher;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
    }

    @Override
    public String build(CacheKeyBuilder.CacheKeySpec spec) {
        String prefix = spec.getPrefix();
        Object[] components = spec.getComponents();
        switch (components.length) {
            case 0: {
                return prefix;
            }
            case 1: {
                return prefix + "/" + HashUtil.compactStringFor(this.hashOf(components[0]).toByteArray());
            }
        }
        return prefix + "/" + HashUtil.compactStringFor(this.combinedHashOf(components).toByteArray());
    }

    private HashCode hashOf(Object component) {
        if (component instanceof HashCode) {
            return (HashCode)component;
        }
        if (component instanceof String) {
            return this.hashFunction.hashString((String)component);
        }
        if (component instanceof File) {
            return this.fileHasher.hash((File)component);
        }
        if (component instanceof ClassLoader) {
            return this.strictHashOf((ClassLoader)component);
        }
        if (component instanceof ClassPath) {
            return this.classpathHasher.hash((ClassPath)component);
        }
        throw new IllegalStateException("Unsupported cache key component type: " + component.getClass().getName());
    }

    private HashCode strictHashOf(ClassLoader classLoader) {
        HashCode strictHash = this.classLoaderHierarchyHasher.getClassLoaderHash(classLoader);
        if (strictHash == null) {
            throw new IllegalArgumentException("Unknown classloader: " + classLoader);
        }
        return strictHash;
    }

    private HashCode combinedHashOf(Object[] components) {
        Hasher hasher = this.hashFunction.newHasher();
        for (Object component : components) {
            hasher.putHash(this.hashOf(component));
        }
        return hasher.hash();
    }
}

