/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.util;

import groovy.lang.Closure;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.AntBuilderAware;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.internal.IntersectionPatternSet;
import org.gradle.api.tasks.util.internal.PatternSetAntBuilderDelegate;
import org.gradle.api.tasks.util.internal.PatternSpecFactory;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.util.CollectionUtils;

public class PatternSet
implements AntBuilderAware,
PatternFilterable {
    private static final NotationParser<Object, String> PARSER = NotationParserBuilder.toType(String.class).fromCharSequence().toComposite();
    private final PatternSpecFactory patternSpecFactory;
    private Set<String> includes;
    private Set<String> excludes;
    private Set<Spec<FileTreeElement>> includeSpecs;
    private Set<Spec<FileTreeElement>> excludeSpecs;
    private boolean caseSensitive = true;

    public PatternSet() {
        this(PatternSpecFactory.INSTANCE);
    }

    protected PatternSet(PatternSet patternSet) {
        this(patternSet.patternSpecFactory);
    }

    protected PatternSet(PatternSpecFactory patternSpecFactory) {
        this.patternSpecFactory = patternSpecFactory;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatternSet)) {
            return false;
        }
        PatternSet that = (PatternSet)o;
        if (this.caseSensitive != that.caseSensitive) {
            return false;
        }
        if (!this.nullToEmpty(this.excludeSpecs).equals(this.nullToEmpty(that.excludeSpecs))) {
            return false;
        }
        if (!this.nullToEmpty(this.excludes).equals(this.nullToEmpty(that.excludes))) {
            return false;
        }
        if (!this.nullToEmpty(this.includeSpecs).equals(this.nullToEmpty(that.includeSpecs))) {
            return false;
        }
        return this.nullToEmpty(this.includes).equals(this.nullToEmpty(that.includes));
    }

    public int hashCode() {
        int result = this.nullToEmpty(this.includes).hashCode();
        result = 31 * result + this.nullToEmpty(this.excludes).hashCode();
        result = 31 * result + this.nullToEmpty(this.includeSpecs).hashCode();
        result = 31 * result + this.nullToEmpty(this.excludeSpecs).hashCode();
        result = 31 * result + (this.caseSensitive ? 1 : 0);
        return result;
    }

    private Set<?> nullToEmpty(@Nullable Set<?> set2) {
        if (set2 == null) {
            return Collections.emptySet();
        }
        return set2;
    }

    public PatternSet copyFrom(PatternFilterable sourcePattern) {
        return this.doCopyFrom((PatternSet)sourcePattern);
    }

    protected PatternSet doCopyFrom(PatternSet from) {
        this.caseSensitive = from.caseSensitive;
        if (from instanceof IntersectionPatternSet) {
            PatternSet other = ((IntersectionPatternSet)from).getOther();
            PatternSet otherCopy = new PatternSet(other).copyFrom(other);
            IntersectionPatternSet intersectCopy = new IntersectionPatternSet(otherCopy);
            this.copyIncludesAndExcludes(intersectCopy, from);
            this.includes = null;
            this.excludes = null;
            this.includeSpecs = Sets.newLinkedHashSet();
            this.includeSpecs.add(((PatternSet)intersectCopy).getAsSpec());
            this.excludeSpecs = null;
        } else {
            this.copyIncludesAndExcludes(this, from);
        }
        return this;
    }

    private void copyIncludesAndExcludes(PatternSet target, PatternSet from) {
        target.includes = from.includes == null ? null : Sets.newLinkedHashSet(from.includes);
        target.excludes = from.excludes == null ? null : Sets.newLinkedHashSet(from.excludes);
        target.includeSpecs = from.includeSpecs == null ? null : Sets.newLinkedHashSet(from.includeSpecs);
        target.excludeSpecs = from.excludeSpecs == null ? null : Sets.newLinkedHashSet(from.excludeSpecs);
    }

    public PatternSet intersect() {
        if (this.isEmpty()) {
            return new PatternSet(this.patternSpecFactory);
        }
        return new IntersectionPatternSet(this);
    }

    public boolean isEmpty() {
        return !(this.includes != null && !this.includes.isEmpty() || this.excludes != null && !this.excludes.isEmpty() || this.includeSpecs != null && !this.includeSpecs.isEmpty() || this.excludeSpecs != null && !this.excludeSpecs.isEmpty());
    }

    public Spec<FileTreeElement> getAsSpec() {
        return this.patternSpecFactory.createSpec(this);
    }

    public Spec<FileTreeElement> getAsIncludeSpec() {
        return this.patternSpecFactory.createIncludeSpec(this);
    }

    public Spec<FileTreeElement> getAsExcludeSpec() {
        return this.patternSpecFactory.createExcludeSpec(this);
    }

    @Override
    public Set<String> getIncludes() {
        if (this.includes == null) {
            this.includes = Sets.newLinkedHashSet();
        }
        return this.includes;
    }

    public Set<Spec<FileTreeElement>> getIncludeSpecs() {
        if (this.includeSpecs == null) {
            this.includeSpecs = Sets.newLinkedHashSet();
        }
        return this.includeSpecs;
    }

    @Override
    public PatternSet setIncludes(Iterable<String> includes) {
        this.includes = null;
        return this.include((Iterable)includes);
    }

    @Override
    public PatternSet include(String ... includes) {
        Collections.addAll(this.getIncludes(), includes);
        return this;
    }

    public PatternSet include(Iterable includes) {
        for (Object include : includes) {
            this.getIncludes().add(PARSER.parseNotation(include));
        }
        return this;
    }

    @Override
    public PatternSet include(Spec<FileTreeElement> spec) {
        this.getIncludeSpecs().add(spec);
        return this;
    }

    @Override
    public Set<String> getExcludes() {
        if (this.excludes == null) {
            this.excludes = Sets.newLinkedHashSet();
        }
        return this.excludes;
    }

    public Set<Spec<FileTreeElement>> getExcludeSpecs() {
        if (this.excludeSpecs == null) {
            this.excludeSpecs = Sets.newLinkedHashSet();
        }
        return this.excludeSpecs;
    }

    @Override
    public PatternSet setExcludes(Iterable<String> excludes) {
        this.excludes = null;
        return this.exclude((Iterable)excludes);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public PatternSet includeSpecs(Iterable<Spec<FileTreeElement>> includeSpecs) {
        CollectionUtils.addAll(this.getIncludeSpecs(), includeSpecs);
        return this;
    }

    @Override
    public PatternSet include(Closure closure) {
        this.include(Specs.convertClosureToSpec(closure));
        return this;
    }

    @Override
    public PatternSet exclude(String ... excludes) {
        Collections.addAll(this.getExcludes(), excludes);
        return this;
    }

    public PatternSet exclude(Iterable excludes) {
        for (Object exclude : excludes) {
            this.getExcludes().add(PARSER.parseNotation(exclude));
        }
        return this;
    }

    @Override
    public PatternSet exclude(Spec<FileTreeElement> spec) {
        this.getExcludeSpecs().add(spec);
        return this;
    }

    public PatternSet excludeSpecs(Iterable<Spec<FileTreeElement>> excludes) {
        CollectionUtils.addAll(this.getExcludeSpecs(), excludes);
        return this;
    }

    @Override
    public PatternSet exclude(Closure closure) {
        this.exclude(Specs.convertClosureToSpec(closure));
        return this;
    }

    @Override
    public Object addToAntBuilder(Object node, String childNodeName) {
        if (!this.nullToEmpty(this.includeSpecs).isEmpty() || !this.nullToEmpty(this.excludeSpecs).isEmpty()) {
            throw new UnsupportedOperationException("Cannot add include/exclude specs to Ant node. Only include/exclude patterns are currently supported.");
        }
        return new PatternSetAntBuilderDelegate(this.getIncludes(), this.getExcludes(), this.isCaseSensitive()).addToAntBuilder(node, childNodeName);
    }
}

