/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import groovy.lang.Closure;
import java.io.FilterReader;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.NonNullApi;
import org.gradle.api.Transformer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.copy.ClosureBackedTransformer;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionExecuter;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.CopySpecResolver;
import org.gradle.api.internal.file.copy.CopySpecSource;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ClosureBackedAction;

@NonNullApi
public abstract class AbstractCopyTask
extends ConventionTask
implements CopySpec,
CopySpecSource {
    private final CopySpecInternal rootSpec = this.createRootSpec();
    private final CopySpecInternal mainSpec;

    protected AbstractCopyTask() {
        this.rootSpec.addChildSpecListener((path, spec) -> {
            if (this.getState().getExecuting()) {
                throw new GradleException("You cannot add child specs at execution time. Consider configuring this task during configuration time or using a separate task to do the configuration.");
            }
            StringBuilder specPropertyNameBuilder = new StringBuilder("rootSpec");
            CopySpecResolver parentResolver = path.unroll(specPropertyNameBuilder);
            CopySpecResolver resolver = spec.buildResolverRelativeToParent(parentResolver);
            String specPropertyName = specPropertyNameBuilder.toString();
            Object[] objectArray = new Object[1];
            objectArray[0] = resolver::getSource;
            this.getInputs().files(objectArray).withPropertyName(specPropertyName).withPathSensitivity(PathSensitivity.RELATIVE).skipWhenEmpty();
            this.getInputs().property(specPropertyName + ".destPath", () -> resolver.getDestPath().getPathString());
            this.getInputs().property(specPropertyName + ".caseSensitive", spec::isCaseSensitive);
            this.getInputs().property(specPropertyName + ".includeEmptyDirs", spec::getIncludeEmptyDirs);
            this.getInputs().property(specPropertyName + ".duplicatesStrategy", spec::getDuplicatesStrategy);
            this.getInputs().property(specPropertyName + ".dirMode", spec::getDirMode).optional(true);
            this.getInputs().property(specPropertyName + ".fileMode", spec::getFileMode).optional(true);
            this.getInputs().property(specPropertyName + ".filteringCharset", spec::getFilteringCharset);
        });
        this.getOutputs().doNotCacheIf("Has custom actions", SerializableLambdas.spec(task -> this.rootSpec.hasCustomActions()));
        this.mainSpec = this.rootSpec.addChild();
    }

    protected CopySpecInternal createRootSpec() {
        return this.getProject().getObjects().newInstance(DefaultCopySpec.class, new Object[0]);
    }

    protected abstract CopyAction createCopyAction();

    @Inject
    protected Instantiator getInstantiator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileSystem getFileSystem() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileLookup getFileLookup() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected DirectoryFileTreeFactory getDirectoryFileTreeFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    protected void copy() {
        CopyActionExecuter copyActionExecuter = this.createCopyActionExecuter();
        CopyAction copyAction = this.createCopyAction();
        WorkResult didWork = copyActionExecuter.execute(this.rootSpec, copyAction);
        this.setDidWork(didWork.getDidWork());
    }

    protected CopyActionExecuter createCopyActionExecuter() {
        Instantiator instantiator = this.getInstantiator();
        FileSystem fileSystem = this.getFileSystem();
        return new CopyActionExecuter(instantiator, fileSystem, false);
    }

    @Internal
    public FileCollection getSource() {
        return this.rootSpec.buildRootResolver().getAllSource();
    }

    @Override
    @Internal
    public CopySpecInternal getRootSpec() {
        return this.rootSpec;
    }

    @Internal
    protected CopySpecInternal getMainSpec() {
        return this.mainSpec;
    }

    @Override
    @Internal
    public boolean isCaseSensitive() {
        return this.getMainSpec().isCaseSensitive();
    }

    @Override
    public void setCaseSensitive(boolean caseSensitive) {
        this.getMainSpec().setCaseSensitive(caseSensitive);
    }

    @Override
    @Internal
    public boolean getIncludeEmptyDirs() {
        return this.getMainSpec().getIncludeEmptyDirs();
    }

    @Override
    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.getMainSpec().setIncludeEmptyDirs(includeEmptyDirs);
    }

    @Override
    public void setDuplicatesStrategy(DuplicatesStrategy strategy) {
        this.getRootSpec().setDuplicatesStrategy(strategy);
    }

    @Override
    @Internal
    public DuplicatesStrategy getDuplicatesStrategy() {
        return this.getRootSpec().getDuplicatesStrategy();
    }

    @Override
    public AbstractCopyTask from(Object ... sourcePaths) {
        this.getMainSpec().from(sourcePaths);
        return this;
    }

    @Override
    public AbstractCopyTask filesMatching(String pattern, Action<? super FileCopyDetails> action) {
        this.getMainSpec().filesMatching(pattern, action);
        return this;
    }

    @Override
    public AbstractCopyTask filesMatching(Iterable<String> patterns, Action<? super FileCopyDetails> action) {
        this.getMainSpec().filesMatching(patterns, action);
        return this;
    }

    @Override
    public AbstractCopyTask filesNotMatching(String pattern, Action<? super FileCopyDetails> action) {
        this.getMainSpec().filesNotMatching(pattern, action);
        return this;
    }

    @Override
    public AbstractCopyTask filesNotMatching(Iterable<String> patterns, Action<? super FileCopyDetails> action) {
        this.getMainSpec().filesNotMatching(patterns, action);
        return this;
    }

    @Override
    public AbstractCopyTask from(Object sourcePath, Closure c) {
        this.getMainSpec().from(sourcePath, (Action)new ClosureBackedAction(c));
        return this;
    }

    @Override
    public AbstractCopyTask from(Object sourcePath, Action<? super CopySpec> configureAction) {
        this.getMainSpec().from(sourcePath, (Action)configureAction);
        return this;
    }

    @Override
    public CopySpec with(CopySpec ... sourceSpecs) {
        this.getMainSpec().with(sourceSpecs);
        return this;
    }

    @Override
    public AbstractCopyTask into(Object destDir) {
        this.getRootSpec().into(destDir);
        return this;
    }

    @Override
    public AbstractCopyTask into(Object destPath, Closure configureClosure) {
        this.getMainSpec().into(destPath, configureClosure);
        return this;
    }

    @Override
    public CopySpec into(Object destPath, Action<? super CopySpec> copySpec) {
        this.getMainSpec().into(destPath, copySpec);
        return this;
    }

    @Override
    public AbstractCopyTask include(String ... includes) {
        this.getMainSpec().include(includes);
        return this;
    }

    @Override
    public AbstractCopyTask include(Iterable<String> includes) {
        this.getMainSpec().include((Iterable)includes);
        return this;
    }

    @Override
    public AbstractCopyTask include(Spec<FileTreeElement> includeSpec) {
        this.getMainSpec().include((Spec)includeSpec);
        return this;
    }

    @Override
    public AbstractCopyTask include(Closure includeSpec) {
        this.getMainSpec().include(includeSpec);
        return this;
    }

    @Override
    public AbstractCopyTask exclude(String ... excludes) {
        this.getMainSpec().exclude(excludes);
        return this;
    }

    @Override
    public AbstractCopyTask exclude(Iterable<String> excludes) {
        this.getMainSpec().exclude((Iterable)excludes);
        return this;
    }

    @Override
    public AbstractCopyTask exclude(Spec<FileTreeElement> excludeSpec) {
        this.getMainSpec().exclude((Spec)excludeSpec);
        return this;
    }

    @Override
    public AbstractCopyTask exclude(Closure excludeSpec) {
        this.getMainSpec().exclude(excludeSpec);
        return this;
    }

    @Override
    public AbstractCopyTask setIncludes(Iterable<String> includes) {
        this.getMainSpec().setIncludes((Iterable)includes);
        return this;
    }

    @Override
    @Internal
    public Set<String> getIncludes() {
        return this.getMainSpec().getIncludes();
    }

    @Override
    public AbstractCopyTask setExcludes(Iterable<String> excludes) {
        this.getMainSpec().setExcludes((Iterable)excludes);
        return this;
    }

    @Override
    @Internal
    public Set<String> getExcludes() {
        return this.getMainSpec().getExcludes();
    }

    @Override
    public AbstractCopyTask rename(Closure closure) {
        return this.rename((Transformer)new ClosureBackedTransformer(closure));
    }

    @Override
    public AbstractCopyTask rename(Transformer<String, String> renamer) {
        this.getMainSpec().rename((Transformer)renamer);
        return this;
    }

    @Override
    public AbstractCopyTask rename(String sourceRegEx, String replaceWith) {
        this.getMainSpec().rename(sourceRegEx, replaceWith);
        return this;
    }

    @Override
    public AbstractCopyTask rename(Pattern sourceRegEx, String replaceWith) {
        this.getMainSpec().rename(sourceRegEx, replaceWith);
        return this;
    }

    @Override
    public AbstractCopyTask filter(Map<String, ?> properties, Class<? extends FilterReader> filterType) {
        this.getMainSpec().filter((Map)properties, (Class)filterType);
        return this;
    }

    @Override
    public AbstractCopyTask filter(Class<? extends FilterReader> filterType) {
        this.getMainSpec().filter((Class)filterType);
        return this;
    }

    @Override
    public AbstractCopyTask filter(Closure closure) {
        this.getMainSpec().filter(closure);
        return this;
    }

    @Override
    public AbstractCopyTask filter(Transformer<String, String> transformer) {
        this.getMainSpec().filter((Transformer)transformer);
        return this;
    }

    @Override
    public AbstractCopyTask expand(Map<String, ?> properties) {
        this.getMainSpec().expand((Map)properties);
        return this;
    }

    @Override
    @Internal
    public Integer getDirMode() {
        return this.getMainSpec().getDirMode();
    }

    @Override
    @Internal
    public Integer getFileMode() {
        return this.getMainSpec().getFileMode();
    }

    @Override
    public AbstractCopyTask setDirMode(@Nullable Integer mode) {
        this.getMainSpec().setDirMode(mode);
        return this;
    }

    @Override
    public AbstractCopyTask setFileMode(@Nullable Integer mode) {
        this.getMainSpec().setFileMode(mode);
        return this;
    }

    @Override
    public AbstractCopyTask eachFile(Action<? super FileCopyDetails> action) {
        this.getMainSpec().eachFile((Action)action);
        return this;
    }

    @Override
    public AbstractCopyTask eachFile(Closure closure) {
        this.getMainSpec().eachFile(closure);
        return this;
    }

    @Override
    @Internal
    public String getFilteringCharset() {
        return this.getMainSpec().getFilteringCharset();
    }

    @Override
    public void setFilteringCharset(String charset) {
        this.getMainSpec().setFilteringCharset(charset);
    }
}

