/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report;

import java.io.IOException;
import java.net.URL;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.report.CompositeTestResults;
import org.gradle.api.internal.tasks.testing.report.TestResult;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.html.SimpleHtmlWriter;
import org.gradle.reporting.ReportRenderer;
import org.gradle.reporting.TabbedPageRenderer;
import org.gradle.reporting.TabsRenderer;

abstract class PageRenderer<T extends CompositeTestResults>
extends TabbedPageRenderer<T> {
    private static final URL STYLE_URL = PageRenderer.class.getResource("style.css");
    private T results;
    private final TabsRenderer<T> tabsRenderer = new TabsRenderer();

    PageRenderer() {
    }

    protected T getResults() {
        return this.results;
    }

    protected abstract void renderBreadcrumbs(SimpleHtmlWriter var1) throws IOException;

    protected abstract void registerTabs();

    @Override
    protected URL getStyleUrl() {
        return STYLE_URL;
    }

    protected void addTab(String title, final Action<SimpleHtmlWriter> contentRenderer) {
        this.tabsRenderer.add(title, new ReportRenderer<T, SimpleHtmlWriter>(){

            @Override
            public void render(T model, SimpleHtmlWriter writer) {
                contentRenderer.execute(writer);
            }
        });
    }

    protected void renderTabs(SimpleHtmlWriter htmlWriter) throws IOException {
        this.tabsRenderer.render(this.getModel(), htmlWriter);
    }

    protected void addFailuresTab() {
        if (!((CompositeTestResults)this.results).getFailures().isEmpty()) {
            this.addTab("Failed tests", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                @Override
                public void doExecute(SimpleHtmlWriter element) throws IOException {
                    PageRenderer.this.renderFailures(element);
                }
            });
        }
    }

    protected void renderFailures(SimpleHtmlWriter htmlWriter) throws IOException {
        this.renderTestResultList(htmlWriter, ((CompositeTestResults)this.results).getFailures());
    }

    private void renderTestResultList(SimpleHtmlWriter htmlWriter, Set<TestResult> failures) throws IOException {
        htmlWriter.startElement("ul").attribute("class", "linkList");
        for (TestResult test : failures) {
            htmlWriter.startElement("li");
            htmlWriter.startElement("a").attribute("href", this.asHtmlLinkEncoded(((CompositeTestResults)this.getResults()).getUrlTo(test.getClassResults()))).characters(test.getClassResults().getReportName()).endElement();
            htmlWriter.characters(".");
            String link = this.asHtmlLinkEncoded(((CompositeTestResults)this.getResults()).getUrlTo(test.getClassResults())) + "#" + test.getName();
            htmlWriter.startElement("a").attribute("href", link).characters(test.getDisplayName()).endElement();
            htmlWriter.endElement();
        }
        htmlWriter.endElement();
    }

    protected void addIgnoredTab() {
        if (!((CompositeTestResults)this.results).getIgnored().isEmpty()) {
            this.addTab("Ignored tests", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                @Override
                public void doExecute(SimpleHtmlWriter htmlWriter) throws IOException {
                    PageRenderer.this.renderIgnoredTests(htmlWriter);
                }
            });
        }
    }

    protected void renderIgnoredTests(SimpleHtmlWriter htmlWriter) throws IOException {
        this.renderTestResultList(htmlWriter, ((CompositeTestResults)this.getResults()).getIgnored());
    }

    @Override
    protected String getTitle() {
        return ((CompositeTestResults)this.getModel()).getTitle();
    }

    @Override
    protected String getPageTitle() {
        return "Test results - " + ((CompositeTestResults)this.getModel()).getTitle();
    }

    @Override
    protected ReportRenderer<T, SimpleHtmlWriter> getHeaderRenderer() {
        return new ReportRenderer<T, SimpleHtmlWriter>(){

            @Override
            public void render(T model, SimpleHtmlWriter htmlWriter) throws IOException {
                PageRenderer.this.results = model;
                PageRenderer.this.renderBreadcrumbs(htmlWriter);
                htmlWriter.startElement("div").attribute("id", "summary");
                htmlWriter.startElement("table");
                htmlWriter.startElement("tr");
                htmlWriter.startElement("td");
                htmlWriter.startElement("div").attribute("class", "summaryGroup");
                htmlWriter.startElement("table");
                htmlWriter.startElement("tr");
                htmlWriter.startElement("td");
                htmlWriter.startElement("div").attribute("class", "infoBox").attribute("id", "tests");
                htmlWriter.startElement("div").attribute("class", "counter").characters(Integer.toString(PageRenderer.this.results.getTestCount())).endElement();
                htmlWriter.startElement("p").characters("tests").endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.startElement("td");
                htmlWriter.startElement("div").attribute("class", "infoBox").attribute("id", "failures");
                htmlWriter.startElement("div").attribute("class", "counter").characters(Integer.toString(PageRenderer.this.results.getFailureCount())).endElement();
                htmlWriter.startElement("p").characters("failures").endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.startElement("td");
                htmlWriter.startElement("div").attribute("class", "infoBox").attribute("id", "ignored");
                htmlWriter.startElement("div").attribute("class", "counter").characters(Integer.toString(PageRenderer.this.results.getIgnoredCount())).endElement();
                htmlWriter.startElement("p").characters("ignored").endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.startElement("td");
                htmlWriter.startElement("div").attribute("class", "infoBox").attribute("id", "duration");
                htmlWriter.startElement("div").attribute("class", "counter").characters(PageRenderer.this.results.getFormattedDuration()).endElement();
                htmlWriter.startElement("p").characters("duration").endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.startElement("td");
                htmlWriter.startElement("div").attribute("class", "infoBox " + PageRenderer.this.results.getStatusClass()).attribute("id", "successRate");
                htmlWriter.startElement("div").attribute("class", "percent").characters(PageRenderer.this.results.getFormattedSuccessRate()).endElement();
                htmlWriter.startElement("p").characters("successful").endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
            }
        };
    }

    @Override
    protected ReportRenderer<T, SimpleHtmlWriter> getContentRenderer() {
        return new ReportRenderer<T, SimpleHtmlWriter>(){

            @Override
            public void render(T model, SimpleHtmlWriter htmlWriter) throws IOException {
                PageRenderer.this.results = model;
                PageRenderer.this.tabsRenderer.clear();
                PageRenderer.this.registerTabs();
                PageRenderer.this.renderTabs(htmlWriter);
            }
        };
    }

    protected String asHtmlLinkEncoded(String rawLink) {
        return rawLink.replace("#", "%23");
    }
}

