/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties.annotations;

import java.io.File;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.properties.BeanPropertyContext;
import org.gradle.api.internal.tasks.properties.ModifierAnnotationCategory;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandler;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.reflect.AnnotationCategory;
import org.gradle.internal.reflect.PropertyMetadata;
import org.gradle.internal.reflect.TypeValidationContext;
import org.gradle.model.internal.type.ModelType;

public class InputPropertyAnnotationHandler
implements PropertyAnnotationHandler {
    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return Input.class;
    }

    @Override
    public ImmutableSet<? extends AnnotationCategory> getAllowedModifiers() {
        return ImmutableSet.of((Object)ModifierAnnotationCategory.OPTIONAL);
    }

    @Override
    public boolean isPropertyRelevant() {
        return true;
    }

    @Override
    public boolean shouldVisit(PropertyVisitor visitor) {
        return true;
    }

    @Override
    public void visitPropertyValue(String propertyName, PropertyValue value, PropertyMetadata propertyMetadata, PropertyVisitor visitor, BeanPropertyContext context) {
        visitor.visitInputProperty(propertyName, value, propertyMetadata.isAnnotationPresent(Optional.class));
    }

    @Override
    public void validatePropertyMetadata(PropertyMetadata propertyMetadata, TypeValidationContext validationContext) {
        Class<?> valueType = propertyMetadata.getGetterMethod().getReturnType();
        if (File.class.isAssignableFrom(valueType) || Path.class.isAssignableFrom(valueType) || FileCollection.class.isAssignableFrom(valueType)) {
            validationContext.visitPropertyProblem(TypeValidationContext.Severity.WARNING, propertyMetadata.getPropertyName(), String.format("has @Input annotation used on property of type '%s'", ModelType.of(valueType).getDisplayName()));
        }
        if (valueType.isPrimitive() && propertyMetadata.isAnnotationPresent(Optional.class)) {
            validationContext.visitPropertyProblem(TypeValidationContext.Severity.WARNING, propertyMetadata.getPropertyName(), String.format("@Input properties with primitive type '%s' cannot be @Optional", valueType.getName()));
        }
    }
}

