/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilationData;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilationOutputAnalyzer;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntCollection;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSet;

public class PreviousCompilation {
    private final PreviousCompilationData data;
    private final ClasspathEntrySnapshotCache classpathEntrySnapshotCache;
    private final PreviousCompilationOutputAnalyzer previousCompilationOutputAnalyzer;
    private ClassSetAnalysis classAnalysis;

    public PreviousCompilation(PreviousCompilationData data, ClasspathEntrySnapshotCache classpathEntrySnapshotCache, PreviousCompilationOutputAnalyzer previousCompilationOutputAnalyzer) {
        this.data = data;
        this.classpathEntrySnapshotCache = classpathEntrySnapshotCache;
        this.previousCompilationOutputAnalyzer = previousCompilationOutputAnalyzer;
    }

    public DependentsSet getDependents(Set<String> allClasses, IntSet constants) {
        return this.getClassAnalysis().getRelevantDependents(allClasses, constants);
    }

    private ClassSetAnalysis getClassAnalysis() {
        if (this.classAnalysis == null) {
            this.classAnalysis = this.previousCompilationOutputAnalyzer.getAnalysis(this.data.getDestinationDir()).withAnnotationProcessingData(this.data.getAnnotationProcessingData());
        }
        return this.classAnalysis;
    }

    public ClasspathEntrySnapshot getClasspathEntrySnapshot(File file) {
        return this.classpathEntrySnapshotCache.get(file, this.data.getClasspathSnapshot().getFileHashes().get(file));
    }

    public Set<File> getClasspath() {
        return this.data.getClasspathSnapshot().getFileHashes().keySet();
    }

    public DependentsSet getDependents(String className, IntSet newConstants) {
        IntOpenHashSet constants = new IntOpenHashSet((IntCollection)this.getClassAnalysis().getConstants(className));
        constants.removeAll((IntCollection)newConstants);
        return this.getClassAnalysis().getRelevantDependents(className, (IntSet)constants);
    }

    public Set<String> getTypesToReprocess() {
        return this.getClassAnalysis().getTypesToReprocess();
    }

    public List<File> getAnnotationProcessorPath() {
        return this.data.getAnnotationProcessorPath();
    }

    public String getAnnotationProcessorFullRebuildCause() {
        return this.data.getAnnotationProcessingData().getFullRebuildCause();
    }
}

