/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSet;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSets;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.IntSetSerializer;

public class ClassSetAnalysisData {
    public static final String PACKAGE_INFO = "package-info";
    private final Set<String> classes;
    private final Map<String, DependentsSet> dependents;
    private final Map<String, IntSet> classesToConstants;
    private final String fullRebuildCause;

    public ClassSetAnalysisData(Set<String> classes, Map<String, DependentsSet> dependents, Map<String, IntSet> classesToConstants, String fullRebuildCause) {
        this.classes = classes;
        this.dependents = dependents;
        this.classesToConstants = classesToConstants;
        this.fullRebuildCause = fullRebuildCause;
    }

    public DependentsSet getDependents(String className) {
        if (this.fullRebuildCause != null) {
            return DependentsSet.dependencyToAll(this.fullRebuildCause);
        }
        if (className.endsWith(PACKAGE_INFO)) {
            String packageName = className.equals(PACKAGE_INFO) ? null : StringUtils.removeEnd((String)className, (String)".package-info");
            return this.getDependentsOfPackage(packageName);
        }
        DependentsSet dependentsSet = this.dependents.get(className);
        return dependentsSet == null ? DependentsSet.empty() : dependentsSet;
    }

    private DependentsSet getDependentsOfPackage(String packageName) {
        HashSet typesInPackage = Sets.newHashSet();
        for (String type : this.classes) {
            int i = type.lastIndexOf(".");
            if ((i >= 0 || packageName != null) && (i <= 0 || !type.substring(0, i).equals(packageName))) continue;
            typesInPackage.add(type);
        }
        return DependentsSet.dependentClasses(Collections.emptySet(), typesInPackage);
    }

    public IntSet getConstants(String className) {
        IntSet integers = this.classesToConstants.get(className);
        if (integers == null) {
            return IntSets.EMPTY_SET;
        }
        return integers;
    }

    public static class Serializer
    extends AbstractSerializer<ClassSetAnalysisData> {
        private final StringInterner interner;

        public Serializer(StringInterner interner) {
            this.interner = interner;
        }

        @Override
        public ClassSetAnalysisData read(Decoder decoder) throws Exception {
            HashMap<Integer, String> classNameMap = new HashMap<Integer, String>();
            int count = decoder.readSmallInt();
            ImmutableSet.Builder classes = ImmutableSet.builder();
            for (int i = 0; i < count; ++i) {
                classes.add((Object)this.readClassName(decoder, classNameMap));
            }
            count = decoder.readSmallInt();
            ImmutableMap.Builder dependentsBuilder = ImmutableMap.builder();
            for (int i = 0; i < count; ++i) {
                String className = this.readClassName(decoder, classNameMap);
                DependentsSet dependents = this.readDependentsSet(decoder, classNameMap);
                dependentsBuilder.put((Object)className, (Object)dependents);
            }
            count = decoder.readSmallInt();
            ImmutableMap.Builder classesToConstantsBuilder = ImmutableMap.builder();
            for (int i = 0; i < count; ++i) {
                String className = this.readClassName(decoder, classNameMap);
                IntSet constants = IntSetSerializer.INSTANCE.read(decoder);
                classesToConstantsBuilder.put((Object)className, (Object)constants);
            }
            String fullRebuildCause = decoder.readNullableString();
            return new ClassSetAnalysisData((Set<String>)classes.build(), (Map<String, DependentsSet>)dependentsBuilder.build(), (Map<String, IntSet>)classesToConstantsBuilder.build(), fullRebuildCause);
        }

        @Override
        public void write(Encoder encoder, ClassSetAnalysisData value) throws Exception {
            HashMap<String, Integer> classNameMap = new HashMap<String, Integer>();
            encoder.writeSmallInt(value.classes.size());
            for (String string2 : value.classes) {
                this.writeClassName(string2, classNameMap, encoder);
            }
            encoder.writeSmallInt(value.dependents.size());
            for (Map.Entry entry : value.dependents.entrySet()) {
                this.writeClassName((String)entry.getKey(), classNameMap, encoder);
                this.writeDependentSet((DependentsSet)entry.getValue(), classNameMap, encoder);
            }
            encoder.writeSmallInt(value.classesToConstants.size());
            for (Map.Entry entry : value.classesToConstants.entrySet()) {
                this.writeClassName((String)entry.getKey(), classNameMap, encoder);
                IntSetSerializer.INSTANCE.write(encoder, (IntSet)entry.getValue());
            }
            encoder.writeNullableString(value.fullRebuildCause);
        }

        private DependentsSet readDependentsSet(Decoder decoder, Map<Integer, String> classNameMap) throws IOException {
            byte b = decoder.readByte();
            if (b == 1) {
                return DependentsSet.dependencyToAll(decoder.readNullableString());
            }
            ImmutableSet.Builder privateBuilder = ImmutableSet.builder();
            int count = decoder.readSmallInt();
            for (int i = 0; i < count; ++i) {
                privateBuilder.add((Object)this.readClassName(decoder, classNameMap));
            }
            ImmutableSet.Builder accessibleBuilder = ImmutableSet.builder();
            count = decoder.readSmallInt();
            for (int i = 0; i < count; ++i) {
                accessibleBuilder.add((Object)this.readClassName(decoder, classNameMap));
            }
            return DependentsSet.dependentClasses((Set<String>)privateBuilder.build(), (Set<String>)accessibleBuilder.build());
        }

        private void writeDependentSet(DependentsSet dependentsSet, Map<String, Integer> classNameMap, Encoder encoder) throws IOException {
            if (dependentsSet.isDependencyToAll()) {
                encoder.writeByte((byte)1);
                encoder.writeNullableString(dependentsSet.getDescription());
            } else {
                encoder.writeByte((byte)2);
                encoder.writeSmallInt(dependentsSet.getPrivateDependentClasses().size());
                for (String className : dependentsSet.getPrivateDependentClasses()) {
                    this.writeClassName(className, classNameMap, encoder);
                }
                encoder.writeSmallInt(dependentsSet.getAccessibleDependentClasses().size());
                for (String className : dependentsSet.getAccessibleDependentClasses()) {
                    this.writeClassName(className, classNameMap, encoder);
                }
            }
        }

        private String readClassName(Decoder decoder, Map<Integer, String> classNameMap) throws IOException {
            int id = decoder.readSmallInt();
            if (id == 0) {
                id = decoder.readSmallInt();
                String className = this.interner.intern(decoder.readString());
                classNameMap.put(id, className);
                return className;
            }
            return classNameMap.get(id);
        }

        private void writeClassName(String className, Map<String, Integer> classIdMap, Encoder encoder) throws IOException {
            Integer id = classIdMap.get(className);
            if (id == null) {
                id = classIdMap.size() + 1;
                classIdMap.put(className, id);
                encoder.writeSmallInt(0);
                encoder.writeSmallInt(id);
                encoder.writeString(className);
            } else {
                encoder.writeSmallInt(id);
            }
        }
    }
}

