/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotCache;
import org.gradle.cache.GlobalCacheLocations;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.hash.HashCode;

public class SplitClasspathEntrySnapshotCache
implements ClasspathEntrySnapshotCache,
Closeable {
    private final GlobalCacheLocations globalCacheLocations;
    private final ClasspathEntrySnapshotCache globalCache;
    private final ClasspathEntrySnapshotCache localCache;

    public SplitClasspathEntrySnapshotCache(GlobalCacheLocations globalCacheLocations, ClasspathEntrySnapshotCache globalCache, ClasspathEntrySnapshotCache localCache) {
        this.globalCacheLocations = globalCacheLocations;
        this.globalCache = globalCache;
        this.localCache = localCache;
    }

    @Override
    public ClasspathEntrySnapshot get(File file, HashCode hash) {
        if (this.globalCacheLocations.isInsideGlobalCache(file.getPath())) {
            return this.globalCache.get(file, hash);
        }
        return this.localCache.get(file, hash);
    }

    @Override
    public ClasspathEntrySnapshot get(File entry, Factory<ClasspathEntrySnapshot> factory) {
        if (this.globalCacheLocations.isInsideGlobalCache(entry.getPath())) {
            return this.globalCache.get(entry, factory);
        }
        return this.localCache.get(entry, factory);
    }

    @Override
    public void close() throws IOException {
        CompositeStoppable.stoppable(this.localCache).stop();
    }
}

