/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;

public abstract class AbstractCombiningProvider<OUT, BASE, IN>
extends AbstractMinimalProvider<OUT> {
    private final Class<OUT> type;
    private final ProviderInternal<? extends BASE> left;
    private final ProviderInternal<? extends IN> right;

    public AbstractCombiningProvider(Class<OUT> type, ProviderInternal<? extends BASE> left, ProviderInternal<? extends IN> right) {
        this.type = type;
        this.left = left;
        this.right = right;
    }

    @Override
    @Nullable
    public Class<OUT> getType() {
        return this.type;
    }

    @Override
    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        return this.left.calculatePresence(consumer) && this.right.calculatePresence(consumer);
    }

    @Override
    protected ValueSupplier.Value<OUT> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        ValueSupplier.Value<BASE> leftValue = this.left.calculateValue(consumer);
        if (leftValue.isMissing()) {
            return leftValue.asType();
        }
        ValueSupplier.Value<IN> rightValue = this.right.calculateValue(consumer);
        if (rightValue.isMissing()) {
            return rightValue.asType();
        }
        return ValueSupplier.Value.of(this.map(leftValue.get(), rightValue.get()));
    }

    protected abstract OUT map(BASE var1, IN var2);

    @Override
    public String toString() {
        return String.format("combine(%s, %s)", this.left, this.right);
    }
}

