/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.nio.file.Path;
import org.gradle.api.internal.file.AbstractFileResolver;
import org.gradle.util.GUtil;

public abstract class AbstractBaseDirFileResolver
extends AbstractFileResolver {
    protected abstract File getBaseDir();

    @Override
    public String resolveAsRelativePath(Object path) {
        Path baseDir = this.getBaseDir().toPath();
        Path file = this.resolve(path).toPath();
        if (file.equals(baseDir)) {
            return ".";
        }
        return baseDir.relativize(file).toString();
    }

    @Override
    public String resolveForDisplay(Object path) {
        Path baseDir;
        Path file = this.resolve(path).toPath();
        if (file.equals(baseDir = this.getBaseDir().toPath())) {
            return ".";
        }
        Path parent = baseDir.getParent();
        if (parent == null) {
            parent = baseDir;
        }
        if (file.startsWith(parent)) {
            return baseDir.relativize(file).toString();
        }
        return file.toString();
    }

    @Override
    protected File doResolve(Object path) {
        if (!GUtil.isTrue(path)) {
            throw new IllegalArgumentException(String.format("path may not be null or empty string. path='%s'", path));
        }
        File file = this.convertObjectToFile(path);
        if (file == null) {
            throw new IllegalArgumentException(String.format("Cannot convert path to File. path='%s'", path));
        }
        if (!file.isAbsolute()) {
            File baseDir = this.getBaseDir();
            if (!GUtil.isTrue(baseDir)) {
                throw new IllegalArgumentException(String.format("baseDir may not be null or empty string. basedir='%s'", baseDir));
            }
            file = new File(baseDir, file.getPath());
        }
        return file;
    }

    @Override
    public boolean canResolveRelativePath() {
        return true;
    }
}

