/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions;

import java.util.Set;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.AbstractModuleVersionsCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.ModuleAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.ModuleVersionsCacheEntry;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.util.BuildCommencedTimeProvider;

public class TwoStageModuleVersionsCache
extends AbstractModuleVersionsCache {
    private final AbstractModuleVersionsCache readOnlyCache;
    private final AbstractModuleVersionsCache writableCache;

    public TwoStageModuleVersionsCache(BuildCommencedTimeProvider timeProvider, AbstractModuleVersionsCache readOnlyCache, AbstractModuleVersionsCache writableCache) {
        super(timeProvider);
        this.readOnlyCache = readOnlyCache;
        this.writableCache = writableCache;
    }

    @Override
    protected void store(ModuleAtRepositoryKey key, ModuleVersionsCacheEntry entry) {
        this.writableCache.store(key, entry);
    }

    @Override
    protected ModuleVersionsCacheEntry get(ModuleAtRepositoryKey key) {
        ModuleVersionsCacheEntry roEntry = this.readOnlyCache.get(key);
        ModuleVersionsCacheEntry writableEntry = this.writableCache.get(key);
        if (roEntry == null) {
            return writableEntry;
        }
        if (writableEntry == null) {
            return roEntry;
        }
        return new ModuleVersionsCacheEntry((Set<String>)Sets.union(roEntry.moduleVersionListing, writableEntry.moduleVersionListing), writableEntry.createTimestamp);
    }
}

