/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.util.projectWizard.ProjectTemplateFileProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

public class MavenTemplateFileProcessor
extends ProjectTemplateFileProcessor {
    @Nullable
    protected String encodeFileText(String content, VirtualFile file, Project project) throws IOException {
        if ("pom.xml".equals(file.getName())) {
            return (String)ApplicationManager.getApplication().runReadAction(() -> {
                PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("pom.xml", (FileType)XmlFileType.INSTANCE, (CharSequence)content);
                MavenDomProjectModel model2 = MavenDomUtil.getMavenDomModel(psiFile, MavenDomProjectModel.class);
                if (model2 == null) {
                    return null;
                }
                String text = psiFile.getText();
                XmlElement element = model2.getName().getXmlElement();
                if (element instanceof XmlTag) {
                    text = ((XmlTag)element).getValue().getTextRange().replace(text, MavenTemplateFileProcessor.wrap((String)"IJ_PROJECT_NAME"));
                }
                if ((element = model2.getArtifactId().getXmlElement()) instanceof XmlTag) {
                    text = ((XmlTag)element).getValue().getTextRange().replace(text, MavenTemplateFileProcessor.wrap((String)"IJ_PROJECT_NAME"));
                }
                return text;
            });
        }
        return null;
    }
}

