/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.refactorings.extract;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.util.Function;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomExclusion;
import org.jetbrains.idea.maven.dom.model.MavenDomExclusions;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.refactorings.extract.SelectMavenProjectDialog;
import org.jetbrains.idea.maven.statistics.MavenActionsUsagesCollector;

public class ExtractManagedDependenciesAction
extends BaseRefactoringAction {
    public ExtractManagedDependenciesAction() {
        this.setInjectedContext(true);
    }

    protected boolean isAvailableInEditorOnly() {
        return true;
    }

    protected boolean isEnabledOnElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            ExtractManagedDependenciesAction.$$$reportNull$$$0(0);
        }
        return false;
    }

    protected boolean isAvailableForLanguage(Language language) {
        return true;
    }

    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ExtractManagedDependenciesAction.$$$reportNull$$$0(1);
        }
        return new MyRefactoringActionHandler();
    }

    protected boolean isAvailableForFile(PsiFile file) {
        return MavenDomUtil.isMavenFile(file);
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context) {
        if (element == null) {
            ExtractManagedDependenciesAction.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            ExtractManagedDependenciesAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ExtractManagedDependenciesAction.$$$reportNull$$$0(4);
        }
        if (context == null) {
            ExtractManagedDependenciesAction.$$$reportNull$$$0(5);
        }
        if (!super.isAvailableOnElementInEditorAndFile(element, editor, file, context)) {
            return false;
        }
        return ExtractManagedDependenciesAction.findDependencyAndParent(file, editor) != null;
    }

    private static Pair<MavenDomDependency, Set<MavenDomProjectModel>> findDependencyAndParent(PsiFile file, Editor editor) {
        MavenDomDependency dependency = (MavenDomDependency)DomUtil.findDomElement((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), MavenDomDependency.class);
        if (dependency == null || ExtractManagedDependenciesAction.isManagedDependency(dependency)) {
            return null;
        }
        Set<MavenDomProjectModel> parents = ExtractManagedDependenciesAction.getParentProjects(file);
        if (parents.isEmpty()) {
            return null;
        }
        return Pair.create((Object)dependency, parents);
    }

    @NotNull
    private static Set<MavenDomProjectModel> getParentProjects(@NotNull PsiFile file) {
        MavenDomProjectModel model2;
        if (file == null) {
            ExtractManagedDependenciesAction.$$$reportNull$$$0(6);
        }
        if ((model2 = MavenDomUtil.getMavenDomModel(file, MavenDomProjectModel.class)) == null) {
            Set<MavenDomProjectModel> set = Collections.emptySet();
            if (set == null) {
                ExtractManagedDependenciesAction.$$$reportNull$$$0(7);
            }
            return set;
        }
        Set<MavenDomProjectModel> set = MavenDomProjectProcessorUtils.collectParentProjects(model2);
        if (set == null) {
            ExtractManagedDependenciesAction.$$$reportNull$$$0(8);
        }
        return set;
    }

    private static boolean isManagedDependency(@NotNull MavenDomDependency dependency) {
        if (dependency == null) {
            ExtractManagedDependenciesAction.$$$reportNull$$$0(9);
        }
        return MavenDomProjectProcessorUtils.searchManagingDependency(dependency) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/refactorings/extract/ExtractManagedDependenciesAction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/refactorings/extract/ExtractManagedDependenciesAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledOnElements";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnElementInEditorAndFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParentProjects";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isManagedDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProcessData {
        private final MavenDomProjectModel myModel;
        private final Set<MavenDomDependency> myUsages;
        private final boolean myExtractExclusions;

        public MavenDomProjectModel getModel() {
            return this.myModel;
        }

        public Set<MavenDomDependency> getUsages() {
            return this.myUsages;
        }

        public boolean isExtractExclusions() {
            return this.myExtractExclusions;
        }

        ProcessData(MavenDomProjectModel model2, Set<MavenDomDependency> usages, boolean extractExclusions) {
            this.myModel = model2;
            this.myUsages = usages;
            this.myExtractExclusions = extractExclusions;
        }
    }

    private static class MyRefactoringActionHandler
    implements RefactoringActionHandler {
        private MyRefactoringActionHandler() {
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
            if (project == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(0);
            }
            MavenActionsUsagesCollector.trigger(project, MavenActionsUsagesCollector.ActionID.ExtractManagedDependenciesAction);
            Pair<MavenDomDependency, Set<MavenDomProjectModel>> depAndParents = ExtractManagedDependenciesAction.findDependencyAndParent(file, editor);
            if (depAndParents == null) {
                return;
            }
            Set parent = (Set)depAndParents.second;
            MavenDomDependency dependency = (MavenDomDependency)depAndParents.first;
            Function<MavenDomProjectModel, Set<MavenDomDependency>> funOccurrences = MyRefactoringActionHandler.getOccurencesFunction(dependency);
            ProcessData processData = MyRefactoringActionHandler.getProcessData(project, parent, funOccurrences, dependency.getExclusions().getXmlElement() != null);
            if (processData == null) {
                return;
            }
            MavenDomProjectModel model2 = processData.getModel();
            Set<MavenDomDependency> usages = processData.getUsages();
            boolean extractExclusions = processData.isExtractExclusions();
            assert (model2 != null);
            assert (usages != null);
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])MyRefactoringActionHandler.getFiles(file, model2, usages)).run(() -> {
                String systemPath;
                String classifier;
                MavenDomDependency addedDependency = model2.getDependencyManagement().getDependencies().addDependency();
                addedDependency.getGroupId().setStringValue(dependency.getGroupId().getStringValue());
                addedDependency.getArtifactId().setStringValue(dependency.getArtifactId().getStringValue());
                addedDependency.getVersion().setStringValue(dependency.getVersion().getStringValue());
                String typeValue = dependency.getType().getStringValue();
                dependency.getVersion().undefine();
                if (typeValue != null) {
                    addedDependency.getType().setStringValue(typeValue);
                }
                if ((classifier = dependency.getClassifier().getStringValue()) != null) {
                    addedDependency.getClassifier().setStringValue(classifier);
                }
                if ((systemPath = dependency.getSystemPath().getStringValue()) != null) {
                    addedDependency.getSystemPath().setStringValue(systemPath);
                    dependency.getSystemPath().undefine();
                }
                if (extractExclusions) {
                    MavenDomExclusions addedExclusions = addedDependency.getExclusions();
                    for (MavenDomExclusion exclusion : dependency.getExclusions().getExclusions()) {
                        MavenDomExclusion domExclusion = addedExclusions.addExclusion();
                        domExclusion.getGroupId().setStringValue(exclusion.getGroupId().getStringValue());
                        domExclusion.getArtifactId().setStringValue(exclusion.getArtifactId().getStringValue());
                    }
                    dependency.getExclusions().undefine();
                }
                for (MavenDomDependency usage : usages) {
                    usage.getVersion().undefine();
                }
            });
        }

        private static PsiFile[] getFiles(@NotNull PsiFile file, @NotNull MavenDomProjectModel model2, @NotNull Set<? extends MavenDomDependency> usages) {
            if (file == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(1);
            }
            if (model2 == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(2);
            }
            if (usages == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(3);
            }
            HashSet<PsiFile> files = new HashSet<PsiFile>();
            files.add(file);
            XmlElement xmlElement = model2.getXmlElement();
            if (xmlElement != null) {
                files.add(xmlElement.getContainingFile());
            }
            for (MavenDomDependency mavenDomDependency : usages) {
                XmlElement element = mavenDomDependency.getXmlElement();
                if (element == null) continue;
                files.add(element.getContainingFile());
            }
            return PsiUtilCore.toPsiFileArray(files);
        }

        @Nullable
        private static ProcessData getProcessData(@NotNull Project project, @NotNull Set<MavenDomProjectModel> models, @NotNull Function<MavenDomProjectModel, Set<MavenDomDependency>> funOccurrences, boolean hasExclusions) {
            MavenDomProjectModel model2;
            if (project == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(4);
            }
            if (models == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(5);
            }
            if (funOccurrences == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(6);
            }
            if (models.size() == 0) {
                return null;
            }
            if (models.size() == 1 && !hasExclusions && ((Set)funOccurrences.fun((Object)(model2 = models.iterator().next()))).size() == 0) {
                return new ProcessData(model2, Collections.emptySet(), false);
            }
            SelectMavenProjectDialog dialog = new SelectMavenProjectDialog(project, models, funOccurrences, hasExclusions);
            dialog.show();
            if (dialog.getExitCode() == 0) {
                MavenDomProjectModel model3 = dialog.getSelectedProject();
                return new ProcessData(model3, dialog.isReplaceAllOccurrences() ? (Set)funOccurrences.fun((Object)model3) : Collections.emptySet(), dialog.isExtractExclusions());
            }
            return null;
        }

        private static Function<MavenDomProjectModel, Set<MavenDomDependency>> getOccurencesFunction(MavenDomDependency dependency) {
            return model2 -> {
                DependencyConflictId dependencyId = DependencyConflictId.create(dependency);
                if (dependencyId == null) {
                    return Collections.emptySet();
                }
                return MavenDomProjectProcessorUtils.searchDependencyUsages(model2, dependencyId, Collections.singleton(dependency));
            };
        }

        public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
            if (project == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(7);
            }
            if (elements == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(8);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usages";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "models";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "funOccurrences";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/dom/refactorings/extract/ExtractManagedDependenciesAction$MyRefactoringActionHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invoke";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFiles";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getProcessData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

