/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.buildtool.quickfix;

import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.server.MavenServerManager;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/buildtool/quickfix/UseBundledMavenQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "()V", "id", "", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Companion", "intellij.maven"})
public final class UseBundledMavenQuickFix
implements BuildIssueQuickFix {
    @NotNull
    private final String id;
    @NotNull
    public static final String ID = "use_bundled_maven_quick_fix";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataProvider dataProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        MavenWorkspaceSettingsComponent mavenWorkspaceSettingsComponent = MavenWorkspaceSettingsComponent.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)mavenWorkspaceSettingsComponent, (String)"MavenWorkspaceSettingsCo\u2026nent.getInstance(project)");
        MavenGeneralSettings mavenGeneralSettings = mavenWorkspaceSettingsComponent.getSettings().generalSettings;
        Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"MavenWorkspaceSettingsCo\u2026.settings.generalSettings");
        mavenGeneralSettings.setMavenHome("Bundled (Maven 3)");
        Object[] objectArray = new Object[1];
        MavenServerManager mavenServerManager = MavenServerManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)mavenServerManager, (String)"MavenServerManager.getInstance()");
        objectArray[0] = mavenServerManager.getCurrentMavenVersion();
        new Notification("Maven", "", RunnerBundle.message("maven.change.version.notification", objectArray), NotificationType.INFORMATION).notify(null);
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(null)");
        return completableFuture;
    }

    public UseBundledMavenQuickFix() {
        this.id = ID;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/idea/maven/buildtool/quickfix/UseBundledMavenQuickFix$Companion;", "", "()V", "ID", "", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

