/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.util;

import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0005\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0006\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0007\u00a8\u0006\b"}, d2={"isInUnitTest", "", "format", "", "Lcom/intellij/debugger/engine/JavaStackFrame;", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "Lcom/intellij/debugger/memory/utils/StackFrameItem;", "Lcom/sun/jdi/Location;", "kotlin.jvm-debugger.coroutines"})
public final class KUtilsKt {
    @NotNull
    public static final String format(@NotNull Location $this$format) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"$this$format");
        Method method = SafeUtilKt.safeMethod((Location)$this$format);
        StringBuilder stringBuilder = new StringBuilder();
        Object object = method;
        if (object == null || (object = object.name()) == null) {
            object = "noname";
        }
        StringBuilder stringBuilder2 = stringBuilder.append((String)object).append(':').append(SafeUtilKt.safeLineNumber((Location)$this$format)).append(", ");
        Object object2 = method;
        if (object2 == null || (object2 = object2.declaringType()) == null || (object2 = object2.name()) == null) {
            object2 = "empty";
        }
        return stringBuilder2.append((String)object2).toString();
    }

    @NotNull
    public static final String format(@NotNull JavaStackFrame $this$format) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"$this$format");
        StackFrameDescriptorImpl stackFrameDescriptorImpl = $this$format.getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)stackFrameDescriptorImpl, (String)"descriptor");
        Location location2 = stackFrameDescriptorImpl.getLocation();
        Object object = location2;
        if (object == null || (object = KUtilsKt.format((Location)object)) == null) {
            object = "emptyLocation";
        }
        return object;
    }

    @NotNull
    public static final String format(@NotNull StackFrameItem $this$format) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"$this$format");
        String string = $this$format.method();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.method()");
        String method = string;
        String string2 = $this$format.path();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.path()");
        String type = string2;
        int lineNumber = $this$format.line();
        return method + ':' + lineNumber + ", " + type;
    }

    @NotNull
    public static final String format(@NotNull StackFrameProxyImpl $this$format) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"$this$format");
        Object object = SafeUtilKt.safeLocation((StackFrameProxy)((StackFrameProxy)$this$format));
        if (object == null || (object = KUtilsKt.format((Location)object)) == null) {
            object = "emptyLocation";
        }
        return object;
    }

    public static final boolean isInUnitTest() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        return application.isUnitTestMode();
    }
}

