/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.TestOnly;

public abstract class WaitFor {
    private static final int DEFAULT_STEP = 10;
    private static final int MAX_TIMEOUT = 60000;
    private long myWaitTime;
    private boolean myInterrupted;
    private volatile boolean myConditionRealized;
    private Future<?> myThread;

    public WaitFor() {
        this(60000);
    }

    public WaitFor(int timeoutMsecs) {
        this(timeoutMsecs, 10);
    }

    public WaitFor(int timeoutMsecs, int step) {
        long started = System.currentTimeMillis();
        long deadline = timeoutMsecs == -1 ? Long.MAX_VALUE : started + (long)timeoutMsecs;
        this.myConditionRealized = false;
        try {
            while (!(this.myConditionRealized = this.condition()) && System.currentTimeMillis() < deadline) {
                Thread.sleep(step);
            }
        }
        catch (InterruptedException e) {
            this.myInterrupted = true;
        }
        this.myWaitTime = System.currentTimeMillis() - started;
    }

    public WaitFor(int timeoutMsecs, Runnable toRunOnTrue) {
        this.myThread = AppExecutorUtil.getAppExecutorService().submit(() -> {
            this.myConditionRealized = new WaitFor(timeoutMsecs){

                @Override
                protected boolean condition() {
                    return WaitFor.this.condition();
                }
            }.isConditionRealized();
            if (this.myConditionRealized) {
                toRunOnTrue.run();
            }
        });
    }

    public long getWaitedTime() {
        return this.myWaitTime;
    }

    public boolean isConditionRealized() {
        return this.myConditionRealized;
    }

    public boolean isInterrupted() {
        return this.myInterrupted;
    }

    protected abstract boolean condition();

    public void assertCompleted() {
        this.assertCompleted("");
    }

    public void assertCompleted(String message) {
        assert (this.condition()) : message;
    }

    @TestOnly
    public void join() throws InterruptedException, ExecutionException {
        Future<?> thread = this.myThread;
        if (thread != null) {
            thread.get();
        }
    }
}

