/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling;

import org.gradle.api.Project;
import org.gradle.internal.impldep.com.google.gson.GsonBuilder;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.MessageBuilder;

public final class ErrorMessageBuilder {
    @NotNull
    private final Project myProject;
    @Nullable
    private final Exception myException;
    @NotNull
    private final String myGroup;
    @Nullable
    private String myDescription;

    private ErrorMessageBuilder(@NotNull Project project, @Nullable Exception exception, @NotNull String group) {
        if (project == null) {
            ErrorMessageBuilder.$$$reportNull$$$0(0);
        }
        if (group == null) {
            ErrorMessageBuilder.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myException = exception;
        this.myGroup = group;
    }

    public static ErrorMessageBuilder create(@NotNull Project project, @NotNull String group) {
        if (project == null) {
            ErrorMessageBuilder.$$$reportNull$$$0(2);
        }
        if (group == null) {
            ErrorMessageBuilder.$$$reportNull$$$0(3);
        }
        return new ErrorMessageBuilder(project, null, group);
    }

    public static ErrorMessageBuilder create(@NotNull Project project, @Nullable Exception exception, @NotNull String group) {
        if (project == null) {
            ErrorMessageBuilder.$$$reportNull$$$0(4);
        }
        if (group == null) {
            ErrorMessageBuilder.$$$reportNull$$$0(5);
        }
        return new ErrorMessageBuilder(project, exception, group);
    }

    public ErrorMessageBuilder withDescription(@NotNull String description) {
        if (description == null) {
            ErrorMessageBuilder.$$$reportNull$$$0(6);
        }
        this.myDescription = description;
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public String build() {
        Message message = this.buildMessage();
        return new GsonBuilder().create().toJson((Object)message);
    }

    @ApiStatus.Internal
    public Message buildMessage() {
        String message = this.myDescription != null ? this.myDescription : "";
        String projectDisplayName = ErrorMessageBuilder.getDisplayName(this.myProject);
        String title = null;
        if (this.myException != null) {
            title = ErrorMessageBuilder.getRootCauseMessage(this.myException);
        }
        if (title == null) {
            title = this.myDescription != null ? this.myDescription : this.myGroup;
        }
        title = projectDisplayName + ": " + title;
        return MessageBuilder.create(title, message).warning().withException(this.myException).withGroup(this.myGroup).withLocation(this.myProject.getBuildFile().getPath(), 0, 0).build();
    }

    @NotNull
    private static String getDisplayName(@NotNull Project project) {
        String projectDisplayName;
        if (project == null) {
            ErrorMessageBuilder.$$$reportNull$$$0(7);
        }
        if (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"3.3")) < 0) {
            StringBuilder builder = new StringBuilder();
            if (project.getParent() == null && project.getGradle().getParent() == null) {
                builder.append("root project '");
                builder.append(project.getName());
                builder.append('\'');
            } else {
                builder.append("project '");
                builder.append(project.getPath());
                builder.append("'");
            }
            projectDisplayName = builder.toString();
        } else {
            projectDisplayName = project.getDisplayName();
        }
        String string = projectDisplayName;
        if (string == null) {
            ErrorMessageBuilder.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    private static String getRootCauseMessage(@NotNull Throwable t) {
        if (t == null) {
            ErrorMessageBuilder.$$$reportNull$$$0(9);
        }
        Throwable e = t;
        while (true) {
            if (e.getCause() == null) {
                String message = e.getMessage();
                return message == null ? t.getMessage() : message;
            }
            e = e.getCause();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/tooling/ErrorMessageBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/ErrorMessageBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withDescription";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRootCauseMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

