/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ExceptionUtilRt;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.UnknownModelException;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.adapter.TargetTypeProvider;
import org.gradle.tooling.internal.gradle.DefaultBuildIdentifier;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.ProjectIdentifier;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.Build;
import org.jetbrains.plugins.gradle.model.LegacyIdeaProjectModelAdapter;
import org.jetbrains.plugins.gradle.model.ModelsHolder;
import org.jetbrains.plugins.gradle.model.Project;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;
import org.jetbrains.plugins.gradle.model.internal.DummyModel;
import org.jetbrains.plugins.gradle.model.internal.TurnOffDefaultTasks;
import org.jetbrains.plugins.gradle.tooling.Exceptions;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingSerializer;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.IdeaProjectSerializationService;

public final class ProjectImportAction
implements BuildAction<AllModels>,
Serializable {
    private final Set<ProjectImportModelProvider> myProjectsLoadedModelProviders = new HashSet<ProjectImportModelProvider>();
    private final Set<ProjectImportModelProvider> myBuildFinishedModelProviders = new HashSet<ProjectImportModelProvider>();
    private final Set<Class<?>> myTargetTypes = new HashSet();
    private final boolean myIsPreviewMode;
    private final boolean myIsCompositeBuildsSupported;
    private final boolean myUseCustomSerialization;
    private boolean myUseProjectsLoadedPhase;
    private AllModels myAllModels = null;
    @Nullable
    private transient GradleBuild myGradleBuild;
    private ToolingSerializerAdapter mySerializer;

    public ProjectImportAction(boolean isPreviewMode) {
        this(isPreviewMode, false, false);
    }

    public ProjectImportAction(boolean isPreviewMode, boolean isCompositeBuildsSupported, boolean useCustomSerialization) {
        this.myIsPreviewMode = isPreviewMode;
        this.myIsCompositeBuildsSupported = isCompositeBuildsSupported;
        this.myUseCustomSerialization = useCustomSerialization;
    }

    public void addProjectImportModelProvider(@NotNull ProjectImportModelProvider provider) {
        if (provider == null) {
            ProjectImportAction.$$$reportNull$$$0(0);
        }
        this.addProjectImportModelProvider(provider, false);
    }

    public void addProjectImportModelProvider(@NotNull ProjectImportModelProvider provider, boolean isProjectLoadedProvider) {
        if (provider == null) {
            ProjectImportAction.$$$reportNull$$$0(1);
        }
        if (isProjectLoadedProvider) {
            this.myProjectsLoadedModelProviders.add(provider);
        } else {
            this.myBuildFinishedModelProviders.add(provider);
        }
    }

    public void addTargetTypes(@NotNull Set<Class<?>> targetTypes) {
        if (targetTypes == null) {
            ProjectImportAction.$$$reportNull$$$0(2);
        }
        this.myTargetTypes.addAll(targetTypes);
    }

    public void prepareForPhasedExecuter() {
        this.myUseProjectsLoadedPhase = true;
    }

    public void prepareForNonPhasedExecuter() {
        this.myUseProjectsLoadedPhase = false;
    }

    @Nullable
    public AllModels execute(BuildController controller) {
        boolean isProjectsLoadedAction;
        this.configureAdditionalTypes(controller);
        boolean bl = isProjectsLoadedAction = this.myAllModels == null && this.myUseProjectsLoadedPhase;
        if (isProjectsLoadedAction || !this.myUseProjectsLoadedPhase) {
            long startTime = System.currentTimeMillis();
            this.myGradleBuild = controller.getBuildModel();
            AllModels allModels = new AllModels(ProjectImportAction.convert(this.myGradleBuild));
            allModels.logPerformance("Get model GradleBuild", System.currentTimeMillis() - startTime);
            long startTimeBuildEnv = System.currentTimeMillis();
            BuildEnvironment buildEnvironment = (BuildEnvironment)controller.findModel(BuildEnvironment.class);
            allModels.setBuildEnvironment(buildEnvironment);
            allModels.logPerformance("Get model BuildEnvironment", System.currentTimeMillis() - startTimeBuildEnv);
            this.myAllModels = allModels;
            this.mySerializer = new ToolingSerializerAdapter(controller);
        }
        assert (this.myGradleBuild != null);
        assert (this.mySerializer != null);
        controller = new MyBuildController(controller, this.myGradleBuild);
        for (BasicGradleProject gradleProject : this.myGradleBuild.getProjects()) {
            this.addProjectModels(this.mySerializer, controller, this.myAllModels, gradleProject, isProjectsLoadedAction);
        }
        this.addBuildModels(this.mySerializer, controller, this.myAllModels, this.myGradleBuild, isProjectsLoadedAction);
        if (this.myIsCompositeBuildsSupported) {
            for (GradleBuild includedBuild : this.myGradleBuild.getIncludedBuilds()) {
                if (!isProjectsLoadedAction) {
                    this.myAllModels.getIncludedBuilds().add(ProjectImportAction.convert(includedBuild));
                }
                for (BasicGradleProject project : includedBuild.getProjects()) {
                    this.addProjectModels(this.mySerializer, controller, this.myAllModels, project, isProjectsLoadedAction);
                }
                this.addBuildModels(this.mySerializer, controller, this.myAllModels, includedBuild, isProjectsLoadedAction);
            }
        }
        if (isProjectsLoadedAction) {
            controller.getModel(TurnOffDefaultTasks.class);
        }
        return isProjectsLoadedAction && !this.myAllModels.hasModels() ? null : this.myAllModels;
    }

    @NotNull
    private static Build convert(@NotNull GradleBuild build) {
        if (build == null) {
            ProjectImportAction.$$$reportNull$$$0(3);
        }
        DefaultBuild rootProject = new DefaultBuild(build.getRootProject().getName(), build.getBuildIdentifier().getRootDir());
        for (BasicGradleProject project : build.getProjects()) {
            rootProject.addProject(project.getName(), project.getProjectIdentifier());
        }
        DefaultBuild defaultBuild = rootProject;
        if (defaultBuild == null) {
            ProjectImportAction.$$$reportNull$$$0(4);
        }
        return defaultBuild;
    }

    private void configureAdditionalTypes(BuildController controller) {
        if (this.myTargetTypes.isEmpty()) {
            return;
        }
        try {
            Field adapterField;
            try {
                adapterField = controller.getClass().getDeclaredField("adapter");
            }
            catch (NoSuchFieldException e) {
                Field delegate = controller.getClass().getDeclaredField("delegate");
                delegate.setAccessible(true);
                Object wrappedController = delegate.get(controller);
                adapterField = wrappedController.getClass().getDeclaredField("adapter");
                controller = (BuildController)wrappedController;
            }
            adapterField.setAccessible(true);
            ProtocolToModelAdapter adapter = (ProtocolToModelAdapter)adapterField.get(controller);
            Field typeProviderField = adapter.getClass().getDeclaredField("targetTypeProvider");
            typeProviderField.setAccessible(true);
            TargetTypeProvider typeProvider = (TargetTypeProvider)typeProviderField.get(adapter);
            Field targetTypesField = typeProvider.getClass().getDeclaredField("configuredTargetTypes");
            targetTypesField.setAccessible(true);
            Map targetTypes = (Map)targetTypesField.get(typeProvider);
            for (Class<?> targetType : this.myTargetTypes) {
                targetTypes.put(targetType.getCanonicalName(), targetType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addProjectModels(final @NotNull ToolingSerializerAdapter serializerAdapter, @NotNull BuildController controller, final @NotNull AllModels allModels, final @NotNull BasicGradleProject project, boolean isProjectsLoadedAction) {
        block7: {
            if (serializerAdapter == null) {
                ProjectImportAction.$$$reportNull$$$0(5);
            }
            if (controller == null) {
                ProjectImportAction.$$$reportNull$$$0(6);
            }
            if (allModels == null) {
                ProjectImportAction.$$$reportNull$$$0(7);
            }
            if (project == null) {
                ProjectImportAction.$$$reportNull$$$0(8);
            }
            try {
                Set<ProjectImportModelProvider> modelProviders = this.getModelProviders(isProjectsLoadedAction);
                for (ProjectImportModelProvider extension : modelProviders) {
                    final HashSet<String> obtainedModels = new HashSet<String>();
                    long startTime = System.currentTimeMillis();
                    ProjectImportModelProvider.ProjectModelConsumer modelConsumer = new ProjectImportModelProvider.ProjectModelConsumer(){

                        @Override
                        public void consume(@NotNull Object object, @NotNull Class clazz) {
                            if (object == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (clazz == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (ProjectImportAction.this.myUseCustomSerialization) {
                                object = serializerAdapter.serialize(object);
                            }
                            allModels.addModel(object, clazz, project);
                            obtainedModels.add(clazz.getName());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "object";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "clazz";
                                    break;
                                }
                            }
                            objectArray[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$1";
                            objectArray[2] = "consume";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    extension.populateProjectModels(controller, (Model)project, modelConsumer);
                    allModels.logPerformance("Ran extension " + extension.getClass().getName() + " for project " + project.getProjectIdentifier().getProjectPath() + " obtained " + obtainedModels.size() + " model(s): " + ProjectImportAction.joinClassNamesToString(obtainedModels), System.currentTimeMillis() - startTime);
                }
            }
            catch (Exception e) {
                if (this.myIsPreviewMode) break block7;
                throw new ExternalSystemException((Throwable)e);
            }
        }
    }

    private void addBuildModels(final @NotNull ToolingSerializerAdapter serializerAdapter, @NotNull BuildController controller, final @NotNull AllModels allModels, @NotNull GradleBuild buildModel, boolean isProjectsLoadedAction) {
        block7: {
            if (serializerAdapter == null) {
                ProjectImportAction.$$$reportNull$$$0(9);
            }
            if (controller == null) {
                ProjectImportAction.$$$reportNull$$$0(10);
            }
            if (allModels == null) {
                ProjectImportAction.$$$reportNull$$$0(11);
            }
            if (buildModel == null) {
                ProjectImportAction.$$$reportNull$$$0(12);
            }
            try {
                Set<ProjectImportModelProvider> modelProviders = this.getModelProviders(isProjectsLoadedAction);
                for (ProjectImportModelProvider extension : modelProviders) {
                    final HashSet<String> obtainedModels = new HashSet<String>();
                    long startTime = System.currentTimeMillis();
                    ProjectImportModelProvider.BuildModelConsumer modelConsumer = new ProjectImportModelProvider.BuildModelConsumer(){

                        @Override
                        public void consumeProjectModel(@NotNull ProjectModel projectModel, @NotNull Object object, @NotNull Class clazz) {
                            if (projectModel == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            if (object == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            if (clazz == null) {
                                2.$$$reportNull$$$0(2);
                            }
                            if (ProjectImportAction.this.myUseCustomSerialization) {
                                object = serializerAdapter.serialize(object);
                            }
                            allModels.addModel(object, clazz, projectModel);
                            obtainedModels.add(clazz.getName());
                        }

                        @Override
                        public void consume(@NotNull BuildModel buildModel, @NotNull Object object, @NotNull Class clazz) {
                            if (buildModel == null) {
                                2.$$$reportNull$$$0(3);
                            }
                            if (object == null) {
                                2.$$$reportNull$$$0(4);
                            }
                            if (clazz == null) {
                                2.$$$reportNull$$$0(5);
                            }
                            if (ProjectImportAction.this.myUseCustomSerialization) {
                                object = serializerAdapter.serialize(object);
                            }
                            allModels.addModel(object, clazz, buildModel);
                            obtainedModels.add(clazz.getName());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "projectModel";
                                    break;
                                }
                                case 1: 
                                case 4: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "object";
                                    break;
                                }
                                case 2: 
                                case 5: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "clazz";
                                    break;
                                }
                                case 3: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "buildModel";
                                    break;
                                }
                            }
                            objectArray2[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$2";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "consumeProjectModel";
                                    break;
                                }
                                case 3: 
                                case 4: 
                                case 5: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "consume";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    extension.populateBuildModels(controller, buildModel, modelConsumer);
                    allModels.logPerformance("Ran extension " + extension.getClass().getName() + " for build " + buildModel.getBuildIdentifier().getRootDir().getPath() + " obtained " + obtainedModels.size() + " model(s): " + ProjectImportAction.joinClassNamesToString(obtainedModels), System.currentTimeMillis() - startTime);
                }
            }
            catch (Exception e) {
                if (this.myIsPreviewMode) break block7;
                throw new ExternalSystemException((Throwable)e);
            }
        }
    }

    private Set<ProjectImportModelProvider> getModelProviders(boolean isProjectsLoadedAction) {
        LinkedHashSet<ProjectImportModelProvider> modelProviders = new LinkedHashSet<ProjectImportModelProvider>();
        if (!this.myUseProjectsLoadedPhase) {
            modelProviders.addAll(this.myProjectsLoadedModelProviders);
            modelProviders.addAll(this.myBuildFinishedModelProviders);
        } else {
            modelProviders = isProjectsLoadedAction ? this.myProjectsLoadedModelProviders : this.myBuildFinishedModelProviders;
        }
        return modelProviders;
    }

    @NotNull
    private static String joinClassNamesToString(@NotNull Set<String> names) {
        if (names == null) {
            ProjectImportAction.$$$reportNull$$$0(13);
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = names.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        String string = sb.toString();
        if (string == null) {
            ProjectImportAction.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetTypes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/model/ProjectImportAction";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializerAdapter";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allModels";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "joinClassNamesToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addProjectImportModelProvider";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addTargetTypes";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 4: 
            case 14: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addProjectModels";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addBuildModels";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "joinClassNamesToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyBuildController
    implements BuildController {
        private final BuildController myDelegate;
        private final GradleBuild myMainGradleBuild;
        private final Model myMyMainGradleBuildRootProject;

        private MyBuildController(@NotNull BuildController buildController, @NotNull GradleBuild mainGradleBuild) {
            if (buildController == null) {
                MyBuildController.$$$reportNull$$$0(0);
            }
            if (mainGradleBuild == null) {
                MyBuildController.$$$reportNull$$$0(1);
            }
            this.myDelegate = buildController;
            this.myMainGradleBuild = mainGradleBuild;
            this.myMyMainGradleBuildRootProject = this.myMainGradleBuild.getRootProject();
        }

        public <T> T getModel(Class<T> aClass) throws UnknownModelException {
            if (aClass == GradleBuild.class) {
                return (T)this.myMainGradleBuild;
            }
            return (T)this.myDelegate.getModel(this.myMyMainGradleBuildRootProject, aClass);
        }

        public <T> T findModel(Class<T> aClass) {
            if (aClass == GradleBuild.class) {
                return (T)this.myMainGradleBuild;
            }
            return (T)this.myDelegate.findModel(this.myMyMainGradleBuildRootProject, aClass);
        }

        public GradleBuild getBuildModel() {
            return this.myMainGradleBuild;
        }

        public <T> T getModel(Model model, Class<T> aClass) throws UnknownModelException {
            if (this.isMainBuild(model)) {
                return this.getModel(aClass);
            }
            return (T)this.myDelegate.getModel(model, aClass);
        }

        public <T> T findModel(Model model, Class<T> aClass) {
            if (this.isMainBuild(model)) {
                return this.findModel(aClass);
            }
            return (T)this.myDelegate.findModel(model, aClass);
        }

        public <T, P> T getModel(Class<T> aClass, Class<P> aClass1, Action<? super P> action) throws UnsupportedVersionException {
            return (T)this.myDelegate.getModel(this.myMyMainGradleBuildRootProject, aClass, aClass1, action);
        }

        public <T, P> T findModel(Class<T> aClass, Class<P> aClass1, Action<? super P> action) {
            return (T)this.myDelegate.findModel(this.myMyMainGradleBuildRootProject, aClass, aClass1, action);
        }

        public <T, P> T getModel(Model model, Class<T> aClass, Class<P> aClass1, Action<? super P> action) throws UnsupportedVersionException {
            if (this.isMainBuild(model)) {
                return this.getModel(aClass, aClass1, action);
            }
            return (T)this.myDelegate.getModel(model, aClass, aClass1, action);
        }

        public <T, P> T findModel(Model model, Class<T> aClass, Class<P> aClass1, Action<? super P> action) {
            if (this.isMainBuild(model)) {
                return this.findModel(aClass, aClass1, action);
            }
            return (T)this.myDelegate.findModel(model, aClass, aClass1, action);
        }

        private boolean isMainBuild(Model model) {
            return model == null || model == this.myMainGradleBuild;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buildController";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mainGradleBuild";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$MyBuildController";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DefaultBuild
    implements Build,
    Serializable {
        private final String myName;
        private final DefaultBuildIdentifier myBuildIdentifier;
        private final Collection<Project> myProjects = new ArrayList<Project>(0);

        private DefaultBuild(String name, File rootDir) {
            this.myName = name;
            this.myBuildIdentifier = new DefaultBuildIdentifier(rootDir);
        }

        @Override
        public String getName() {
            return this.myName;
        }

        public BuildIdentifier getBuildIdentifier() {
            return this.myBuildIdentifier;
        }

        @Override
        public Collection<Project> getProjects() {
            return this.myProjects;
        }

        private void addProject(String name, ProjectIdentifier projectIdentifier) {
            String projectPath = projectIdentifier.getProjectPath();
            File rootDir = this.myBuildIdentifier.getRootDir();
            assert (rootDir.getPath().equals(projectIdentifier.getBuildIdentifier().getRootDir().getPath()));
            this.myProjects.add(new DefaultProjectModel(name, rootDir, projectPath));
        }

        private static final class DefaultProjectModel
        implements Project,
        Serializable {
            private final String myName;
            private final DefaultProjectIdentifier myProjectIdentifier;

            private DefaultProjectModel(@NotNull String name, @NotNull File rootDir, @NotNull String projectPath) {
                if (name == null) {
                    DefaultProjectModel.$$$reportNull$$$0(0);
                }
                if (rootDir == null) {
                    DefaultProjectModel.$$$reportNull$$$0(1);
                }
                if (projectPath == null) {
                    DefaultProjectModel.$$$reportNull$$$0(2);
                }
                this.myName = name;
                this.myProjectIdentifier = new DefaultProjectIdentifier(rootDir, projectPath);
            }

            @Override
            public String getName() {
                return this.myName;
            }

            public ProjectIdentifier getProjectIdentifier() {
                return this.myProjectIdentifier;
            }

            public String toString() {
                return "ProjectModel{name='" + this.myName + '\'' + ", id=" + this.myProjectIdentifier + '}';
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rootDir";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "projectPath";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$DefaultBuild$DefaultProjectModel";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static final class ToolingSerializerAdapter {
        private final Object mySerializer;
        private final Method mySerializerWriteMethod;
        private final ClassLoader myModelBuildersClassLoader;

        private ToolingSerializerAdapter(@NotNull BuildController controller) {
            if (controller == null) {
                ToolingSerializerAdapter.$$$reportNull$$$0(0);
            }
            Object unpacked = new ProtocolToModelAdapter().unpack(controller.getModel(DummyModel.class));
            this.myModelBuildersClassLoader = unpacked.getClass().getClassLoader();
            try {
                Class<?> toolingSerializerClass = this.myModelBuildersClassLoader.loadClass(ToolingSerializer.class.getName());
                this.mySerializer = toolingSerializerClass.newInstance();
                this.mySerializerWriteMethod = toolingSerializerClass.getMethod("write", Object.class, Class.class);
                this.registerIdeaProjectSerializationService(toolingSerializerClass);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void registerIdeaProjectSerializationService(Class<?> toolingSerializerClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
            Class<?> serializationServiceClass = this.myModelBuildersClassLoader.loadClass(SerializationService.class.getName());
            final IdeaProjectSerializationService ideaProjectService = new IdeaProjectSerializationService(this.getBuildGradleVersion());
            Method register = toolingSerializerClass.getMethod("register", serializationServiceClass);
            Object proxyInstance = Proxy.newProxyInstance(this.myModelBuildersClassLoader, new Class[]{serializationServiceClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return ideaProjectService.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)ideaProjectService, args);
                }
            });
            register.invoke(this.mySerializer, proxyInstance);
        }

        @NotNull
        private GradleVersion getBuildGradleVersion() {
            GradleVersion gradleVersion;
            try {
                Class<?> gradleVersionClass = this.myModelBuildersClassLoader.loadClass("org.gradle.util.GradleVersion");
                Object buildGradleVersion = gradleVersionClass.getMethod("current", new Class[0]).invoke(gradleVersionClass, new Object[0]);
                gradleVersion = GradleVersion.version((String)gradleVersionClass.getMethod("getVersion", new Class[0]).invoke(buildGradleVersion, new Object[0]).toString());
            }
            catch (Exception e) {
                ExceptionUtilRt.rethrowUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            if (gradleVersion == null) {
                ToolingSerializerAdapter.$$$reportNull$$$0(1);
            }
            return gradleVersion;
        }

        @Nullable
        private Pair<Object, ? extends Class<?>> prepare(Object object) {
            Class modelClazz;
            if (object instanceof IdeaProject) {
                modelClazz = IdeaProject.class;
            } else {
                try {
                    object = new ProtocolToModelAdapter().unpack(object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                modelClazz = object.getClass();
                if (modelClazz.getClassLoader() != this.myModelBuildersClassLoader) {
                    return null;
                }
            }
            return Pair.pair((Object)object, modelClazz);
        }

        private Object serialize(Object object) {
            try {
                Pair<Object, ? extends Class<?>> preparedObject = this.prepare(object);
                if (preparedObject != null) {
                    return this.mySerializerWriteMethod.invoke(this.mySerializer, preparedObject.first, preparedObject.second);
                }
            }
            catch (Exception e) {
                Throwable unwrap = Exceptions.unwrap(e);
                if (object instanceof IdeaProject) {
                    ExceptionUtilRt.rethrowUnchecked((Throwable)unwrap);
                    throw new RuntimeException(unwrap);
                }
                System.err.println(ExceptionUtilRt.getThrowableText((Throwable)unwrap, (String)"org.jetbrains."));
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controller";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$ToolingSerializerAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$ToolingSerializerAdapter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuildGradleVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AllModels
    extends ModelsHolder<BuildModel, ProjectModel> {
        @NotNull
        private final List<Build> includedBuilds;
        private final Map<String, Long> performanceTrace;

        public AllModels(@NotNull Build mainBuild) {
            if (mainBuild == null) {
                AllModels.$$$reportNull$$$0(0);
            }
            super(mainBuild);
            this.includedBuilds = new ArrayList<Build>();
            this.performanceTrace = new LinkedHashMap<String, Long>();
        }

        public AllModels(@NotNull IdeaProject ideaProject) {
            if (ideaProject == null) {
                AllModels.$$$reportNull$$$0(1);
            }
            super(new LegacyIdeaProjectModelAdapter(ideaProject));
            this.includedBuilds = new ArrayList<Build>();
            this.performanceTrace = new LinkedHashMap<String, Long>();
            this.addModel(ideaProject, IdeaProject.class);
        }

        @Deprecated
        @NotNull
        public IdeaProject getIdeaProject() {
            IdeaProject ideaProject = this.getModel(IdeaProject.class);
            assert (ideaProject != null);
            IdeaProject ideaProject2 = ideaProject;
            if (ideaProject2 == null) {
                AllModels.$$$reportNull$$$0(2);
            }
            return ideaProject2;
        }

        @NotNull
        public Build getMainBuild() {
            Build build = (Build)this.getRootModel();
            if (build == null) {
                AllModels.$$$reportNull$$$0(3);
            }
            return build;
        }

        @NotNull
        public List<Build> getIncludedBuilds() {
            List<Build> list = this.includedBuilds;
            if (list == null) {
                AllModels.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Nullable
        public BuildEnvironment getBuildEnvironment() {
            return this.getModel(BuildEnvironment.class);
        }

        public void setBuildEnvironment(@Nullable BuildEnvironment buildEnvironment) {
            if (buildEnvironment != null) {
                this.addModel(buildEnvironment, BuildEnvironment.class);
            }
        }

        public void logPerformance(@NotNull String description, long millis) {
            if (description == null) {
                AllModels.$$$reportNull$$$0(5);
            }
            this.performanceTrace.put(description, millis);
        }

        public Map<String, Long> getPerformanceTrace() {
            return this.performanceTrace;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mainBuild";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ideaProject";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIdeaProject";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMainBuild";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIncludedBuilds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "logPerformance";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

