/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.ErrorMessages;

public class LongArrayAssert
extends ArrayAssert<LongArrayAssert, long[]> {
    protected LongArrayAssert(long ... actual) {
        super(LongArrayAssert.class, actual);
    }

    @Nonnull
    public LongArrayAssert contains(long ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    @Nonnull
    public LongArrayAssert containsOnly(long ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    @Nonnull
    public LongArrayAssert excludes(long ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    @Override
    @Nonnull
    public LongArrayAssert isEqualTo(@Nullable long[] expected) {
        if (Arrays.equals((long[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    @Override
    @Nonnull
    public LongArrayAssert isNotEqualTo(@Nullable long[] array) {
        if (!Arrays.equals((long[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }
}

