/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ObjectGroupAssert;
import org.fest.assertions.PropertySupport;
import org.fest.util.Lists;
import org.fest.util.Preconditions;
import org.fest.util.Sets;

public class CollectionAssert
extends ObjectGroupAssert<CollectionAssert, Collection<?>> {
    protected CollectionAssert(Collection<?> actual) {
        super(CollectionAssert.class, actual);
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((Collection)this.actual).size();
    }

    @Override
    @Nonnull
    public CollectionAssert onProperty(@Nonnull String propertyName) {
        this.isNotNull();
        Preconditions.checkNotNull((Object)propertyName);
        if (((Collection)this.actual).isEmpty()) {
            return new CollectionAssert(Collections.emptyList());
        }
        return new CollectionAssert(PropertySupport.instance().propertyValues(propertyName, (Collection)this.actual));
    }

    @Override
    @Nullable
    protected Set<Object> actualAsSet() {
        return this.actual == null ? null : Sets.newLinkedHashSet((Object[])((Collection)this.actual).toArray());
    }

    @Override
    @Nullable
    protected List<Object> actualAsList() {
        return this.actual == null ? null : Lists.newArrayList((Object[])((Collection)this.actual).toArray());
    }
}

