/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.update.AbstractCommonUpdateAction;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.ScopeInfo;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateOrStatusOptionsDialog;
import com.intellij.openapi.wm.WindowManager;
import java.awt.Component;
import java.util.LinkedHashMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.update.UpdateRootInfo;

public class AutoSvnUpdater
extends AbstractCommonUpdateAction {
    private final Project myProject;
    private final FilePath[] myRoots;

    public AutoSvnUpdater(Project project, FilePath[] roots) {
        super((ActionInfo)BlindUpdateAction.ourInstance, (ScopeInfo)new AutoUpdateScope(roots), false);
        this.myProject = project;
        this.myRoots = roots;
    }

    public static void run(@NotNull AutoSvnUpdater updater, @NlsActions.ActionText @NotNull String title) {
        if (updater == null) {
            AutoSvnUpdater.$$$reportNull$$$0(0);
        }
        if (title == null) {
            AutoSvnUpdater.$$$reportNull$$$0(1);
        }
        JComponent frame = WindowManager.getInstance().getIdeFrame(updater.myProject).getComponent();
        updater.getTemplatePresentation().setText(title);
        updater.actionPerformed(AnActionEvent.createFromAnAction((AnAction)updater, null, (String)"unknown", (DataContext)DataManager.getInstance().getDataContext((Component)frame)));
    }

    protected void actionPerformed(@NotNull VcsContext context) {
        if (context == null) {
            AutoSvnUpdater.$$$reportNull$$$0(2);
        }
        SvnConfiguration configuration17 = SvnConfiguration.getInstance(this.myProject);
        configuration17.setForceUpdate(false);
        configuration17.setUpdateDepth(Depth.INFINITY);
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        for (FilePath root : this.myRoots) {
            this.configureUpdateRootInfo(root, configuration17.getUpdateRootInfo(root.getIOFile(), vcs));
        }
        super.actionPerformed(context);
    }

    protected void configureUpdateRootInfo(@NotNull FilePath root, @NotNull UpdateRootInfo info2) {
        if (root == null) {
            AutoSvnUpdater.$$$reportNull$$$0(3);
        }
        if (info2 == null) {
            AutoSvnUpdater.$$$reportNull$$$0(4);
        }
        info2.setRevision(Revision.HEAD);
        info2.setUpdateToRevision(false);
    }

    protected boolean filterRootsBeforeAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/update/AutoSvnUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "configureUpdateRootInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class AutoUpdateScope
    implements ScopeInfo {
        private final FilePath[] myRoots;

        private AutoUpdateScope(FilePath[] roots) {
            this.myRoots = roots;
        }

        public FilePath[] getRoots(VcsContext context, ActionInfo actionInfo) {
            return this.myRoots;
        }

        public String getScopeName(VcsContext dataContext, ActionInfo actionInfo) {
            return "Subversion";
        }

        public boolean filterExistsInVcs() {
            return false;
        }
    }

    private static class BlindUpdateAction
    implements ActionInfo {
        private static final BlindUpdateAction ourInstance = new BlindUpdateAction();

        private BlindUpdateAction() {
        }

        public boolean showOptions(Project project) {
            return false;
        }

        public UpdateEnvironment getEnvironment(AbstractVcs vcs) {
            return vcs.getUpdateEnvironment();
        }

        public UpdateOrStatusOptionsDialog createOptionsDialog(Project project, LinkedHashMap<Configurable, AbstractVcs> envToConfMap, String scopeName) {
            return null;
        }

        public String getActionName(String scopeName) {
            return ActionInfo.UPDATE.getActionName(scopeName);
        }

        public String getActionName() {
            return ActionInfo.UPDATE.getActionName();
        }

        public String getGroupName(FileGroup fileGroup) {
            return ActionInfo.UPDATE.getGroupName(fileGroup);
        }

        public boolean canGroupByChangelist() {
            return ActionInfo.UPDATE.canGroupByChangelist();
        }

        public boolean canChangeFileStatus() {
            return ActionInfo.UPDATE.canChangeFileStatus();
        }
    }
}

