/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.google.common.net.UrlEscapers;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntryConsumer;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.jetbrains.idea.svn.info.Info;

public class LatestExistentSearcher {
    private static final Logger LOG = Logger.getInstance(LatestExistentSearcher.class);
    private long myStartNumber;
    private boolean myStartExistsKnown;
    @NotNull
    private final Url myUrl;
    @NotNull
    private final Url myRepositoryUrl;
    @NotNull
    private final String myRelativeUrl;
    private final SvnVcs myVcs;
    private long myEndNumber;

    public LatestExistentSearcher(SvnVcs vcs, @NotNull Url url, @NotNull Url repositoryUrl) {
        if (url == null) {
            LatestExistentSearcher.$$$reportNull$$$0(0);
        }
        if (repositoryUrl == null) {
            LatestExistentSearcher.$$$reportNull$$$0(1);
        }
        this(0L, -1L, false, vcs, url, repositoryUrl);
    }

    /*
     * WARNING - void declaration
     */
    public LatestExistentSearcher(long startNumber, long endNumber, boolean startExistsKnown, SvnVcs vcs, @NotNull Url url, @NotNull Url url2) {
        void repositoryUrl;
        void url3;
        if (url == null) {
            LatestExistentSearcher.$$$reportNull$$$0(2);
        }
        if (url2 == null) {
            LatestExistentSearcher.$$$reportNull$$$0(3);
        }
        this.myStartNumber = startNumber;
        this.myEndNumber = endNumber;
        this.myStartExistsKnown = startExistsKnown;
        this.myVcs = vcs;
        this.myUrl = url3;
        this.myRepositoryUrl = repositoryUrl;
        this.myRelativeUrl = SvnUtil.ensureStartSlash(UrlEscapers.urlFragmentEscaper().escape(SvnUtil.getRelativeUrl(this.myRepositoryUrl, this.myUrl)));
    }

    public long getDeletionRevision() {
        if (!this.detectStartRevision()) {
            return -1L;
        }
        Ref latest = new Ref((Object)-1L);
        try {
            Url existingParent;
            if (this.myEndNumber == -1L) {
                this.myEndNumber = this.getLatestRevision();
            }
            if ((existingParent = this.getExistingParent(this.myUrl)) == null) {
                return this.myStartNumber;
            }
            Revision startRevision = Revision.of(this.myStartNumber);
            Target target = Target.on(existingParent, startRevision);
            this.myVcs.getFactory(target).createHistoryClient().doLog(target, startRevision, Revision.HEAD, false, true, false, 0L, null, this.createHandler((Ref<Long>)latest));
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
        }
        return (Long)latest.get();
    }

    @NotNull
    private LogEntryConsumer createHandler(@NotNull Ref<Long> latest) {
        if (latest == null) {
            LatestExistentSearcher.$$$reportNull$$$0(4);
        }
        LogEntryConsumer logEntryConsumer = logEntry -> {
            Map<String, LogEntryPath> changedPaths = logEntry.getChangedPaths();
            for (LogEntryPath o : changedPaths.values()) {
                LogEntryPath path = o;
                if (path.getType() != 'D' || !this.myRelativeUrl.equals(path.getPath())) continue;
                latest.set((Object)logEntry.getRevision());
                throw new SvnBindException(SvnBundle.message("error.latest.existent.revision.found.for.url", this.myRelativeUrl));
            }
        };
        if (logEntryConsumer == null) {
            LatestExistentSearcher.$$$reportNull$$$0(5);
        }
        return logEntryConsumer;
    }

    public long getLatestExistent() {
        if (!this.detectStartRevision()) {
            return this.myStartNumber;
        }
        long latestOk = this.myStartNumber;
        try {
            if (this.myEndNumber == -1L) {
                this.myEndNumber = this.getLatestRevision();
            }
            for (long i = this.myStartNumber + 1L; i < this.myEndNumber; ++i) {
                if (!this.existsInRevision(this.myUrl, i)) continue;
                latestOk = i;
            }
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
        }
        return latestOk;
    }

    private boolean detectStartRevision() {
        if (!this.myStartExistsKnown) {
            SvnFileUrlMapping mapping = this.myVcs.getSvnFileUrlMapping();
            RootUrlInfo rootUrlInfo = mapping.getWcRootForUrl(this.myUrl);
            if (rootUrlInfo == null) {
                return true;
            }
            VirtualFile vf = rootUrlInfo.getVirtualFile();
            Info info2 = this.myVcs.getInfo(vf);
            if (info2 == null || !info2.getRevision().isValid()) {
                return false;
            }
            this.myStartNumber = info2.getRevision().getNumber();
            this.myStartExistsKnown = true;
        }
        return true;
    }

    @Nullable
    private Url getExistingParent(Url url) throws SvnBindException {
        while (url != null && !url.equals(this.myRepositoryUrl) && !this.existsInRevision(url, this.myEndNumber)) {
            url = SvnUtil.removePathTail(url);
        }
        return url;
    }

    private boolean existsInRevision(@NotNull Url url, long revisionNumber) throws SvnBindException {
        Info info2;
        block3: {
            if (url == null) {
                LatestExistentSearcher.$$$reportNull$$$0(6);
            }
            Revision revision = Revision.of(revisionNumber);
            info2 = null;
            try {
                info2 = this.myVcs.getInfo(url, revision, revision);
            }
            catch (SvnBindException e) {
                if (e.contains(ErrorCode.RA_ILLEGAL_URL)) break block3;
                throw e;
            }
        }
        return info2 != null;
    }

    private long getLatestRevision() throws SvnBindException {
        return SvnUtil.getHeadRevision(this.myVcs, this.myRepositoryUrl).getNumber();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryUrl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "latest";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/history/LatestExistentSearcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/history/LatestExistentSearcher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "existsInRevision";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

