/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.config;

import com.intellij.openapi.util.NlsSafe;
import java.util.HashMap;
import java.util.Map;

public class ProxyGroup {
    private String myGroupName;
    private String myPattern;
    private final Map<String, String> myProperties;

    public ProxyGroup(@NlsSafe String groupName, String patterns, Map<String, String> properties) {
        this.myGroupName = groupName;
        this.myPattern = patterns;
        this.myProperties = properties;
    }

    public Map<String, String> getProperties() {
        return this.myProperties;
    }

    public boolean isDefault() {
        return false;
    }

    public void setName(@NlsSafe String value) {
        this.myGroupName = value;
    }

    @NlsSafe
    public String getName() {
        return this.myGroupName;
    }

    public String getPort() {
        return this.myProperties.get("http-proxy-port");
    }

    public String getTimeout() {
        return this.myProperties.get("http-timeout");
    }

    public void setTimeout(String value) {
        this.myProperties.put("http-timeout", value);
    }

    public String getPatterns() {
        return this.myPattern;
    }

    public void setPatterns(String value) {
        this.myPattern = value;
    }

    protected Map<String, String> createPropertiesCopy() {
        return new HashMap<String, String>(this.myProperties);
    }

    public ProxyGroup copy() {
        return new ProxyGroup(this.myGroupName, this.myPattern, this.createPropertiesCopy());
    }
}

