/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.LightEditActionFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.jcef.DisposeHelper;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefCookieManager;
import com.intellij.ui.jcef.JBCefDisposable;
import com.intellij.ui.jcef.JBCefEventUtils;
import com.intellij.ui.jcef.JBCefFileSchemeHandlerFactory;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cef.JCefAppConfig;
import com.jetbrains.cef.JCefVersionDetails;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefMenuModel;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefContextMenuHandlerAdapter;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefFocusHandlerAdapter;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefKeyboardHandlerAdapter;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBCefBrowser
implements JBCefDisposable {
    private static final String BLANK_URI = "about:blank";
    private static final double ZOOM_COMMON_RATIO = 1.2;
    private static final double LOG_ZOOM = Math.log(1.2);
    private static final String JBCEFBROWSER_INSTANCE_PROP = "JBCefBrowser.instance";
    @NotNull
    private static final List<java.util.function.Consumer<? super JBCefBrowser>> ourOnBrowserMoveResizeCallbacks = Collections.synchronizedList(new ArrayList(1));
    @NotNull
    private final JBCefClient myCefClient;
    @NotNull
    private final JPanel myComponent;
    @NotNull
    private final CefBrowser myCefBrowser;
    @Nullable
    private volatile JBCefCookieManager myJBCefCookieManager;
    @NotNull
    private final CefFocusHandler myCefFocusHandler;
    @Nullable
    private final CefLifeSpanHandler myLifeSpanHandler;
    @NotNull
    private final CefKeyboardHandler myKeyboardHandler;
    @Nullable
    private final CefLoadHandler myLoadHandler;
    @NotNull
    private final DisposeHelper myDisposeHelper;
    private final boolean myIsDefaultClient;
    private volatile boolean myIsCefBrowserCreated;
    @Nullable
    private volatile LoadDeferrer myLoadDeferrer;
    private JDialog myDevtoolsFrame;
    protected CefContextMenuHandler myDefaultContextMenuHandler;
    private final ReentrantLock myCookieManagerLock;
    private static final LazyInitializer.NotNullValue<String> ERROR_PAGE_READER = new LazyInitializer.NotNullValue<String>(){

        @NotNull
        public String initialize() {
            try {
                return new String(FileUtil.loadBytes((InputStream)Objects.requireNonNull(JBCefApp.class.getResourceAsStream("resources/load_error.html"))), StandardCharsets.UTF_8);
            }
            catch (IOException | NullPointerException e) {
                Logger.getInstance(JBCefBrowser.class).error("couldn't find load_error.html", (Throwable)e);
                return "";
            }
        }
    };

    public JBCefBrowser(@NotNull JBCefClient client, @Nullable String url) {
        if (client == null) {
            JBCefBrowser.$$$reportNull$$$0(0);
        }
        this(client, false, url);
    }

    public JBCefBrowser(@NotNull CefBrowser cefBrowser, @NotNull JBCefClient client) {
        if (cefBrowser == null) {
            JBCefBrowser.$$$reportNull$$$0(1);
        }
        if (client == null) {
            JBCefBrowser.$$$reportNull$$$0(2);
        }
        this(cefBrowser, client, false, null);
    }

    private JBCefBrowser(@NotNull JBCefClient client, boolean isDefaultClient, @Nullable String url) {
        if (client == null) {
            JBCefBrowser.$$$reportNull$$$0(3);
        }
        this(null, client, isDefaultClient, url);
    }

    private JBCefBrowser(@Nullable CefBrowser cefBrowser, @NotNull JBCefClient client, boolean isDefaultClient, @Nullable String url) {
        if (client == null) {
            JBCefBrowser.$$$reportNull$$$0(4);
        }
        this.myDisposeHelper = new DisposeHelper();
        this.myDevtoolsFrame = null;
        this.myCookieManagerLock = new ReentrantLock();
        if (client.isDisposed()) {
            throw new IllegalArgumentException("JBCefClient is disposed");
        }
        this.myCefClient = client;
        this.myIsDefaultClient = isDefaultClient;
        this.myComponent = SystemInfoRt.isWindows ? new JPanel(new BorderLayout()){

            @Override
            public void removeNotify() {
                if (JBCefBrowser.this.myCefBrowser.getUIComponent().hasFocus()) {
                    JBCefBrowser.this.myCefBrowser.setFocus(false);
                }
                super.removeNotify();
            }
        } : new JPanel(new BorderLayout());
        this.myComponent.setBackground(JBColor.background());
        this.myCefBrowser = cefBrowser != null ? cefBrowser : this.myCefClient.getCefClient().createBrowser(url != null ? url : BLANK_URI, JBCefApp.isOffScreenRenderingMode(), false);
        Component uiComp = this.myCefBrowser.getUIComponent();
        this.myComponent.putClientProperty(JBCEFBROWSER_INSTANCE_PROP, this);
        if (SystemInfoRt.isMac) {
            ShortcutProvider.registerShortcuts(this.myComponent, this);
        }
        this.myComponent.add(uiComp, "Center");
        this.myComponent.setFocusCycleRoot(true);
        this.myComponent.setFocusTraversalPolicyProvider(true);
        this.myComponent.setFocusTraversalPolicy(new MyFTP());
        this.myComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ourOnBrowserMoveResizeCallbacks.forEach(callback -> callback.accept(JBCefBrowser.this));
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                ourOnBrowserMoveResizeCallbacks.forEach(callback -> callback.accept(JBCefBrowser.this));
            }

            @Override
            public void componentShown(ComponentEvent e) {
                ourOnBrowserMoveResizeCallbacks.forEach(callback -> callback.accept(JBCefBrowser.this));
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ourOnBrowserMoveResizeCallbacks.forEach(callback -> callback.accept(JBCefBrowser.this));
            }
        });
        if (cefBrowser == null) {
            this.myLoadHandler = new CefLoadHandlerAdapter(){
                volatile String lastLoadUrl = "";

                public void onLoadStart(CefBrowser browser, CefFrame frame, CefRequest.TransitionType transitionType) {
                    this.lastLoadUrl = frame.getURL();
                }

                public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                    if (this.lastLoadUrl.equals(failedUrl)) {
                        UIUtil.invokeLaterIfNeeded(() -> JBCefBrowser.this.loadErrorPage(errorText, failedUrl));
                    }
                }
            };
            this.myCefClient.addLoadHandler(this.myLoadHandler, this.myCefBrowser);
            this.myLifeSpanHandler = new CefLifeSpanHandlerAdapter(){

                public void onAfterCreated(CefBrowser browser) {
                    JBCefBrowser.this.myIsCefBrowserCreated = true;
                    LoadDeferrer loader = JBCefBrowser.this.myLoadDeferrer;
                    if (loader != null) {
                        loader.load(browser);
                        JBCefBrowser.this.myLoadDeferrer = null;
                    }
                }
            };
            this.myCefClient.addLifeSpanHandler(this.myLifeSpanHandler, this.myCefBrowser);
        } else {
            this.myLifeSpanHandler = null;
            this.myLoadHandler = null;
        }
        this.myCefFocusHandler = new CefFocusHandlerAdapter(){

            public boolean onSetFocus(CefBrowser browser, CefFocusHandler.FocusSource source) {
                if (source == CefFocusHandler.FocusSource.FOCUS_SOURCE_NAVIGATION) {
                    if (SystemInfoRt.isWindows) {
                        JBCefBrowser.this.myCefBrowser.setFocus(false);
                    }
                    return true;
                }
                if (SystemInfoRt.isLinux) {
                    browser.getUIComponent().requestFocus();
                } else {
                    browser.getUIComponent().requestFocusInWindow();
                }
                return false;
            }
        };
        this.myCefClient.addFocusHandler(this.myCefFocusHandler, this.myCefBrowser);
        if (SystemInfoRt.isWindows) {
            this.myCefBrowser.getUIComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (JBCefBrowser.this.myCefBrowser.getUIComponent().isFocusable()) {
                        JBCefBrowser.this.myCefBrowser.setFocus(true);
                    }
                }
            });
        }
        this.myKeyboardHandler = new CefKeyboardHandlerAdapter(){

            public boolean onKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent cefKeyEvent) {
                boolean consume;
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                boolean bl = consume = focusOwner != browser.getUIComponent();
                if (consume && SystemInfoRt.isMac && JBCefEventUtils.isUpDownKeyEvent(cefKeyEvent)) {
                    return true;
                }
                Window focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                if (focusedWindow == null) {
                    return true;
                }
                KeyEvent javaKeyEvent = JBCefEventUtils.convertCefKeyEvent(cefKeyEvent, focusedWindow);
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(javaKeyEvent);
                return consume;
            }
        };
        this.myCefClient.addKeyboardHandler(this.myKeyboardHandler, this.myCefBrowser);
        this.myDefaultContextMenuHandler = this.createDefaultContextMenuHandler();
        this.myCefClient.addContextMenuHandler(this.myDefaultContextMenuHandler, this.getCefBrowser());
    }

    protected DefaultCefContextMenuHandler createDefaultContextMenuHandler() {
        boolean isInternal = ApplicationManager.getApplication().isInternal();
        return new DefaultCefContextMenuHandler(isInternal);
    }

    public void loadURL(@NotNull String url) {
        if (url == null) {
            JBCefBrowser.$$$reportNull$$$0(5);
        }
        if (this.myIsCefBrowserCreated) {
            this.myCefBrowser.loadURL(url);
        } else {
            this.myLoadDeferrer = LoadDeferrer.urlDeferrer(url);
        }
    }

    public void loadHTML(@NotNull String html, @NotNull String url) {
        if (html == null) {
            JBCefBrowser.$$$reportNull$$$0(6);
        }
        if (url == null) {
            JBCefBrowser.$$$reportNull$$$0(7);
        }
        if (this.myIsCefBrowserCreated) {
            JBCefBrowser.loadString(this.myCefBrowser, html, url);
        } else {
            this.myLoadDeferrer = LoadDeferrer.htmlDeferrer(html, url);
        }
    }

    public void loadHTML(@NotNull String html) {
        if (html == null) {
            JBCefBrowser.$$$reportNull$$$0(8);
        }
        this.loadHTML(html, BLANK_URI);
    }

    private static void loadString(CefBrowser cefBrowser, String html, String url) {
        url = JBCefFileSchemeHandlerFactory.registerLoadHTMLRequest(cefBrowser, html, url);
        cefBrowser.loadURL(url);
    }

    public JBCefBrowser() {
        this(JBCefApp.getInstance().createClient(), true, null);
    }

    public JBCefBrowser(@NotNull String url) {
        if (url == null) {
            JBCefBrowser.$$$reportNull$$$0(9);
        }
        this(JBCefApp.getInstance().createClient(), true, url);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            JBCefBrowser.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    @NotNull
    public CefBrowser getCefBrowser() {
        CefBrowser cefBrowser = this.myCefBrowser;
        if (cefBrowser == null) {
            JBCefBrowser.$$$reportNull$$$0(11);
        }
        return cefBrowser;
    }

    public void setZoomLevel(double zoomLevel) {
        this.myCefBrowser.setZoomLevel(Math.log(zoomLevel) / LOG_ZOOM);
    }

    public double getZoomLevel() {
        return Math.pow(1.2, this.myCefBrowser.getZoomLevel());
    }

    @NotNull
    public JBCefClient getJBCefClient() {
        JBCefClient jBCefClient = this.myCefClient;
        if (jBCefClient == null) {
            JBCefBrowser.$$$reportNull$$$0(12);
        }
        return jBCefClient;
    }

    @NotNull
    public JBCefCookieManager getJBCefCookieManager() {
        this.myCookieManagerLock.lock();
        if (this.myJBCefCookieManager == null) {
            this.myJBCefCookieManager = new JBCefCookieManager();
        }
        JBCefCookieManager jBCefCookieManager = Objects.requireNonNull(this.myJBCefCookieManager);
        JBCefCookieManager jBCefCookieManager2 = jBCefCookieManager;
        if (jBCefCookieManager2 == null) {
            JBCefBrowser.$$$reportNull$$$0(13);
        }
        return jBCefCookieManager2;
        finally {
            this.myCookieManagerLock.unlock();
        }
    }

    public void setJBCefCookieManager(@NotNull JBCefCookieManager jBCefCookieManager) {
        if (jBCefCookieManager == null) {
            JBCefBrowser.$$$reportNull$$$0(14);
        }
        this.myCookieManagerLock.lock();
        try {
            this.myJBCefCookieManager = jBCefCookieManager;
        }
        finally {
            this.myCookieManagerLock.unlock();
        }
    }

    @Nullable
    private static Window getActiveFrame() {
        for (Frame frame : Frame.getFrames()) {
            if (!frame.isActive()) continue;
            return frame;
        }
        return null;
    }

    public void openDevtools() {
        if (this.myDevtoolsFrame != null) {
            this.myDevtoolsFrame.toFront();
            return;
        }
        Window activeFrame = JBCefBrowser.getActiveFrame();
        if (activeFrame == null) {
            return;
        }
        Rectangle bounds = activeFrame.getGraphicsConfiguration().getBounds();
        this.myDevtoolsFrame = new JDialog(activeFrame);
        this.myDevtoolsFrame.setTitle("JCEF DevTools");
        this.myDevtoolsFrame.setDefaultCloseOperation(2);
        this.myDevtoolsFrame.setBounds(bounds.width / 4 + 100, bounds.height / 4 + 100, bounds.width / 2, bounds.height / 2);
        this.myDevtoolsFrame.setLayout(new BorderLayout());
        final JBCefBrowser devTools = new JBCefBrowser(this.myCefBrowser.getDevTools(), this.myCefClient);
        this.myDevtoolsFrame.add((Component)devTools.getComponent(), "Center");
        this.myDevtoolsFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                JBCefBrowser.this.myDevtoolsFrame = null;
                Disposer.dispose((Disposable)devTools);
            }
        });
        this.myDevtoolsFrame.setVisible(true);
    }

    public void dispose() {
        this.myDisposeHelper.dispose(() -> {
            this.myCefClient.removeFocusHandler(this.myCefFocusHandler, this.myCefBrowser);
            this.myCefClient.removeKeyboardHandler(this.myKeyboardHandler, this.myCefBrowser);
            if (this.myLifeSpanHandler != null) {
                this.myCefClient.removeLifeSpanHandler(this.myLifeSpanHandler, this.myCefBrowser);
            }
            if (this.myLoadHandler != null) {
                this.myCefClient.removeLoadHandler(this.myLoadHandler, this.myCefBrowser);
            }
            this.myCefBrowser.stopLoad();
            this.myCefBrowser.close(true);
            if (this.myIsDefaultClient) {
                Disposer.dispose((Disposable)this.myCefClient);
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposeHelper.isDisposed();
    }

    boolean isCefBrowserCreated() {
        return this.myIsCefBrowserCreated;
    }

    @Nullable
    public static JBCefBrowser getJBCefBrowser(@NotNull CefBrowser browser) {
        Container parentComp;
        Component uiComp;
        if (browser == null) {
            JBCefBrowser.$$$reportNull$$$0(15);
        }
        if ((uiComp = browser.getUIComponent()) != null && (parentComp = uiComp.getParent()) instanceof JComponent) {
            return (JBCefBrowser)((JComponent)parentComp).getClientProperty(JBCEFBROWSER_INSTANCE_PROP);
        }
        return null;
    }

    public static void addOnBrowserMoveResizeCallback(@NotNull java.util.function.Consumer<? super JBCefBrowser> callback) {
        if (callback == null) {
            JBCefBrowser.$$$reportNull$$$0(16);
        }
        ourOnBrowserMoveResizeCallbacks.add(callback);
    }

    public static void removeOnBrowserMoveResizeCallback(@NotNull java.util.function.Consumer<? super JBCefBrowser> callback) {
        if (callback == null) {
            JBCefBrowser.$$$reportNull$$$0(17);
        }
        ourOnBrowserMoveResizeCallbacks.remove(callback);
    }

    private void loadErrorPage(@NotNull String errorText, @NotNull String failedUrl) {
        if (errorText == null) {
            JBCefBrowser.$$$reportNull$$$0(18);
        }
        if (failedUrl == null) {
            JBCefBrowser.$$$reportNull$$$0(19);
        }
        int fontSize = (int)((double)EditorColorsManager.getInstance().getGlobalScheme().getEditorFontSize() * 1.1);
        int headerFontSize = fontSize + JBUIScale.scale((int)3);
        int headerPaddingTop = headerFontSize / 5;
        int lineHeight = headerFontSize * 2;
        int iconPaddingRight = JBUIScale.scale((int)12);
        Color bgColor = JBColor.background();
        String bgWebColor = String.format("#%02x%02x%02x", bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue());
        Color fgColor = JBColor.foreground();
        String fgWebColor = String.format("#%02x%02x%02x", fgColor.getRed(), fgColor.getGreen(), fgColor.getBlue());
        String html = (String)ERROR_PAGE_READER.get();
        html = html.replace("${lineHeight}", String.valueOf(lineHeight));
        html = html.replace("${iconPaddingRight}", String.valueOf(iconPaddingRight));
        html = html.replace("${fontSize}", String.valueOf(fontSize));
        html = html.replace("${headerFontSize}", String.valueOf(headerFontSize));
        html = html.replace("${headerPaddingTop}", String.valueOf(headerPaddingTop));
        html = html.replace("${bgWebColor}", bgWebColor);
        html = html.replace("${fgWebColor}", fgWebColor);
        html = html.replace("${errorText}", errorText);
        html = html.replace("${failedUrl}", failedUrl);
        this.loadHTML(html);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cefBrowser";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefBrowser";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jBCefCookieManager";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorText";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefBrowser";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCefBrowser";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getJBCefClient";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getJBCefCookieManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadURL";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadHTML";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setJBCefCookieManager";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getJBCefBrowser";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addOnBrowserMoveResizeCallback";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeOnBrowserMoveResizeCallback";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadErrorPage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyFTP
    extends FocusTraversalPolicy {
        private MyFTP() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }
    }

    protected class DefaultCefContextMenuHandler
    extends CefContextMenuHandlerAdapter {
        protected static final int DEBUG_COMMAND_ID = 28500;
        private final boolean isInternal;

        public DefaultCefContextMenuHandler(boolean isInternal) {
            this.isInternal = isInternal;
        }

        public void onBeforeContextMenu(CefBrowser browser, CefFrame frame, CefContextMenuParams params, CefMenuModel model) {
            if (this.isInternal) {
                model.addItem(28500, "Open DevTools");
            }
        }

        public boolean onContextMenuCommand(CefBrowser browser, CefFrame frame, CefContextMenuParams params, int commandId, int eventFlags) {
            if (commandId == 28500) {
                JBCefBrowser.this.openDevtools();
                return true;
            }
            return false;
        }
    }

    private static final class ShortcutProvider {
        private static final List<Pair<String, AnAction>> ourActions = ShortcutProvider.isSupportedByJCefApi() ? List.of(ShortcutProvider.createAction("$Cut", CefFrame::cut), ShortcutProvider.createAction("$Copy", CefFrame::copy), ShortcutProvider.createAction("$Paste", CefFrame::paste), ShortcutProvider.createAction("$Delete", CefFrame::delete), ShortcutProvider.createAction("$SelectAll", CefFrame::selectAll), ShortcutProvider.createAction("$Undo", CefFrame::undo), ShortcutProvider.createAction("$Redo", CefFrame::redo)) : List.of();

        private ShortcutProvider() {
        }

        private static boolean isSupportedByJCefApi() {
            try {
                JCefAppConfig.getVersionDetails();
                return true;
            }
            catch (JCefVersionDetails.VersionUnavailableException | NoSuchMethodError e) {
                Logger.getInstance(ShortcutProvider.class).warn("JCEF shortcuts are unavailable (incompatible API)", e);
                return false;
            }
        }

        private static Pair<String, AnAction> createAction(String shortcut, java.util.function.Consumer<CefFrame> action) {
            return Pair.create((Object)shortcut, (Object)LightEditActionFactory.create((Consumer<? super AnActionEvent>)((Consumer)event -> {
                Component component = event.getData(PlatformDataKeys.CONTEXT_COMPONENT);
                if (component == null) {
                    return;
                }
                Container parentComponent = component.getParent();
                if (!(parentComponent instanceof JComponent)) {
                    return;
                }
                Object browser = ((JComponent)parentComponent).getClientProperty(JBCefBrowser.JBCEFBROWSER_INSTANCE_PROP);
                if (!(browser instanceof JBCefBrowser)) {
                    return;
                }
                action.accept(((JBCefBrowser)browser).getCefBrowser().getFocusedFrame());
            })));
        }

        private static void registerShortcuts(JComponent uiComp, JBCefBrowser jbCefBrowser) {
            ActionManager actionManager = ActionManager.getInstance();
            for (Pair<String, AnAction> action : ourActions) {
                ((AnAction)action.second).registerCustomShortcutSet(actionManager.getAction((String)action.first).getShortcutSet(), uiComp, jbCefBrowser);
            }
        }
    }

    private static final class LoadDeferrer {
        @Nullable
        private final String myHtml;
        @NotNull
        private final String myUrl;

        private LoadDeferrer(@Nullable String html, @NotNull String url) {
            if (url == null) {
                LoadDeferrer.$$$reportNull$$$0(0);
            }
            this.myHtml = html;
            this.myUrl = url;
        }

        @NotNull
        public static LoadDeferrer urlDeferrer(String url) {
            return new LoadDeferrer(null, url);
        }

        @NotNull
        public static LoadDeferrer htmlDeferrer(String html, String url) {
            return new LoadDeferrer(html, url);
        }

        public void load(@NotNull CefBrowser browser) {
            if (browser == null) {
                LoadDeferrer.$$$reportNull$$$0(1);
            }
            SwingUtilities.invokeLater(this.myHtml == null ? () -> browser.loadURL(this.myUrl) : () -> JBCefBrowser.loadString(browser, this.myHtml, this.myUrl));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "browser";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/jcef/JBCefBrowser$LoadDeferrer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "load";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

