/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComboBoxTableRenderer<T>
extends JLabel
implements TableCellRenderer,
TableCellEditor,
JBPopupListener {
    private final T[] myValues;
    private WeakReference<ListPopup> myPopupRef;
    private ChangeEvent myChangeEvent = null;
    private T myValue;
    private int myClickCount = 2;
    protected EventListenerList myListenerList = new EventListenerList();
    private Runnable myFinalRunnable;

    public ComboBoxTableRenderer(T[] values) {
        this.myValues = values;
        this.setFont(UIUtil.getButtonFont());
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)5));
    }

    public ComboBoxTableRenderer<T> withClickCount(int clickCount) {
        this.myClickCount = clickCount;
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = ComboBoxTableRenderer.addIconSize(super.getPreferredSize());
        if (this.myValues != null) {
            String oldText = this.getText();
            Icon oldIcon = this.getIcon();
            for (T v : this.myValues) {
                this.setText(this.getTextFor(v));
                this.setIcon(this.getIconFor(v));
                Dimension vSize = ComboBoxTableRenderer.addIconSize(super.getPreferredSize());
                size.width = Math.max(size.width, vSize.width);
                size.height = Math.max(size.height, vSize.height);
            }
            this.setText(oldText);
            this.setIcon(oldIcon);
        }
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private static Dimension addIconSize(Dimension d) {
        return new Dimension(d.width + AllIcons.General.ArrowDown.getIconWidth() + JBUIScale.scale((int)2), Math.max(d.height, AllIcons.General.ArrowDown.getIconHeight()));
    }

    @NlsContexts.Label
    protected String getTextFor(@NotNull T value) {
        if (value == null) {
            ComboBoxTableRenderer.$$$reportNull$$$0(0);
        }
        return value.toString();
    }

    protected Icon getIconFor(@NotNull T value) {
        if (value == null) {
            ComboBoxTableRenderer.$$$reportNull$$$0(1);
        }
        return null;
    }

    protected ListSeparator getSeparatorAbove(T value) {
        return null;
    }

    protected Runnable onChosen(@NotNull T value) {
        if (value == null) {
            ComboBoxTableRenderer.$$$reportNull$$$0(2);
        }
        this.stopCellEditing(value);
        return () -> this.stopCellEditing(value);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!StringUtil.isEmpty((String)this.getText())) {
            Rectangle r = this.getBounds();
            Insets i = this.getInsets();
            int x = r.width - i.right - AllIcons.General.ArrowDown.getIconWidth();
            int y = i.top + (r.height - i.top - i.bottom - AllIcons.General.ArrowDown.getIconHeight()) / 2;
            AllIcons.General.ArrowDown.paintIcon(this, g, x, y);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Object t = value;
        this.customizeComponent(t, table, isSelected);
        return this;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Object t = value;
        this.myValue = t;
        this.customizeComponent(t, table, true);
        SwingUtilities.invokeLater(() -> this.showPopup(t, row));
        return this;
    }

    protected boolean isApplicable(T value, int row) {
        return true;
    }

    private void showPopup(T value, int row) {
        List filtered = ContainerUtil.findAll((Object[])this.myValues, t -> this.isApplicable(t, row));
        ListPopup popup = JBPopupFactory.getInstance().createListPopup(new ListStep<T>(this, filtered, value));
        popup.addListener(this);
        popup.setRequestFocus(false);
        this.myPopupRef = new WeakReference<ListPopup>(popup);
        popup.showUnderneathOf(this);
    }

    @Override
    public void onClosed(@NotNull LightweightWindowEvent event) {
        if (event == null) {
            ComboBoxTableRenderer.$$$reportNull$$$0(3);
        }
        this.fireEditingCanceled();
    }

    protected void customizeComponent(T value, JTable table, boolean isSelected) {
        this.setOpaque(true);
        this.setText(value == null ? "" : this.getTextFor(value));
        this.setIcon(value == null ? null : this.getIconFor(value));
        this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
    }

    @Override
    public Object getCellEditorValue() {
        return this.myValue;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        return !(event instanceof MouseEvent) || ((MouseEvent)event).getClickCount() >= this.myClickCount;
    }

    @Override
    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    private void stopCellEditing(T value) {
        this.myValue = value;
        this.stopCellEditing();
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        this.hidePopup();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
        this.hidePopup();
    }

    protected void fireEditingStopped() {
        this.fireEditingEvent(false);
    }

    protected void fireEditingCanceled() {
        this.fireEditingEvent(true);
    }

    protected void fireEditingEvent(boolean cancelled) {
        Object[] listeners = this.myListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.myChangeEvent == null) {
                this.myChangeEvent = new ChangeEvent(this);
            }
            CellEditorListener listener2 = (CellEditorListener)listeners[i + 1];
            if (cancelled) {
                listener2.editingCanceled(this.myChangeEvent);
                continue;
            }
            listener2.editingStopped(this.myChangeEvent);
        }
    }

    private void hidePopup() {
        if (this.myPopupRef != null) {
            ListPopup popup = (ListPopup)this.myPopupRef.get();
            if (popup != null && popup.isVisible()) {
                popup.cancel();
            }
            this.myPopupRef = null;
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.myListenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.myListenerList.remove(CellEditorListener.class, l);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/ui/ComboBoxTableRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextFor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getIconFor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onChosen";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onClosed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ListStep<T>
    implements ListPopupStep<T>,
    SpeedSearchFilter<T> {
        private final ComboBoxTableRenderer<T> myHost;
        private final List<T> myValues;
        private final T mySelected;

        ListStep(ComboBoxTableRenderer<T> host, List<T> values, T selected) {
            this.myHost = host;
            this.myValues = values;
            this.mySelected = selected;
        }

        public String getTitle() {
            return null;
        }

        @Nullable
        public PopupStep<?> onChosen(T selectedValue, boolean finalChoice) {
            this.myHost.myFinalRunnable = this.myHost.onChosen(selectedValue);
            return FINAL_CHOICE;
        }

        public boolean hasSubstep(T selectedValue) {
            return false;
        }

        public void canceled() {
            this.myHost.cancelCellEditing();
        }

        public boolean isMnemonicsNavigationEnabled() {
            return false;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        @Nullable
        public Runnable getFinalRunnable() {
            return this.myHost.myFinalRunnable;
        }

        @Override
        @NotNull
        public List<T> getValues() {
            List<T> list = this.myValues;
            if (list == null) {
                ListStep.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        public boolean isSelectable(T value) {
            return true;
        }

        @Override
        public Icon getIconFor(T value) {
            return this.myHost.getIconFor(value);
        }

        @Override
        @NlsContexts.ListItem
        @NotNull
        public String getTextFor(T value) {
            String string = this.myHost.getTextFor(value);
            if (string == null) {
                ListStep.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        public ListSeparator getSeparatorAbove(T value) {
            return this.myHost.getSeparatorAbove(value);
        }

        @Override
        public int getDefaultOptionIndex() {
            return this.mySelected == null ? 0 : this.myValues.indexOf(this.mySelected);
        }

        public MnemonicNavigationFilter<T> getMnemonicNavigationFilter() {
            return null;
        }

        public SpeedSearchFilter<T> getSpeedSearchFilter() {
            return this;
        }

        public String getIndexedString(T value) {
            return this.getTextFor(value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/ui/ComboBoxTableRenderer$ListStep";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

