/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0001\u001a \u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0006\u001a2\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001H\u0007\u001a\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00a8\u0006\u0014"}, d2={"enableExternalStorageByDefaultInTests", "", "isExternalStorageEnabled", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Z", "appendModuleName", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "result", "moduleOnTheLeft", "decorateWithLibraryName", "displayUrlRelativeToProject", "url", "isIncludeFilePath", "doNotEnableExternalStorageByDefaultInTests", "", "action", "Lkotlin/Function0;", "intellij.platform.projectModel"})
@JvmName(name="ProjectUtilCore")
public final class ProjectUtilCore {
    private static boolean enableExternalStorageByDefaultInTests = true;

    @NlsSafe
    @NotNull
    public static final String displayUrlRelativeToProject(@NotNull VirtualFile file, @NlsSafe @NotNull String url, @NotNull Project project, boolean isIncludeFilePath, boolean moduleOnTheLeft) {
        String urlWithLibraryName;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String result = url;
        if (isIncludeFilePath) {
            String string;
            String projectHomeUrl = PathUtil.toSystemDependentName(project.getBasePath());
            if (projectHomeUrl != null && StringsKt.startsWith$default((String)result, (String)projectHomeUrl, (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder = new StringBuilder().append("...");
                String string2 = result;
                int n = projectHomeUrl.length();
                boolean bl = false;
                String string3 = string2.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                string = stringBuilder.append(string3).toString();
            } else {
                String string4 = FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl());
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"FileUtil.getLocationRela\u2026Home(file.presentableUrl)");
            }
            result = string;
        }
        if ((urlWithLibraryName = ProjectUtilCore.decorateWithLibraryName(file, project, result)) != null) {
            return urlWithLibraryName;
        }
        if (PlatformUtils.isCidr() || PlatformUtils.isRider()) {
            return result;
        }
        return ProjectUtilCore.appendModuleName(file, project, result, moduleOnTheLeft);
    }

    @Nullable
    public static final String decorateWithLibraryName(@NotNull VirtualFile file, @NotNull Project project, @NotNull String result) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (file.getFileSystem() instanceof LocalFileProvider) {
            VirtualFileSystem virtualFileSystem = file.getFileSystem();
            if (virtualFileSystem == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.vfs.LocalFileProvider");
            }
            VirtualFile localFile = ((LocalFileProvider)((Object)virtualFileSystem)).getLocalVirtualFileFor(file);
            if (localFile != null) {
                OrderEntry libraryEntry = LibraryUtil.findLibraryEntry(file, project);
                if (libraryEntry instanceof JdkOrderEntry) {
                    return result + " [" + ((JdkOrderEntry)libraryEntry).getJdkName() + ']';
                }
                if (libraryEntry != null) {
                    return result + " [" + libraryEntry.getPresentableName() + ']';
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final String appendModuleName(@NotNull VirtualFile file, @NotNull Project project, @NotNull String result, boolean moduleOnTheLeft) {
        String string;
        Module module;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                module = ModuleUtilCore.findModuleForFile(file, project);
                if (module == null) break block4;
                ModuleManager moduleManager = ModuleManager.getInstance(project);
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                if (moduleManager.getModules().length != 1) break block5;
            }
            string = result;
            return string;
        }
        if (moduleOnTheLeft) {
            string = '[' + module.getName() + "] " + result;
            return string;
        }
        string = result + " [" + module.getName() + ']';
        return string;
    }

    public static final boolean isExternalStorageEnabled(@NotNull Project $this$isExternalStorageEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$isExternalStorageEnabled, (String)"$this$isExternalStorageEnabled");
        String string = $this$isExternalStorageEnabled.getProjectFilePath();
        if (string != null) {
            if (StringsKt.endsWith$default((String)string, (String)".ipr", (boolean)false, (int)2, null)) {
                return false;
            }
        }
        ExternalStorageConfigurationManager externalStorageConfigurationManager = (ExternalStorageConfigurationManager)$this$isExternalStorageEnabled.getService(ExternalStorageConfigurationManager.class);
        if (externalStorageConfigurationManager == null) {
            return false;
        }
        ExternalStorageConfigurationManager manager = externalStorageConfigurationManager;
        if (manager.isEnabled()) {
            return true;
        }
        Application application = ApplicationManager.getApplication();
        boolean testMode = application != null ? application.isUnitTestMode() : false;
        return testMode && enableExternalStorageByDefaultInTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static final void doNotEnableExternalStorageByDefaultInTests(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        enableExternalStorageByDefaultInTests = false;
        try {
            action.invoke();
        }
        finally {
            enableExternalStorageByDefaultInTests = true;
        }
    }
}

