/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActionPlaces {
    public static final String UNKNOWN = "unknown";
    public static final String TOOLBAR = "toolbar";
    public static final String POPUP = "popup";
    public static final String KEYBOARD_SHORTCUT = "keyboard shortcut";
    public static final String MOUSE_SHORTCUT = "mouse shortcut";
    public static final String FORCE_TOUCH = "force touch";
    public static final String MAIN_MENU = "MainMenu";
    public static final String MAIN_TOOLBAR = "MainToolbar";
    public static final String EDITOR_POPUP = "EditorPopup";
    public static final String EDITOR_TOOLBAR = "EditorToolbar";
    public static final String EDITOR_TAB_POPUP = "EditorTabPopup";
    public static final String EDITOR_TAB = "EditorTab";
    public static final String TABS_MORE_TOOLBAR = "TabsMoreToolbar";
    public static final String EDITOR_GUTTER = "ICON_NAVIGATION";
    public static final String EDITOR_GUTTER_POPUP = "ICON_NAVIGATION_SECONDARY_BUTTON";
    public static final String RIGHT_EDITOR_GUTTER_POPUP = "RightEditorGutterPopup";
    public static final String COMMANDER_POPUP = "CommanderPopup";
    public static final String COMMANDER_TOOLBAR = "CommanderToolbar";
    public static final String CONTEXT_TOOLBAR = "ContextToolbar";
    public static final String TOOLWINDOW_POPUP = "ToolwindowPopup";
    public static final String TOOLWINDOW_TITLE = "ToolwindowTitle";
    public static final String TOOLWINDOW_CONTENT = "ToolwindowContent";
    public static final String EDITOR_INSPECTIONS_TOOLBAR = "EditorInspectionsToolbar";
    public static final String LEARN_TOOLWINDOW = "LearnToolwindow";
    public static final String PROJECT_VIEW_POPUP = "ProjectViewPopup";
    public static final String PROJECT_VIEW_TOOLBAR = "ProjectViewToolbar";
    public static final String FAVORITES_VIEW_POPUP = "FavoritesPopup";
    public static final String STATUS_BAR_PLACE = "StatusBarPlace";
    public static final String SCOPE_VIEW_POPUP = "ScopeViewPopup";
    public static final String ACTION_SEARCH = "GoToAction";
    public static final String TESTTREE_VIEW_POPUP = "TestTreeViewPopup";
    public static final String TESTTREE_VIEW_TOOLBAR = "TestTreeViewToolbar";
    private static final String TESTSTATISTICS_VIEW_POPUP = "TestStatisticsViewPopup";
    public static final String TYPE_HIERARCHY_VIEW_POPUP = "TypeHierarchyViewPopup";
    public static final String TYPE_HIERARCHY_VIEW_TOOLBAR = "TypeHierarchyViewToolbar";
    public static final String METHOD_HIERARCHY_VIEW_POPUP = "MethodHierarchyViewPopup";
    public static final String METHOD_HIERARCHY_VIEW_TOOLBAR = "MethodHierarchyViewToolbar";
    public static final String CALL_HIERARCHY_VIEW_POPUP = "CallHierarchyViewPopup";
    public static final String CALL_HIERARCHY_VIEW_TOOLBAR = "CallHierarchyViewToolbar";
    public static final String J2EE_ATTRIBUTES_VIEW_POPUP = "J2EEAttributesViewPopup";
    public static final String J2EE_VIEW_POPUP = "J2EEViewPopup";
    public static final String RUNNER_TOOLBAR = "RunnerToolbar";
    public static final String RUNNER_LAYOUT_BUTTON_TOOLBAR = "RunnerLayoutButtonToolbar";
    public static final String DEBUGGER_TOOLBAR = "DebuggerToolbar";
    public static final String USAGE_VIEW_POPUP = "UsageViewPopup";
    public static final String USAGE_VIEW_TOOLBAR = "UsageViewToolbar";
    public static final String STRUCTURE_VIEW_POPUP = "StructureViewPopup";
    public static final String STRUCTURE_VIEW_TOOLBAR = "StructureViewToolbar";
    public static final String NAVIGATION_BAR_POPUP = "NavBar";
    public static final String NAVIGATION_BAR_TOOLBAR = "NavBarToolbar";
    public static final String TODO_VIEW_POPUP = "TodoViewPopup";
    public static final String TODO_VIEW_TOOLBAR = "TodoViewToolbar";
    public static final String COMPILER_MESSAGES_POPUP = "CompilerMessagesPopup";
    public static final String COMPILER_MESSAGES_TOOLBAR = "CompilerMessagesToolbar";
    public static final String ANT_MESSAGES_POPUP = "AntMessagesPopup";
    public static final String ANT_MESSAGES_TOOLBAR = "AntMessagesToolbar";
    public static final String ANT_EXPLORER_POPUP = "AntExplorerPopup";
    public static final String ANT_EXPLORER_TOOLBAR = "AntExplorerToolbar";
    public static final String JS_BUILD_TOOL_POPUP = "JavaScriptBuildTool";
    public static final String CODE_INSPECTION = "CodeInspection";
    public static final String JAVADOC_TOOLBAR = "JavadocToolbar";
    public static final String JAVADOC_INPLACE_SETTINGS = "JavadocInplaceSettings";
    public static final String FILEHISTORY_VIEW_TOOLBAR = "FileHistoryViewToolbar";
    public static final String UPDATE_POPUP = "UpdatePopup";
    public static final String FILEVIEW_POPUP = "FileViewPopup";
    public static final String CHECKOUT_POPUP = "CheckoutPopup";
    public static final String LVCS_DIRECTORY_HISTORY_POPUP = "LvcsHistoryPopup";
    public static final String GUI_DESIGNER_EDITOR_POPUP = "GuiDesigner.EditorPopup";
    public static final String GUI_DESIGNER_COMPONENT_TREE_POPUP = "GuiDesigner.ComponentTreePopup";
    public static final String GUI_DESIGNER_PROPERTY_INSPECTOR_POPUP = "GuiDesigner.PropertyInspectorPopup";
    public static final String RUN_CONFIGURATIONS_COMBOBOX = "RunConfigurationsCombobox";
    public static final String CREATE_EJB_POPUP = "CreateEjbPopup";
    public static final String WELCOME_SCREEN = "WelcomeScreen";
    public static final String CHANGES_VIEW_TOOLBAR = "ChangesViewToolbar";
    public static final String CHANGES_VIEW_POPUP = "ChangesViewPopup";
    public static final String DATABASE_VIEW_TOOLBAR = "DatabaseViewToolbar";
    public static final String DATABASE_VIEW_POPUP = "DatabaseViewPopup";
    public static final String REMOTE_HOST_VIEW_POPUP = "RemoteHostPopup";
    public static final String REMOTE_HOST_DIALOG_POPUP = "RemoteHostDialogPopup";
    public static final String TFS_TREE_POPUP = "TfsTreePopup";
    public static final String ACTION_PLACE_VCS_QUICK_LIST_POPUP_ACTION = "ActionPlace.VcsQuickListPopupAction";
    public static final String ACTION_PLACE_QUICK_LIST_POPUP_ACTION = "ActionPlace.QuickListPopupAction";
    public static final String PHING_EXPLORER_POPUP = "PhingExplorerPopup";
    public static final String PHING_EXPLORER_TOOLBAR = "PhingExplorerToolbar";
    public static final String DOCK_MENU = "DockMenu";
    public static final String PHING_MESSAGES_TOOLBAR = "PhingMessagesToolbar";
    public static final String COMPOSER_EDITOR_NOTIFICATION_PANEL = "ComposerEditorNotificationPanel";
    public static final String COMPOSER_EDITOR_NOTIFICATION_PANEL_EXTRA = "ComposerEditorNotificationPanel.ExtraActions";
    public static final String COMPOSER_LOG_RERUN = "ComposerLogRerun";
    public static final String DIFF_TOOLBAR = "DiffToolbar";
    public static final String ANALYZE_STACKTRACE_PANEL_TOOLBAR = "ANALYZE_STACKTRACE_PANEL_TOOLBAR";
    public static final String V8_CPU_PROFILING_POPUP = "V8_CPU_PROFILING_POPUP";
    public static final String V8_HEAP_PROFILING_POPUP = "V8_HEAP_PROFILING_POPUP";
    public static final String V8_HEAP_DIFF_PROFILING_POPUP = "V8_HEAP_DIFF_PROFILING_POPUP";
    public static final String RUN_DASHBOARD_POPUP = "RunDashboardPopup";
    public static final String SERVICES_POPUP = "ServicesPopup";
    public static final String SERVICES_TOOLBAR = "ServicesToolbar";
    public static final String TOUCHBAR_GENERAL = "TouchBarGeneral";
    public static final String REFACTORING_QUICKLIST = "RefactoringQuickList";
    public static final String INTENTION_MENU = "IntentionMenu";
    public static final String TEXT_EDITOR_WITH_PREVIEW = "TextEditorWithPreview";
    public static final String NOTIFICATION = "Notification";
    public static final String FILE_STRUCTURE_POPUP = "FileStructurePopup";
    public static final String QUICK_SWITCH_SCHEME_POPUP = "QuickSwitchSchemePopup";
    public static final String RIDER_UNIT_TESTS_LEFT_TOOLBAR = "UnitTests.LeftToolbar";
    public static final String RIDER_UNIT_TESTS_TOP_TOOLBAR = "UnitTests.TopToolbar";
    public static final String RIDER_UNIT_TESTS_SESSION_POPUP = "UnitTests.SessionPopup";
    public static final String RIDER_UNIT_TESTS_EXPLORER_POPUP = "UnitTests.ExplorerPopup";
    public static final String RIDER_UNIT_TESTS_PROGRESSBAR_POPUP = "UnitTests.ProgressBarPopup";
    public static final String RIDER_UNIT_TESTS_QUICKLIST = "UnitTests.QuickList";
    private static final Set<String> ourCommonPlaces = ContainerUtil.newHashSet((Object[])new String[]{"unknown", "keyboard shortcut", "mouse shortcut", "force touch", "toolbar", "MainMenu", "MainToolbar", "EditorToolbar", "TabsMoreToolbar", "EditorTab", "CommanderToolbar", "ContextToolbar", "ToolwindowTitle", "LearnToolwindow", "ProjectViewToolbar", "StatusBarPlace", "GoToAction", "TestTreeViewToolbar", "TypeHierarchyViewToolbar", "MethodHierarchyViewToolbar", "CallHierarchyViewToolbar", "RunnerToolbar", "DebuggerToolbar", "UsageViewToolbar", "StructureViewToolbar", "NavBarToolbar", "TodoViewToolbar", "CompilerMessagesToolbar", "AntMessagesToolbar", "AntExplorerToolbar", "CodeInspection", "JavadocToolbar", "JavadocInplaceSettings", "FileHistoryViewToolbar", "RunConfigurationsCombobox", "WelcomeScreen", "ChangesViewToolbar", "DatabaseViewToolbar", "ActionPlace.QuickListPopupAction", "PhingExplorerToolbar", "DockMenu", "PhingMessagesToolbar", "DiffToolbar", "ANALYZE_STACKTRACE_PANEL_TOOLBAR", "TouchBarGeneral", "ComposerEditorNotificationPanel", "ComposerEditorNotificationPanel.ExtraActions", "ComposerLogRerun", "ICON_NAVIGATION", "ToolwindowContent", "ServicesToolbar", "RefactoringQuickList", "IntentionMenu", "TextEditorWithPreview", "Notification", "FileStructurePopup", "UnitTests.LeftToolbar", "UnitTests.TopToolbar", "UnitTests.SessionPopup", "UnitTests.ExplorerPopup", "UnitTests.ProgressBarPopup", "UnitTests.QuickList", "QuickSwitchSchemePopup"});
    private static final Set<String> ourPopupPlaces = ContainerUtil.newHashSet((Object[])new String[]{"popup", "EditorPopup", "EditorTabPopup", "CommanderPopup", "ProjectViewPopup", "FavoritesPopup", "ScopeViewPopup", "TestTreeViewPopup", "TestStatisticsViewPopup", "TypeHierarchyViewPopup", "MethodHierarchyViewPopup", "CallHierarchyViewPopup", "J2EEAttributesViewPopup", "J2EEViewPopup", "UsageViewPopup", "StructureViewPopup", "TodoViewPopup", "CompilerMessagesPopup", "AntMessagesPopup", "AntExplorerPopup", "UpdatePopup", "FileViewPopup", "CheckoutPopup", "LvcsHistoryPopup", "GuiDesigner.EditorPopup", "GuiDesigner.ComponentTreePopup", "GuiDesigner.PropertyInspectorPopup", "ToolwindowPopup", "CreateEjbPopup", "ChangesViewPopup", "DatabaseViewPopup", "RemoteHostPopup", "RemoteHostDialogPopup", "TfsTreePopup", "ActionPlace.VcsQuickListPopupAction", "PhingExplorerPopup", "NavBar", "JavaScriptBuildTool", "V8_CPU_PROFILING_POPUP", "V8_HEAP_PROFILING_POPUP", "V8_HEAP_PROFILING_POPUP", "RunDashboardPopup", "ServicesPopup", "ICON_NAVIGATION_SECONDARY_BUTTON"});
    private static final String POPUP_PREFIX = "popup@";

    public static boolean isMainMenuOrActionSearch(String place) {
        return MAIN_MENU.equals(place) || ACTION_SEARCH.equals(place) || KEYBOARD_SHORTCUT.equals(place) || MOUSE_SHORTCUT.equals(place) || FORCE_TOUCH.equals(place);
    }

    public static boolean isPopupPlace(@NotNull String place) {
        if (place == null) {
            ActionPlaces.$$$reportNull$$$0(0);
        }
        return ourPopupPlaces.contains(place) || place.startsWith(POPUP_PREFIX);
    }

    public static boolean isCommonPlace(@NotNull String place) {
        if (place == null) {
            ActionPlaces.$$$reportNull$$$0(1);
        }
        return ourPopupPlaces.contains(place) || ourCommonPlaces.contains(place);
    }

    public static boolean isMainMenuOrShortcut(@NotNull String place) {
        if (place == null) {
            ActionPlaces.$$$reportNull$$$0(2);
        }
        return MAIN_MENU.equals(place) || KEYBOARD_SHORTCUT.equals(place);
    }

    @NotNull
    public static String getActionGroupPopupPlace(@Nullable String actionId) {
        Object object = actionId == null ? POPUP : POPUP_PREFIX + actionId;
        if (object == null) {
            ActionPlaces.$$$reportNull$$$0(3);
        }
        return object;
    }

    @ApiStatus.Internal
    public static boolean isMacSystemMenuAction(@NotNull AnActionEvent e) {
        if (e == null) {
            ActionPlaces.$$$reportNull$$$0(4);
        }
        return SystemInfo.isMacSystemMenu && ActionPlaces.isMainMenuOrShortcut(e.getPlace());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/ActionPlaces";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/ActionPlaces";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionGroupPopupPlace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPopupPlace";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isCommonPlace";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMainMenuOrShortcut";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMacSystemMenuAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

