/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target.value;

import com.intellij.execution.target.value.CompositeTargetValue;
import com.intellij.execution.target.value.FixedTargetValue;
import com.intellij.execution.target.value.MapTargetValue;
import com.intellij.util.Function;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public interface TargetValue<T> {
    public static final TargetValue EMPTY_VALUE = new TargetValue(){

        public Promise<Object> getLocalValue() {
            return Promises.resolvedPromise();
        }

        public Promise<Object> getTargetValue() {
            return Promises.resolvedPromise();
        }
    };

    public Promise<T> getLocalValue();

    public Promise<T> getTargetValue();

    public static <V> TargetValue<V> empty() {
        return EMPTY_VALUE;
    }

    public static <V> TargetValue<V> fixed(V value) {
        return new FixedTargetValue<V>(value);
    }

    public static <T, V> TargetValue<V> map(@NotNull TargetValue<? extends T> originalValue, @NotNull Function<? super T, ? extends V> mapper) {
        if (originalValue == null) {
            TargetValue.$$$reportNull$$$0(0);
        }
        if (mapper == null) {
            TargetValue.$$$reportNull$$$0(1);
        }
        return new MapTargetValue<T, V>(originalValue, mapper);
    }

    public static <T, V> TargetValue<V> composite(@NotNull Collection<TargetValue<T>> values, @NotNull Function<? super Collection<T>, ? extends V> joiner) {
        if (values == null) {
            TargetValue.$$$reportNull$$$0(2);
        }
        if (joiner == null) {
            TargetValue.$$$reportNull$$$0(3);
        }
        return new CompositeTargetValue(values, joiner);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalValue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "joiner";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/target/value/TargetValue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "map";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "composite";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

