/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.fragments;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineFragmentImpl
implements LineFragment {
    private static final Logger LOG = Logger.getInstance(LineFragmentImpl.class);
    private final int myStartLine1;
    private final int myEndLine1;
    private final int myStartLine2;
    private final int myEndLine2;
    private final int myStartOffset1;
    private final int myEndOffset1;
    private final int myStartOffset2;
    private final int myEndOffset2;
    @Nullable
    private final List<DiffFragment> myInnerFragments;

    public LineFragmentImpl(int startLine1, int endLine1, int startLine2, int endLine2, int startOffset1, int endOffset1, int startOffset2, int endOffset2) {
        this(startLine1, endLine1, startLine2, endLine2, startOffset1, endOffset1, startOffset2, endOffset2, null);
    }

    public LineFragmentImpl(@NotNull LineFragment fragment, @Nullable List<DiffFragment> fragments) {
        if (fragment == null) {
            LineFragmentImpl.$$$reportNull$$$0(0);
        }
        this(fragment.getStartLine1(), fragment.getEndLine1(), fragment.getStartLine2(), fragment.getEndLine2(), fragment.getStartOffset1(), fragment.getEndOffset1(), fragment.getStartOffset2(), fragment.getEndOffset2(), fragments);
    }

    public LineFragmentImpl(int startLine1, int endLine1, int startLine2, int endLine2, int startOffset1, int endOffset1, int startOffset2, int endOffset2, @Nullable List<DiffFragment> innerFragments) {
        this.myStartLine1 = startLine1;
        this.myEndLine1 = endLine1;
        this.myStartLine2 = startLine2;
        this.myEndLine2 = endLine2;
        this.myStartOffset1 = startOffset1;
        this.myEndOffset1 = endOffset1;
        this.myStartOffset2 = startOffset2;
        this.myEndOffset2 = endOffset2;
        this.myInnerFragments = LineFragmentImpl.dropWholeChangedFragments(innerFragments, endOffset1 - startOffset1, endOffset2 - startOffset2);
        if (this.myStartLine1 == this.myEndLine1 && this.myStartLine2 == this.myEndLine2) {
            LOG.error("LineFragmentImpl should not be empty: " + this.toString());
        }
        if (this.myStartLine1 > this.myEndLine1 || this.myStartLine2 > this.myEndLine2 || this.myStartOffset1 > this.myEndOffset1 || this.myStartOffset2 > this.myEndOffset2) {
            LOG.error("LineFragmentImpl is invalid: " + this.toString());
        }
    }

    @Override
    public int getStartLine1() {
        return this.myStartLine1;
    }

    @Override
    public int getEndLine1() {
        return this.myEndLine1;
    }

    @Override
    public int getStartLine2() {
        return this.myStartLine2;
    }

    @Override
    public int getEndLine2() {
        return this.myEndLine2;
    }

    @Override
    public int getStartOffset1() {
        return this.myStartOffset1;
    }

    @Override
    public int getEndOffset1() {
        return this.myEndOffset1;
    }

    @Override
    public int getStartOffset2() {
        return this.myStartOffset2;
    }

    @Override
    public int getEndOffset2() {
        return this.myEndOffset2;
    }

    @Override
    @Nullable
    public List<DiffFragment> getInnerFragments() {
        return this.myInnerFragments;
    }

    @Nullable
    private static List<DiffFragment> dropWholeChangedFragments(@Nullable List<DiffFragment> fragments, int length1, int length2) {
        DiffFragment diffFragment;
        if (fragments != null && fragments.size() == 1 && (diffFragment = fragments.get(0)).getStartOffset1() == 0 && diffFragment.getStartOffset2() == 0 && diffFragment.getEndOffset1() == length1 && diffFragment.getEndOffset2() == length2) {
            return null;
        }
        return fragments;
    }

    @NonNls
    public String toString() {
        return "LineFragmentImpl: Lines [" + this.myStartLine1 + ", " + this.myEndLine1 + ") - [" + this.myStartLine2 + ", " + this.myEndLine2 + "); Offsets [" + this.myStartOffset1 + ", " + this.myEndOffset1 + ") - [" + this.myStartOffset2 + ", " + this.myEndOffset2 + "); Inner " + (this.myInnerFragments != null ? Integer.valueOf(this.myInnerFragments.size()) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/fragments/LineFragmentImpl", "<init>"));
    }
}

