/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.quickfix;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameValuePair;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeAnnotationParameterQuickFix
extends LocalQuickFixOnPsiElement
implements IntentionAction {
    private final String myName;
    private final String myNewValue;

    public ChangeAnnotationParameterQuickFix(@NotNull PsiAnnotation psiAnnotation, @NotNull String name, @Nullable String newValue) {
        if (psiAnnotation == null) {
            ChangeAnnotationParameterQuickFix.$$$reportNull$$$0(0);
        }
        if (name == null) {
            ChangeAnnotationParameterQuickFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)psiAnnotation);
        this.myName = name;
        this.myNewValue = newValue;
    }

    @NotNull
    public String getText() {
        if (null == this.myNewValue) {
            String string = String.format("Remove annotation parameter '%s'", this.myName);
            if (string == null) {
                ChangeAnnotationParameterQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = String.format("Set annotation parameter '%s = %s'", this.myName, this.myNewValue);
        if (string == null) {
            ChangeAnnotationParameterQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ChangeAnnotationParameterQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ChangeAnnotationParameterQuickFix.$$$reportNull$$$0(5);
        }
        return this.isAvailable();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ChangeAnnotationParameterQuickFix.$$$reportNull$$$0(6);
        }
        this.applyFix();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiAnnotation myAnnotation;
        Editor editor;
        if (project == null) {
            ChangeAnnotationParameterQuickFix.$$$reportNull$$$0(7);
        }
        if (psiFile == null) {
            ChangeAnnotationParameterQuickFix.$$$reportNull$$$0(8);
        }
        if (startElement == null) {
            ChangeAnnotationParameterQuickFix.$$$reportNull$$$0(9);
        }
        if (endElement == null) {
            ChangeAnnotationParameterQuickFix.$$$reportNull$$$0(10);
        }
        if ((editor = CodeInsightUtil.positionCursor((Project)project, (PsiFile)psiFile, (PsiElement)(myAnnotation = (PsiAnnotation)startElement))) != null) {
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{psiFile}).run(() -> {
                PsiNameValuePair valuePair = this.selectAnnotationAttribute(myAnnotation);
                if (null != valuePair) {
                    valuePair.delete();
                }
                if (null != this.myNewValue) {
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)myAnnotation.getProject());
                    PsiAnnotation newAnnotation = elementFactory.createAnnotationFromText("@" + myAnnotation.getQualifiedName() + "(" + this.myName + "=" + this.myNewValue + ")", myAnnotation.getContext());
                    PsiNameValuePair[] attributes = newAnnotation.getParameterList().getAttributes();
                    myAnnotation.setDeclaredAttributeValue(attributes[0].getName(), attributes[0].getValue());
                }
                UndoUtil.markPsiFileForUndo((PsiFile)psiFile);
            });
        }
    }

    private PsiNameValuePair selectAnnotationAttribute(PsiAnnotation psiAnnotation) {
        PsiNameValuePair[] attributes;
        PsiNameValuePair result = null;
        for (PsiNameValuePair attribute : attributes = psiAnnotation.getParameterList().getAttributes()) {
            @NonNls String attributeName = attribute.getName();
            if (!Objects.equals(this.myName, attributeName) && (attributeName != null || !this.myName.equals("value"))) continue;
            result = attribute;
            break;
        }
        return result;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/quickfix/ChangeAnnotationParameterQuickFix";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/quickfix/ChangeAnnotationParameterQuickFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

