/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.handler.singular;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import de.plushnikov.intellij.plugin.processor.handler.singular.BuilderElementHandler;
import de.plushnikov.intellij.plugin.processor.handler.singular.EmptyBuilderElementHandler;
import de.plushnikov.intellij.plugin.processor.handler.singular.NonSingularHandler;
import de.plushnikov.intellij.plugin.processor.handler.singular.SingularCollectionHandler;
import de.plushnikov.intellij.plugin.processor.handler.singular.SingularGuavaCollectionHandler;
import de.plushnikov.intellij.plugin.processor.handler.singular.SingularGuavaMapHandler;
import de.plushnikov.intellij.plugin.processor.handler.singular.SingularGuavaTableHandler;
import de.plushnikov.intellij.plugin.processor.handler.singular.SingularMapHandler;
import de.plushnikov.intellij.plugin.util.PsiTypeUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingularHandlerFactory {
    private static final String[] JAVA_MAPS = new String[]{"java.util.Map", "java.util.SortedMap", "java.util.NavigableMap"};
    private static final String[] JAVA_SETS = new String[]{"java.util.Set", "java.util.SortedSet", "java.util.NavigableSet"};
    private static final String[] GUAVA_COLLECTIONS = new String[]{"com.google.common.collect.ImmutableCollection", "com.google.common.collect.ImmutableList"};
    private static final String[] GUAVA_SETS = new String[]{"com.google.common.collect.ImmutableSet", "com.google.common.collect.ImmutableSortedSet"};
    private static final String[] GUAVA_MAPS = new String[]{"com.google.common.collect.ImmutableMap", "com.google.common.collect.ImmutableBiMap", "com.google.common.collect.ImmutableSortedMap"};
    private static final String[] GUAVA_TABLE = new String[]{"com.google.common.collect.ImmutableTable"};
    private static final Set<String> COLLECTION_TYPES = new HashSet<String>(){
        {
            this.addAll(SingularHandlerFactory.toSet("java.lang.Iterable", "java.util.Collection", "java.util.List"));
            this.addAll(SingularHandlerFactory.toSet(JAVA_SETS));
        }
    };
    private static final Set<String> GUAVA_COLLECTION_TYPES = new HashSet<String>(){
        {
            this.addAll(SingularHandlerFactory.toSet(GUAVA_COLLECTIONS));
            this.addAll(SingularHandlerFactory.toSet(GUAVA_SETS));
        }
    };
    private static final Set<String> MAP_TYPES = new HashSet<String>(){
        {
            this.addAll(SingularHandlerFactory.toSet(JAVA_MAPS));
        }
    };
    private static final Set<String> GUAVA_MAP_TYPES = new HashSet<String>(){
        {
            this.addAll(SingularHandlerFactory.toSet(GUAVA_MAPS));
        }
    };
    private static final Set<String> GUAVA_TABLE_TYPES = new HashSet<String>(){
        {
            this.addAll(SingularHandlerFactory.toSet(GUAVA_TABLE));
        }
    };
    private static final Set<String> VALID_SINGULAR_TYPES = new HashSet<String>(){
        {
            this.addAll(COLLECTION_TYPES);
            this.addAll(MAP_TYPES);
            this.addAll(GUAVA_COLLECTION_TYPES);
            this.addAll(GUAVA_MAP_TYPES);
            this.addAll(GUAVA_TABLE_TYPES);
        }
    };

    private static Set<String> toSet(String ... from) {
        return new HashSet<String>(Arrays.asList(from));
    }

    public static boolean isInvalidSingularType(@Nullable String qualifiedName) {
        return qualifiedName == null || !VALID_SINGULAR_TYPES.contains(qualifiedName);
    }

    @NotNull
    public static BuilderElementHandler getHandlerFor(@NotNull PsiVariable psiVariable, @Nullable PsiAnnotation singularAnnotation) {
        if (psiVariable == null) {
            SingularHandlerFactory.$$$reportNull$$$0(0);
        }
        if (null == singularAnnotation) {
            return new NonSingularHandler();
        }
        PsiType psiType = psiVariable.getType();
        String qualifiedName = PsiTypeUtil.getQualifiedName(psiType);
        if (!SingularHandlerFactory.isInvalidSingularType(qualifiedName)) {
            if (COLLECTION_TYPES.contains(qualifiedName)) {
                return new SingularCollectionHandler(qualifiedName);
            }
            if (MAP_TYPES.contains(qualifiedName)) {
                return new SingularMapHandler(qualifiedName);
            }
            if (GUAVA_COLLECTION_TYPES.contains(qualifiedName)) {
                return new SingularGuavaCollectionHandler(qualifiedName, qualifiedName.contains("Sorted"));
            }
            if (GUAVA_MAP_TYPES.contains(qualifiedName)) {
                return new SingularGuavaMapHandler(qualifiedName, qualifiedName.contains("Sorted"));
            }
            if (GUAVA_TABLE_TYPES.contains(qualifiedName)) {
                return new SingularGuavaTableHandler(qualifiedName, false);
            }
        }
        return new EmptyBuilderElementHandler();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "de/plushnikov/intellij/plugin/processor/handler/singular/SingularHandlerFactory", "getHandlerFor"));
    }
}

