/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.handler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigDiscovery;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.processor.clazz.ToStringProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.NoArgsConstructorProcessor;
import de.plushnikov.intellij.plugin.processor.handler.BuilderInfo;
import de.plushnikov.intellij.plugin.processor.handler.EqualsAndHashCodeToStringHandler;
import de.plushnikov.intellij.plugin.processor.handler.singular.AbstractSingularHandler;
import de.plushnikov.intellij.plugin.processor.handler.singular.SingularHandlerFactory;
import de.plushnikov.intellij.plugin.psi.LombokLightClassBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import de.plushnikov.intellij.plugin.util.PsiMethodUtil;
import de.plushnikov.intellij.plugin.util.PsiTypeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuilderHandler {
    private static final String ANNOTATION_BUILDER_CLASS_NAME = "builderClassName";
    private static final String ANNOTATION_BUILD_METHOD_NAME = "buildMethodName";
    private static final String ANNOTATION_BUILDER_METHOD_NAME = "builderMethodName";
    private static final String ANNOTATION_SETTER_PREFIX = "setterPrefix";
    private static final String BUILD_METHOD_NAME = "build";
    private static final String BUILDER_METHOD_NAME = "builder";
    private static final String TO_BUILDER_METHOD_NAME = "toBuilder";
    static final String TO_BUILDER_ANNOTATION_KEY = "toBuilder";
    private static final Collection<String> INVALID_ON_BUILDERS = Stream.of("lombok.Getter", "lombok.Setter", "lombok.experimental.Wither", "lombok.With", "lombok.ToString", "lombok.EqualsAndHashCode", "lombok.RequiredArgsConstructor", "lombok.AllArgsConstructor", "lombok.NoArgsConstructor", "lombok.Data", "lombok.Value", "lombok.experimental.FieldDefaults").map(fqn -> StringUtil.getShortName((String)fqn)).collect(Collectors.toUnmodifiableSet());

    PsiSubstitutor getBuilderSubstitutor(@NotNull PsiTypeParameterListOwner classOrMethodToBuild, @NotNull PsiClass innerClass) {
        PsiTypeParameter[] builderParams;
        PsiTypeParameter[] typeParameters;
        if (classOrMethodToBuild == null) {
            BuilderHandler.$$$reportNull$$$0(0);
        }
        if (innerClass == null) {
            BuilderHandler.$$$reportNull$$$0(1);
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        if (innerClass.hasModifierProperty("static") && (typeParameters = classOrMethodToBuild.getTypeParameters()).length <= (builderParams = innerClass.getTypeParameters()).length) {
            for (int i = 0; i < typeParameters.length; ++i) {
                PsiTypeParameter typeParameter = typeParameters[i];
                substitutor = substitutor.put(typeParameter, PsiSubstitutor.EMPTY.substitute(builderParams[i]));
            }
        }
        return substitutor;
    }

    public boolean validate(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull ProblemBuilder problemBuilder) {
        boolean result;
        if (psiClass == null) {
            BuilderHandler.$$$reportNull$$$0(2);
        }
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(3);
        }
        if (problemBuilder == null) {
            BuilderHandler.$$$reportNull$$$0(4);
        }
        if (result = this.validateAnnotationOnRightType(psiClass, psiAnnotation, problemBuilder)) {
            Project project = psiAnnotation.getProject();
            String builderClassName = this.getBuilderClassName(psiClass, psiAnnotation);
            String buildMethodName = this.getBuildMethodName(psiAnnotation);
            String builderMethodName = this.getBuilderMethodName(psiAnnotation);
            boolean bl = result = this.validateBuilderIdentifier(builderClassName, project, problemBuilder) && this.validateBuilderIdentifier(buildMethodName, project, problemBuilder) && (builderMethodName.isEmpty() || this.validateBuilderIdentifier(builderMethodName, project, problemBuilder)) && this.validateExistingBuilderClass(builderClassName, psiClass, problemBuilder);
            if (result) {
                Collection builderInfos = this.createBuilderInfos(psiClass, null).collect(Collectors.toList());
                result = this.validateBuilderDefault(builderInfos, problemBuilder) && this.validateSingular(builderInfos, problemBuilder) && this.validateObtainViaAnnotations(builderInfos.stream(), problemBuilder);
            }
        }
        return result;
    }

    private boolean validateBuilderDefault(@NotNull Collection<BuilderInfo> builderInfos, @NotNull ProblemBuilder problemBuilder) {
        if (builderInfos == null) {
            BuilderHandler.$$$reportNull$$$0(5);
        }
        if (problemBuilder == null) {
            BuilderHandler.$$$reportNull$$$0(6);
        }
        Optional<BuilderInfo> anyBuilderDefaultAndSingulars = builderInfos.stream().filter(BuilderInfo::hasBuilderDefaultAnnotation).filter(BuilderInfo::hasSingularAnnotation).findAny();
        anyBuilderDefaultAndSingulars.ifPresent(builderInfo -> problemBuilder.addError("@Builder.Default and @Singular cannot be mixed."));
        Optional<BuilderInfo> anyBuilderDefaultWithoutInitializer = builderInfos.stream().filter(BuilderInfo::hasBuilderDefaultAnnotation).filter(BuilderInfo::hasNoInitializer).findAny();
        anyBuilderDefaultWithoutInitializer.ifPresent(builderInfo -> problemBuilder.addError("@Builder.Default requires an initializing expression (' = something;')."));
        return anyBuilderDefaultAndSingulars.isEmpty() || anyBuilderDefaultWithoutInitializer.isEmpty();
    }

    public boolean validate(@NotNull PsiMethod psiMethod, @NotNull PsiAnnotation psiAnnotation, @NotNull ProblemBuilder problemBuilder) {
        PsiClass psiClass;
        boolean result;
        if (psiMethod == null) {
            BuilderHandler.$$$reportNull$$$0(7);
        }
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(8);
        }
        if (problemBuilder == null) {
            BuilderHandler.$$$reportNull$$$0(9);
        }
        boolean bl = result = null != (psiClass = psiMethod.getContainingClass());
        if (result) {
            String builderClassName = this.getBuilderClassName(psiClass, psiAnnotation, psiMethod);
            Project project = psiAnnotation.getProject();
            String buildMethodName = this.getBuildMethodName(psiAnnotation);
            String builderMethodName = this.getBuilderMethodName(psiAnnotation);
            boolean bl2 = result = this.validateBuilderIdentifier(builderClassName, project, problemBuilder) && this.validateBuilderIdentifier(buildMethodName, project, problemBuilder) && (builderMethodName.isEmpty() || this.validateBuilderIdentifier(builderMethodName, project, problemBuilder)) && this.validateExistingBuilderClass(builderClassName, psiClass, problemBuilder);
            if (result) {
                Stream<BuilderInfo> builderInfos = this.createBuilderInfos(psiClass, psiMethod);
                result = this.validateObtainViaAnnotations(builderInfos, problemBuilder);
            }
        }
        return result;
    }

    private boolean validateSingular(Collection<BuilderInfo> builderInfos, @NotNull ProblemBuilder problemBuilder) {
        if (problemBuilder == null) {
            BuilderHandler.$$$reportNull$$$0(10);
        }
        AtomicBoolean result = new AtomicBoolean(true);
        builderInfos.stream().filter(BuilderInfo::hasSingularAnnotation).forEach(builderInfo -> {
            PsiType psiVariableType = builderInfo.getVariable().getType();
            String qualifiedName = PsiTypeUtil.getQualifiedName(psiVariableType);
            if (SingularHandlerFactory.isInvalidSingularType(qualifiedName)) {
                problemBuilder.addError("Lombok does not know how to create the singular-form builder methods for type '%s'; they won't be generated.", qualifiedName != null ? qualifiedName : psiVariableType.getCanonicalText());
                result.set(false);
            }
            if (!AbstractSingularHandler.validateSingularName(builderInfo.getSingularAnnotation(), builderInfo.getFieldName())) {
                problemBuilder.addError("Can't singularize this name: \"%s\"; please specify the singular explicitly (i.e. @Singular(\"sheep\"))", builderInfo.getFieldName());
                result.set(false);
            }
        });
        return result.get();
    }

    private boolean validateBuilderIdentifier(@NotNull String builderClassName, @NotNull Project project, @NotNull ProblemBuilder builder) {
        PsiNameHelper psiNameHelper;
        if (builderClassName == null) {
            BuilderHandler.$$$reportNull$$$0(11);
        }
        if (project == null) {
            BuilderHandler.$$$reportNull$$$0(12);
        }
        if (builder == null) {
            BuilderHandler.$$$reportNull$$$0(13);
        }
        if (!(psiNameHelper = PsiNameHelper.getInstance((Project)project)).isIdentifier(builderClassName)) {
            builder.addError("%s is not a valid identifier", builderClassName);
            return false;
        }
        return true;
    }

    public boolean validateExistingBuilderClass(@NotNull String builderClassName, @NotNull PsiClass psiClass, @NotNull ProblemBuilder problemBuilder) {
        if (builderClassName == null) {
            BuilderHandler.$$$reportNull$$$0(14);
        }
        if (psiClass == null) {
            BuilderHandler.$$$reportNull$$$0(15);
        }
        if (problemBuilder == null) {
            BuilderHandler.$$$reportNull$$$0(16);
        }
        Optional<PsiClass> optionalPsiClass = PsiClassUtil.getInnerClassInternByName(psiClass, builderClassName);
        return optionalPsiClass.map(builderClass -> this.validateInvalidAnnotationsOnBuilderClass((PsiClass)builderClass, problemBuilder)).orElse(true);
    }

    boolean validateInvalidAnnotationsOnBuilderClass(@NotNull PsiClass builderClass, @NotNull ProblemBuilder problemBuilder) {
        if (builderClass == null) {
            BuilderHandler.$$$reportNull$$$0(17);
        }
        if (problemBuilder == null) {
            BuilderHandler.$$$reportNull$$$0(18);
        }
        if (PsiAnnotationSearchUtil.checkAnnotationsSimpleNameExistsIn((PsiModifierListOwner)builderClass, INVALID_ON_BUILDERS)) {
            problemBuilder.addError("Lombok annotations are not allowed on builder class.");
            return false;
        }
        return true;
    }

    private boolean validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull ProblemBuilder builder) {
        if (psiClass == null) {
            BuilderHandler.$$$reportNull$$$0(19);
        }
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(20);
        }
        if (builder == null) {
            BuilderHandler.$$$reportNull$$$0(21);
        }
        if (psiClass.isAnnotationType() || psiClass.isInterface() || psiClass.isEnum()) {
            builder.addError(String.format("@%s can be used on classes only", psiAnnotation.getQualifiedName()));
            return false;
        }
        return true;
    }

    private boolean validateObtainViaAnnotations(Stream<BuilderInfo> builderInfos, @NotNull ProblemBuilder problemBuilder) {
        if (problemBuilder == null) {
            BuilderHandler.$$$reportNull$$$0(22);
        }
        AtomicBoolean result = new AtomicBoolean(true);
        builderInfos.map(BuilderInfo::withObtainVia).filter(BuilderInfo::hasObtainViaAnnotation).forEach(builderInfo -> {
            if (StringUtil.isEmpty((String)builderInfo.getViaFieldName()) == StringUtil.isEmpty((String)builderInfo.getViaMethodName())) {
                problemBuilder.addError("The syntax is either @ObtainVia(field = \"fieldName\") or @ObtainVia(method = \"methodName\").");
                result.set(false);
            }
            if (StringUtil.isEmpty((String)builderInfo.getViaMethodName()) && builderInfo.isViaStaticCall()) {
                problemBuilder.addError("@ObtainVia(isStatic = true) is not valid unless 'method' has been set.");
                result.set(false);
            }
        });
        return result.get();
    }

    public Optional<PsiClass> getExistInnerBuilderClass(@NotNull PsiClass psiClass, @Nullable PsiMethod psiMethod, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            BuilderHandler.$$$reportNull$$$0(23);
        }
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(24);
        }
        String builderClassName = this.getBuilderClassName(psiClass, psiAnnotation, psiMethod);
        return PsiClassUtil.getInnerClassInternByName(psiClass, builderClassName);
    }

    PsiType getReturnTypeOfBuildMethod(@NotNull PsiClass psiClass, @Nullable PsiMethod psiMethod) {
        if (psiClass == null) {
            BuilderHandler.$$$reportNull$$$0(25);
        }
        Object result = null == psiMethod || psiMethod.isConstructor() ? PsiClassUtil.getTypeWithGenerics(psiClass) : psiMethod.getReturnType();
        return result;
    }

    @NotNull
    public String getBuildMethodName(@NotNull PsiAnnotation psiAnnotation) {
        String buildMethodName;
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(26);
        }
        String string = StringUtil.isEmptyOrSpaces((String)(buildMethodName = PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, ANNOTATION_BUILD_METHOD_NAME))) ? BUILD_METHOD_NAME : buildMethodName;
        if (string == null) {
            BuilderHandler.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    String getBuilderMethodName(@NotNull PsiAnnotation psiAnnotation) {
        String builderMethodName;
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(28);
        }
        String string = null == (builderMethodName = PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, ANNOTATION_BUILDER_METHOD_NAME)) ? BUILDER_METHOD_NAME : builderMethodName;
        if (string == null) {
            BuilderHandler.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    private String getSetterPrefix(@NotNull PsiAnnotation psiAnnotation) {
        String setterPrefix;
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(30);
        }
        String string = null == (setterPrefix = PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, ANNOTATION_SETTER_PREFIX)) ? "" : setterPrefix;
        if (string == null) {
            BuilderHandler.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    @PsiModifier.ModifierConstant
    private String getBuilderOuterAccessVisibility(@NotNull PsiAnnotation psiAnnotation) {
        String accessVisibility;
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(32);
        }
        String string = null == (accessVisibility = LombokProcessorUtil.getAccessVisibility(psiAnnotation)) ? "public" : accessVisibility;
        if (string == null) {
            BuilderHandler.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    @PsiModifier.ModifierConstant
    private String getBuilderInnerAccessVisibility(@NotNull PsiAnnotation psiAnnotation) {
        String accessVisibility;
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(34);
        }
        String string = "protected".equals(accessVisibility = this.getBuilderOuterAccessVisibility(psiAnnotation)) ? "public" : accessVisibility;
        if (string == null) {
            BuilderHandler.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    private String getBuilderClassName(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            BuilderHandler.$$$reportNull$$$0(36);
        }
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(37);
        }
        String string = this.getBuilderClassName(psiClass, psiAnnotation, null);
        if (string == null) {
            BuilderHandler.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    public String getBuilderClassName(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @Nullable PsiMethod psiMethod) {
        PsiType psiMethodReturnType;
        String builderClassName;
        if (psiClass == null) {
            BuilderHandler.$$$reportNull$$$0(39);
        }
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(40);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(builderClassName = PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, ANNOTATION_BUILDER_CLASS_NAME)))) {
            String string = builderClassName;
            if (string == null) {
                BuilderHandler.$$$reportNull$$$0(41);
            }
            return string;
        }
        String relevantReturnType = psiClass.getName();
        if (null != psiMethod && !psiMethod.isConstructor() && null != (psiMethodReturnType = psiMethod.getReturnType())) {
            relevantReturnType = PsiNameHelper.getQualifiedClassName((String)psiMethodReturnType.getPresentableText(), (boolean)false);
        }
        String string = this.getBuilderClassName(psiClass, relevantReturnType);
        if (string == null) {
            BuilderHandler.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    String getBuilderClassName(@NotNull PsiClass psiClass, String returnTypeName) {
        if (psiClass == null) {
            BuilderHandler.$$$reportNull$$$0(43);
        }
        ConfigDiscovery configDiscovery = ConfigDiscovery.getInstance();
        String builderClassNamePattern = configDiscovery.getStringLombokConfigProperty(ConfigKey.BUILDER_CLASS_NAME, psiClass);
        String string = StringUtil.replace((String)builderClassNamePattern, (String)"*", (String)StringUtil.capitalize((String)returnTypeName));
        if (string == null) {
            BuilderHandler.$$$reportNull$$$0(44);
        }
        return string;
    }

    boolean hasMethod(@NotNull PsiClass psiClass, @NotNull String builderMethodName) {
        if (psiClass == null) {
            BuilderHandler.$$$reportNull$$$0(45);
        }
        if (builderMethodName == null) {
            BuilderHandler.$$$reportNull$$$0(46);
        }
        Collection<PsiMethod> existingMethods = PsiClassUtil.collectClassStaticMethodsIntern(psiClass);
        return existingMethods.stream().map(PsiMethod::getName).anyMatch(builderMethodName::equals);
    }

    public Collection<PsiMethod> createBuilderDefaultProviderMethodsIfNecessary(@NotNull PsiClass containingClass, @Nullable PsiMethod psiMethod, @NotNull PsiClass builderPsiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (containingClass == null) {
            BuilderHandler.$$$reportNull$$$0(47);
        }
        if (builderPsiClass == null) {
            BuilderHandler.$$$reportNull$$$0(48);
        }
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(49);
        }
        List<BuilderInfo> builderInfos = this.createBuilderInfos(psiAnnotation, containingClass, psiMethod, builderPsiClass);
        return builderInfos.stream().filter(BuilderInfo::hasBuilderDefaultAnnotation).filter(b -> !b.hasSingularAnnotation()).filter(b -> !b.hasNoInitializer()).map(this::createBuilderDefaultProviderMethod).collect(Collectors.toList());
    }

    private PsiMethod createBuilderDefaultProviderMethod(@NotNull BuilderInfo info) {
        if (info == null) {
            BuilderHandler.$$$reportNull$$$0(50);
        }
        PsiClass containingClass = info.getBuilderClass().getContainingClass();
        String blockText = String.format("return %s;", info.getFieldInitializer().getText());
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(containingClass.getManager(), info.renderFieldDefaultProviderName()).withMethodReturnType(info.getFieldType()).withContainingClass(containingClass).withNavigationElement((PsiElement)info.getVariable()).withModifier("private").withModifier("static");
        return methodBuilder.withBody(PsiMethodUtil.createCodeBlockFromText(blockText, (PsiElement)methodBuilder));
    }

    public Optional<PsiMethod> createBuilderMethodIfNecessary(@NotNull PsiClass containingClass, @Nullable PsiMethod psiMethod, @NotNull PsiClass builderPsiClass, @NotNull PsiAnnotation psiAnnotation) {
        String builderMethodName;
        if (containingClass == null) {
            BuilderHandler.$$$reportNull$$$0(51);
        }
        if (builderPsiClass == null) {
            BuilderHandler.$$$reportNull$$$0(52);
        }
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(53);
        }
        if (!(builderMethodName = this.getBuilderMethodName(psiAnnotation)).isEmpty() && !this.hasMethod(containingClass, builderMethodName)) {
            PsiClassType psiTypeWithGenerics = PsiClassUtil.getTypeWithGenerics(builderPsiClass);
            String blockText = String.format("return new %s();", psiTypeWithGenerics.getPresentableText());
            LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(containingClass.getManager(), builderMethodName).withMethodReturnType((PsiType)psiTypeWithGenerics).withContainingClass(containingClass).withNavigationElement((PsiElement)psiAnnotation).withModifier(this.getBuilderOuterAccessVisibility(psiAnnotation));
            methodBuilder.withBody(PsiMethodUtil.createCodeBlockFromText(blockText, (PsiElement)methodBuilder));
            this.addTypeParameters(builderPsiClass, psiMethod, methodBuilder);
            if (null == psiMethod || psiMethod.isConstructor() || psiMethod.hasModifierProperty("static")) {
                methodBuilder.withModifier("static");
            }
            return Optional.of(methodBuilder);
        }
        return Optional.empty();
    }

    public Optional<PsiMethod> createToBuilderMethodIfNecessary(@NotNull PsiClass containingClass, @Nullable PsiMethod psiMethod, @NotNull PsiClass builderPsiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (containingClass == null) {
            BuilderHandler.$$$reportNull$$$0(54);
        }
        if (builderPsiClass == null) {
            BuilderHandler.$$$reportNull$$$0(55);
        }
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(56);
        }
        if (!PsiAnnotationUtil.getBooleanAnnotationValue(psiAnnotation, "toBuilder", false)) {
            return Optional.empty();
        }
        List<BuilderInfo> builderInfos = this.createBuilderInfos(psiAnnotation, containingClass, psiMethod, builderPsiClass);
        builderInfos.forEach(BuilderInfo::withObtainVia);
        Object psiTypeWithGenerics = null != psiMethod ? this.calculateResultType(builderInfos, builderPsiClass, containingClass) : PsiClassUtil.getTypeWithGenerics(builderPsiClass);
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(containingClass.getManager(), "toBuilder").withMethodReturnType((PsiType)psiTypeWithGenerics).withContainingClass(containingClass).withNavigationElement((PsiElement)psiAnnotation).withModifier(this.getBuilderOuterAccessVisibility(psiAnnotation));
        String toBuilderMethodCalls = builderInfos.stream().map(BuilderInfo::renderToBuilderCall).collect(Collectors.joining(".", ".", ""));
        String blockText = String.format("return new %s()%s;", psiTypeWithGenerics.getPresentableText(), toBuilderMethodCalls);
        methodBuilder.withBody(PsiMethodUtil.createCodeBlockFromText(blockText, (PsiElement)methodBuilder));
        return Optional.of(methodBuilder);
    }

    private PsiType calculateResultType(@NotNull List<BuilderInfo> builderInfos, PsiClass builderPsiClass, PsiClass psiClass) {
        if (builderInfos == null) {
            BuilderHandler.$$$reportNull$$$0(57);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
        PsiType[] psiTypes = (PsiType[])builderInfos.stream().map(BuilderInfo::getObtainViaFieldVariableType).filter(Optional::isPresent).map(Optional::get).toArray(PsiType[]::new);
        return factory.createType(builderPsiClass, psiTypes);
    }

    @NotNull
    private Stream<BuilderInfo> createBuilderInfos(@NotNull PsiClass psiClass, @Nullable PsiMethod psiClassMethod) {
        if (psiClass == null) {
            BuilderHandler.$$$reportNull$$$0(58);
        }
        Stream<BuilderInfo> result = null != psiClassMethod ? Arrays.stream(psiClassMethod.getParameterList().getParameters()).map(BuilderInfo::fromPsiParameter) : PsiClassUtil.collectClassFieldsIntern(psiClass).stream().map(BuilderInfo::fromPsiField).filter(BuilderInfo::useForBuilder);
        Stream<BuilderInfo> stream = result;
        if (stream == null) {
            BuilderHandler.$$$reportNull$$$0(59);
        }
        return stream;
    }

    public List<BuilderInfo> createBuilderInfos(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @Nullable PsiMethod psiClassMethod, @NotNull PsiClass builderClass) {
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(60);
        }
        if (psiClass == null) {
            BuilderHandler.$$$reportNull$$$0(61);
        }
        if (builderClass == null) {
            BuilderHandler.$$$reportNull$$$0(62);
        }
        PsiSubstitutor builderSubstitutor = this.getBuilderSubstitutor((PsiTypeParameterListOwner)psiClass, builderClass);
        String accessVisibility = this.getBuilderInnerAccessVisibility(psiAnnotation);
        String setterPrefix = this.getSetterPrefix(psiAnnotation);
        return this.createBuilderInfos(psiClass, psiClassMethod).map(info -> info.withSubstitutor(builderSubstitutor)).map(info -> info.withBuilderClass(builderClass)).map(info -> info.withVisibilityModifier(accessVisibility)).map(info -> info.withSetterPrefix(setterPrefix)).collect(Collectors.toList());
    }

    @NotNull
    public PsiClass createBuilderClass(@NotNull PsiClass psiClass, @Nullable PsiMethod psiMethod, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            BuilderHandler.$$$reportNull$$$0(63);
        }
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(64);
        }
        LombokLightClassBuilder builderClass = null != psiMethod ? this.createEmptyBuilderClass(psiClass, psiMethod, psiAnnotation) : this.createEmptyBuilderClass(psiClass, psiAnnotation);
        builderClass.withMethods(this.createConstructors((PsiClass)builderClass, psiAnnotation));
        List<BuilderInfo> builderInfos = this.createBuilderInfos(psiAnnotation, psiClass, psiMethod, (PsiClass)builderClass);
        builderInfos.stream().map(BuilderInfo::renderBuilderFields).forEach(builderClass::withFields);
        builderInfos.stream().map(BuilderInfo::renderBuilderMethods).forEach(builderClass::withMethods);
        String buildMethodName = this.getBuildMethodName(psiAnnotation);
        builderClass.addMethod(this.createBuildMethod(psiAnnotation, psiClass, psiMethod, (PsiClass)builderClass, buildMethodName, builderInfos));
        builderClass.addMethod(this.createToStringMethod(psiAnnotation, (PsiClass)builderClass));
        LombokLightClassBuilder lombokLightClassBuilder = builderClass;
        if (lombokLightClassBuilder == null) {
            BuilderHandler.$$$reportNull$$$0(65);
        }
        return lombokLightClassBuilder;
    }

    @NotNull
    private LombokLightClassBuilder createEmptyBuilderClass(@NotNull PsiClass psiClass, @NotNull PsiMethod psiMethod, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            BuilderHandler.$$$reportNull$$$0(66);
        }
        if (psiMethod == null) {
            BuilderHandler.$$$reportNull$$$0(67);
        }
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(68);
        }
        return this.createBuilderClass(psiClass, (PsiTypeParameterListOwner)psiMethod, psiMethod.isConstructor() || psiMethod.hasModifierProperty("static"), psiAnnotation);
    }

    @NotNull
    private LombokLightClassBuilder createEmptyBuilderClass(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            BuilderHandler.$$$reportNull$$$0(69);
        }
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(70);
        }
        return this.createBuilderClass(psiClass, (PsiTypeParameterListOwner)psiClass, true, psiAnnotation);
    }

    public Optional<PsiClass> createBuilderClassIfNotExist(@NotNull PsiClass psiClass, @Nullable PsiMethod psiMethod, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            BuilderHandler.$$$reportNull$$$0(71);
        }
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(72);
        }
        PsiClass builderClass = null;
        if (this.getExistInnerBuilderClass(psiClass, psiMethod, psiAnnotation).isEmpty()) {
            builderClass = this.createBuilderClass(psiClass, psiMethod, psiAnnotation);
        }
        return Optional.ofNullable(builderClass);
    }

    @NotNull
    public PsiMethod createToStringMethod(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass builderClass) {
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(73);
        }
        if (builderClass == null) {
            BuilderHandler.$$$reportNull$$$0(74);
        }
        PsiMethod psiMethod = this.createToStringMethod(psiAnnotation, builderClass, false);
        if (psiMethod == null) {
            BuilderHandler.$$$reportNull$$$0(75);
        }
        return psiMethod;
    }

    @NotNull
    PsiMethod createToStringMethod(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass builderClass, boolean forceCallSuper) {
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(76);
        }
        if (builderClass == null) {
            BuilderHandler.$$$reportNull$$$0(77);
        }
        List<EqualsAndHashCodeToStringHandler.MemberInfo> memberInfos = Arrays.stream(builderClass.getFields()).filter(this::isNotBuilderDefaultSetterFields).map(EqualsAndHashCodeToStringHandler.MemberInfo::new).collect(Collectors.toList());
        PsiMethod psiMethod = this.getToStringProcessor().createToStringMethod(builderClass, memberInfos, psiAnnotation, forceCallSuper);
        if (psiMethod == null) {
            BuilderHandler.$$$reportNull$$$0(78);
        }
        return psiMethod;
    }

    private boolean isNotBuilderDefaultSetterFields(@NotNull PsiField psiField) {
        PsiElement navigationElement;
        if (psiField == null) {
            BuilderHandler.$$$reportNull$$$0(79);
        }
        boolean isBuilderDefaultSetter = false;
        if (psiField.getName().endsWith("$set") && PsiType.BOOLEAN.equals((Object)psiField.getType()) && (navigationElement = psiField.getNavigationElement()) instanceof PsiField) {
            isBuilderDefaultSetter = PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)((PsiField)navigationElement), "lombok.Builder.Default");
        }
        return !isBuilderDefaultSetter;
    }

    @NotNull
    private LombokLightClassBuilder createBuilderClass(@NotNull PsiClass psiClass, @NotNull PsiTypeParameterListOwner psiTypeParameterListOwner, boolean isStatic, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            BuilderHandler.$$$reportNull$$$0(80);
        }
        if (psiTypeParameterListOwner == null) {
            BuilderHandler.$$$reportNull$$$0(81);
        }
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(82);
        }
        PsiMethod psiMethod = null;
        if (psiTypeParameterListOwner instanceof PsiMethod) {
            psiMethod = (PsiMethod)psiTypeParameterListOwner;
        }
        String builderClassName = this.getBuilderClassName(psiClass, psiAnnotation, psiMethod);
        String builderClassQualifiedName = psiClass.getQualifiedName() + "." + builderClassName;
        LombokLightClassBuilder classBuilder = new LombokLightClassBuilder((PsiElement)psiClass, builderClassName, builderClassQualifiedName).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation).withParameterTypes(null != psiMethod && psiMethod.isConstructor() ? psiClass.getTypeParameterList() : psiTypeParameterListOwner.getTypeParameterList()).withModifier(this.getBuilderOuterAccessVisibility(psiAnnotation));
        if (isStatic) {
            classBuilder.withModifier("static");
        }
        LombokLightClassBuilder lombokLightClassBuilder = classBuilder;
        if (lombokLightClassBuilder == null) {
            BuilderHandler.$$$reportNull$$$0(83);
        }
        return lombokLightClassBuilder;
    }

    @NotNull
    public Collection<PsiMethod> createConstructors(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            BuilderHandler.$$$reportNull$$$0(84);
        }
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(85);
        }
        Collection<PsiMethod> methodsIntern = PsiClassUtil.collectClassConstructorIntern(psiClass);
        NoArgsConstructorProcessor noArgsConstructorProcessor = this.getNoArgsConstructorProcessor();
        String constructorName = noArgsConstructorProcessor.getConstructorName(psiClass);
        for (PsiMethod existedConstructor : methodsIntern) {
            if (!constructorName.equals(existedConstructor.getName()) || existedConstructor.getParameterList().getParametersCount() != 0) continue;
            Set<PsiMethod> set = Collections.emptySet();
            if (set == null) {
                BuilderHandler.$$$reportNull$$$0(86);
            }
            return set;
        }
        Collection<PsiMethod> collection = noArgsConstructorProcessor.createNoArgsConstructor(psiClass, "packageLocal", psiAnnotation);
        if (collection == null) {
            BuilderHandler.$$$reportNull$$$0(87);
        }
        return collection;
    }

    @NotNull
    public PsiMethod createBuildMethod(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass parentClass, @Nullable PsiMethod psiMethod, @NotNull PsiClass builderClass, @NotNull String buildMethodName, List<BuilderInfo> builderInfos) {
        if (psiAnnotation == null) {
            BuilderHandler.$$$reportNull$$$0(88);
        }
        if (parentClass == null) {
            BuilderHandler.$$$reportNull$$$0(89);
        }
        if (builderClass == null) {
            BuilderHandler.$$$reportNull$$$0(90);
        }
        if (buildMethodName == null) {
            BuilderHandler.$$$reportNull$$$0(91);
        }
        PsiType builderType = this.getReturnTypeOfBuildMethod(parentClass, psiMethod);
        PsiSubstitutor builderSubstitutor = this.getBuilderSubstitutor((PsiTypeParameterListOwner)parentClass, builderClass);
        PsiType returnType = builderSubstitutor.substitute(builderType);
        String buildMethodPrepare = builderInfos.stream().map(BuilderInfo::renderBuildPrepare).collect(Collectors.joining());
        String buildMethodParameters = builderInfos.stream().map(BuilderInfo::renderBuildCall).collect(Collectors.joining(","));
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(parentClass.getManager(), buildMethodName).withMethodReturnType(returnType).withContainingClass(builderClass).withNavigationElement((PsiElement)parentClass).withModifier(this.getBuilderInnerAccessVisibility(psiAnnotation));
        String codeBlockText = this.createBuildMethodCodeBlockText(psiMethod, builderClass, returnType, buildMethodPrepare, buildMethodParameters);
        methodBuilder.withBody(PsiMethodUtil.createCodeBlockFromText(codeBlockText, (PsiElement)methodBuilder));
        Optional<PsiMethod> definedConstructor = Optional.ofNullable(psiMethod);
        if (definedConstructor.isEmpty()) {
            Collection<PsiMethod> classConstructors = PsiClassUtil.collectClassConstructorIntern(parentClass);
            definedConstructor = classConstructors.stream().filter(m -> this.sameParameters(m.getParameterList().getParameters(), builderInfos)).findFirst();
        }
        definedConstructor.map(PsiMethod::getThrowsList).map(PsiReferenceList::getReferencedTypes).map(Arrays::stream).ifPresent(stream -> stream.forEach(methodBuilder::withException));
        LombokLightMethodBuilder lombokLightMethodBuilder = methodBuilder;
        if (lombokLightMethodBuilder == null) {
            BuilderHandler.$$$reportNull$$$0(92);
        }
        return lombokLightMethodBuilder;
    }

    private boolean sameParameters(PsiParameter[] parameters, List<BuilderInfo> builderInfos) {
        if (parameters.length != builderInfos.size()) {
            return false;
        }
        Iterator<BuilderInfo> builderInfoIterator = builderInfos.iterator();
        for (PsiParameter psiParameter : parameters) {
            BuilderInfo builderInfo = builderInfoIterator.next();
            if (psiParameter.getType().isAssignableFrom(builderInfo.getFieldType())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private String createBuildMethodCodeBlockText(@Nullable PsiMethod psiMethod, @NotNull PsiClass psiClass, @NotNull PsiType buildMethodReturnType, @NotNull String buildMethodPrepare, @NotNull String buildMethodParameters) {
        String blockText;
        String callExpressionText;
        String codeBlockFormat;
        if (psiClass == null) {
            BuilderHandler.$$$reportNull$$$0(93);
        }
        if (buildMethodReturnType == null) {
            BuilderHandler.$$$reportNull$$$0(94);
        }
        if (buildMethodPrepare == null) {
            BuilderHandler.$$$reportNull$$$0(95);
        }
        if (buildMethodParameters == null) {
            BuilderHandler.$$$reportNull$$$0(96);
        }
        if (null == psiMethod || psiMethod.isConstructor()) {
            codeBlockFormat = "%s\n return new %s(%s);";
            callExpressionText = buildMethodReturnType.getPresentableText();
        } else {
            codeBlockFormat = PsiType.VOID.equals((Object)buildMethodReturnType) ? "%s\n %s(%s);" : "%s\n return %s(%s);";
            callExpressionText = this.calculateCallExpressionForMethod(psiMethod, psiClass);
        }
        String string = blockText = String.format(codeBlockFormat, buildMethodPrepare, callExpressionText, buildMethodParameters);
        if (string == null) {
            BuilderHandler.$$$reportNull$$$0(97);
        }
        return string;
    }

    @NotNull
    private String calculateCallExpressionForMethod(@NotNull PsiMethod psiMethod, @NotNull PsiClass builderClass) {
        if (psiMethod == null) {
            BuilderHandler.$$$reportNull$$$0(98);
        }
        if (builderClass == null) {
            BuilderHandler.$$$reportNull$$$0(99);
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        StringBuilder className = new StringBuilder();
        if (null != containingClass) {
            className.append(containingClass.getName()).append(".");
            if (!psiMethod.isConstructor() && !psiMethod.hasModifierProperty("static")) {
                className.append("this.");
            }
            if (builderClass.hasTypeParameters()) {
                className.append(Arrays.stream(builderClass.getTypeParameters()).map(PsiQualifiedNamedElement::getName).collect(Collectors.joining(",", "<", ">")));
            }
        }
        String string = className + psiMethod.getName();
        if (string == null) {
            BuilderHandler.$$$reportNull$$$0(100);
        }
        return string;
    }

    void addTypeParameters(@NotNull PsiClass builderClass, @Nullable PsiMethod psiMethod, @NotNull LombokLightMethodBuilder methodBuilder) {
        if (builderClass == null) {
            BuilderHandler.$$$reportNull$$$0(101);
        }
        if (methodBuilder == null) {
            BuilderHandler.$$$reportNull$$$0(102);
        }
        PsiTypeParameter[] psiTypeParameters = null == psiMethod || psiMethod.isConstructor() ? builderClass.getTypeParameters() : psiMethod.getTypeParameters();
        for (PsiTypeParameter psiTypeParameter : psiTypeParameters) {
            methodBuilder.withTypeParameter(psiTypeParameter);
        }
    }

    private NoArgsConstructorProcessor getNoArgsConstructorProcessor() {
        return (NoArgsConstructorProcessor)ApplicationManager.getApplication().getService(NoArgsConstructorProcessor.class);
    }

    private ToStringProcessor getToStringProcessor() {
        return (ToStringProcessor)ApplicationManager.getApplication().getService(ToStringProcessor.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 59: 
            case 65: 
            case 75: 
            case 78: 
            case 83: 
            case 86: 
            case 87: 
            case 92: 
            case 97: 
            case 100: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 59: 
            case 65: 
            case 75: 
            case 78: 
            case 83: 
            case 86: 
            case 87: 
            case 92: 
            case 97: 
            case 100: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classOrMethodToBuild";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClass";
                break;
            }
            case 2: 
            case 15: 
            case 19: 
            case 23: 
            case 25: 
            case 36: 
            case 39: 
            case 43: 
            case 45: 
            case 58: 
            case 61: 
            case 63: 
            case 66: 
            case 69: 
            case 71: 
            case 80: 
            case 84: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: 
            case 8: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 49: 
            case 53: 
            case 56: 
            case 60: 
            case 64: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 76: 
            case 82: 
            case 85: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 16: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemBuilder";
                break;
            }
            case 5: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderInfos";
                break;
            }
            case 7: 
            case 67: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = ANNOTATION_BUILDER_CLASS_NAME;
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = BUILDER_METHOD_NAME;
                break;
            }
            case 17: 
            case 62: 
            case 74: 
            case 77: 
            case 90: 
            case 99: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderClass";
                break;
            }
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 59: 
            case 65: 
            case 75: 
            case 78: 
            case 83: 
            case 86: 
            case 87: 
            case 92: 
            case 97: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/handler/BuilderHandler";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = ANNOTATION_BUILDER_METHOD_NAME;
                break;
            }
            case 47: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 48: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderPsiClass";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiTypeParameterListOwner";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = ANNOTATION_BUILD_METHOD_NAME;
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildMethodReturnType";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildMethodPrepare";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildMethodParameters";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/handler/BuilderHandler";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildMethodName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderMethodName";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSetterPrefix";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderOuterAccessVisibility";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderInnerAccessVisibility";
                break;
            }
            case 38: 
            case 41: 
            case 42: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderClassName";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilderInfos";
                break;
            }
            case 65: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilderClass";
                break;
            }
            case 75: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "createToStringMethod";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructors";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildMethod";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildMethodCodeBlockText";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateCallExpressionForMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderSubstitutor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateBuilderDefault";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validateSingular";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "validateBuilderIdentifier";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "validateExistingBuilderClass";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "validateInvalidAnnotationsOnBuilderClass";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "validateObtainViaAnnotations";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getExistInnerBuilderClass";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeOfBuildMethod";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getBuildMethodName";
                break;
            }
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 59: 
            case 65: 
            case 75: 
            case 78: 
            case 83: 
            case 86: 
            case 87: 
            case 92: 
            case 97: 
            case 100: {
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderMethodName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSetterPrefix";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderOuterAccessVisibility";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderInnerAccessVisibility";
                break;
            }
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderClassName";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "hasMethod";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderDefaultProviderMethodsIfNecessary";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderDefaultProviderMethod";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderMethodIfNecessary";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createToBuilderMethodIfNecessary";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "calculateResultType";
                break;
            }
            case 58: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderInfos";
                break;
            }
            case 63: 
            case 64: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderClass";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyBuilderClass";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderClassIfNotExist";
                break;
            }
            case 73: 
            case 74: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "createToStringMethod";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isNotBuilderDefaultSetterFields";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "createConstructors";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "createBuildMethod";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "createBuildMethodCodeBlockText";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "calculateCallExpressionForMethod";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "addTypeParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 59: 
            case 65: 
            case 75: 
            case 78: 
            case 83: 
            case 86: 
            case 87: 
            case 92: 
            case 97: 
            case 100: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

