/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.problem.ProblemEmptyBuilder;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.EqualsAndHashCodeProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.GetterProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.SetterProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.ToStringProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.NoArgsConstructorProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.RequiredArgsConstructorProcessor;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataProcessor
extends AbstractClassProcessor {
    public DataProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.Data");
    }

    private ToStringProcessor getToStringProcessor() {
        return (ToStringProcessor)ApplicationManager.getApplication().getService(ToStringProcessor.class);
    }

    private NoArgsConstructorProcessor getNoArgsConstructorProcessor() {
        return (NoArgsConstructorProcessor)ApplicationManager.getApplication().getService(NoArgsConstructorProcessor.class);
    }

    private GetterProcessor getGetterProcessor() {
        return (GetterProcessor)ApplicationManager.getApplication().getService(GetterProcessor.class);
    }

    private SetterProcessor getSetterProcessor() {
        return (SetterProcessor)ApplicationManager.getApplication().getService(SetterProcessor.class);
    }

    private EqualsAndHashCodeProcessor getEqualsAndHashCodeProcessor() {
        return (EqualsAndHashCodeProcessor)ApplicationManager.getApplication().getService(EqualsAndHashCodeProcessor.class);
    }

    private RequiredArgsConstructorProcessor getRequiredArgsConstructorProcessor() {
        return (RequiredArgsConstructorProcessor)ApplicationManager.getApplication().getService(RequiredArgsConstructorProcessor.class);
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        String staticName;
        PsiAnnotation equalsAndHashCodeAnnotation;
        if (psiAnnotation == null) {
            DataProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            DataProcessor.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            DataProcessor.$$$reportNull$$$0(2);
        }
        if (null == (equalsAndHashCodeAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiClass, "lombok.EqualsAndHashCode"))) {
            this.getEqualsAndHashCodeProcessor().validateCallSuperParamExtern(psiAnnotation, psiClass, builder);
        }
        if (this.shouldGenerateRequiredArgsConstructor(psiClass, staticName = PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, "staticConstructor"))) {
            this.getRequiredArgsConstructorProcessor().validateBaseClassConstructor(psiClass, builder);
        }
        return this.validateAnnotationOnRightType(psiClass, builder);
    }

    private boolean validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiClass == null) {
            DataProcessor.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            DataProcessor.$$$reportNull$$$0(4);
        }
        boolean result = true;
        if (psiClass.isAnnotationType() || psiClass.isInterface() || psiClass.isEnum()) {
            builder.addError("'@Data' is only supported on a class type");
            result = false;
        }
        return result;
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target) {
        boolean hasConstructorWithoutParamaters;
        String staticName;
        if (psiClass == null) {
            DataProcessor.$$$reportNull$$$0(5);
        }
        if (psiAnnotation == null) {
            DataProcessor.$$$reportNull$$$0(6);
        }
        if (target == null) {
            DataProcessor.$$$reportNull$$$0(7);
        }
        if (PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.Getter")) {
            target.addAll(this.getGetterProcessor().createFieldGetters(psiClass, "public"));
        }
        if (PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.Setter")) {
            target.addAll(this.getSetterProcessor().createFieldSetters(psiClass, "public"));
        }
        if (PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.EqualsAndHashCode")) {
            target.addAll(this.getEqualsAndHashCodeProcessor().createEqualAndHashCode(psiClass, psiAnnotation));
        }
        if (PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.ToString")) {
            target.addAll(this.getToStringProcessor().createToStringMethod(psiClass, psiAnnotation));
        }
        if (this.shouldGenerateRequiredArgsConstructor(psiClass, staticName = PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, "staticConstructor"))) {
            target.addAll(this.getRequiredArgsConstructorProcessor().createRequiredArgsConstructor(psiClass, "public", psiAnnotation, staticName, true));
            hasConstructorWithoutParamaters = this.getRequiredArgsConstructorProcessor().getRequiredFields(psiClass).isEmpty();
        } else {
            hasConstructorWithoutParamaters = false;
        }
        if (!hasConstructorWithoutParamaters && this.shouldGenerateExtraNoArgsConstructor(psiClass)) {
            target.addAll(this.getNoArgsConstructorProcessor().createNoArgsConstructor(psiClass, "private", psiAnnotation, true));
        }
    }

    private boolean shouldGenerateRequiredArgsConstructor(@NotNull PsiClass psiClass, @Nullable String staticName) {
        if (psiClass == null) {
            DataProcessor.$$$reportNull$$$0(8);
        }
        boolean result = false;
        boolean notAnnotatedWith = PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.NoArgsConstructor", "lombok.RequiredArgsConstructor", "lombok.AllArgsConstructor", "lombok.Builder", "lombok.experimental.SuperBuilder");
        if (notAnnotatedWith) {
            RequiredArgsConstructorProcessor requiredArgsConstructorProcessor = this.getRequiredArgsConstructorProcessor();
            Collection<PsiField> requiredFields = requiredArgsConstructorProcessor.getRequiredFields(psiClass);
            result = requiredArgsConstructorProcessor.validateIsConstructorNotDefined(psiClass, staticName, requiredFields, ProblemEmptyBuilder.getInstance());
        }
        return result;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        if (psiField == null) {
            DataProcessor.$$$reportNull$$$0(9);
        }
        if (psiAnnotation == null) {
            DataProcessor.$$$reportNull$$$0(10);
        }
        return LombokPsiElementUsage.READ_WRITE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/DataProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "validateAnnotationOnRightType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "generatePsiElements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldGenerateRequiredArgsConstructor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFieldUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

