/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.statistics;

import com.intellij.facet.ProjectFacetManager;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.PlatformVersion;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacetType;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getBuildSystemType", "", "it", "Lcom/intellij/openapi/module/Module;", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "getPlatform", "Companion", "kotlin.core"})
public final class ProjectConfigurationCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP;
    private static final StringEventField systemField;
    private static final StringEventField platformField;
    private static final PrimitiveEventField<PluginInfo> pluginInfoField;
    private static final VarargEventId buildEvent;
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (PlatformVersion.Companion.isAndroidStudio()) {
            return SetsKt.emptySet();
        }
        boolean bl = false;
        Set metrics = new LinkedHashSet();
        List list = ProjectFacetManager.getInstance((Project)project).getModulesWithFacet(KotlinFacetType.Companion.getTYPE_ID());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ProjectFacetManager.getI\u2026(KotlinFacetType.TYPE_ID)");
        List modulesWithFacet = list;
        Collection collection = modulesWithFacet;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            Iterable $this$forEach$iv = modulesWithFacet;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Module it = (Module)element$iv;
                boolean bl3 = false;
                Module module = it;
                Intrinsics.checkNotNullExpressionValue((Object)module, (String)"it");
                String buildSystem = this.getBuildSystemType(module);
                String platform = this.getPlatform(it);
                metrics.add(buildEvent.metric(new EventPair[]{new EventPair((EventField)systemField, (Object)buildSystem)}));
                metrics.add(buildEvent.metric(new EventPair[]{new EventPair((EventField)platformField, (Object)platform)}));
            }
        }
        PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfoById((PluginId)KotlinPluginUtil.INSTANCE.getKOTLIN_PLUGIN_ID());
        metrics.add(buildEvent.metric(new EventPair[]{new EventPair((EventField)pluginInfoField, (Object)pluginInfo)}));
        return metrics;
    }

    private final String getPlatform(Module it) {
        String string;
        if (JvmPlatformKt.isJvm((TargetPlatform)PlatformKt.getPlatform(it))) {
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
            string = StringsKt.contains$default((CharSequence)string2, (CharSequence)"android", (boolean)false, (int)2, null) ? "jvm.android" : "jvm";
        } else if (JsPlatformKt.isJs((TargetPlatform)PlatformKt.getPlatform(it))) {
            string = "js";
        } else if (TargetPlatformKt.isCommon((TargetPlatform)PlatformKt.getPlatform(it))) {
            string = "common";
        } else if (NativePlatformKt.isNative((TargetPlatform)PlatformKt.getPlatform(it))) {
            StringBuilder stringBuilder = new StringBuilder().append("native.");
            Object object = PlatformKt.getPlatform(it);
            if (object == null || (object = object.getComponentPlatforms()) == null || (object = (SimplePlatform)CollectionsKt.first((Iterable)((Iterable)object))) == null || (object = object.getTargetName()) == null) {
                object = "unknown";
            }
            string = stringBuilder.append((String)object).toString();
        } else {
            string = "unknown";
        }
        return string;
    }

    private final String getBuildSystemType(Module it) {
        String string;
        BuildSystemType buildSystem = BuildSystemTypeKt.getBuildSystemType(it);
        if (Intrinsics.areEqual((Object)buildSystem, (Object)BuildSystemType.JPS.INSTANCE)) {
            string = "JPS";
        } else {
            String string2 = buildSystem.toString();
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"maven", (boolean)false, (int)2, null)) {
                string = "Maven";
            } else {
                string2 = buildSystem.toString();
                bl = false;
                String string5 = string2;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
                string = StringsKt.contains$default((CharSequence)string6, (CharSequence)"gradle", (boolean)false, (int)2, null) ? "Gradle" : "unknown";
            }
        }
        return string;
    }

    static {
        Companion = new Companion(null);
        GROUP = new EventLogGroup("kotlin.project.configuration", 3);
        systemField = EventFields.String((String)"system", (List)CollectionsKt.listOf((Object[])new String[]{"JPS", "Maven", "Gradle", "unknown"}));
        platformField = EventFields.String((String)"platform", (List)ProjectConfigurationCollector.Companion.composePlatformFields());
        pluginInfoField = EventFields.PluginInfo;
        buildEvent = GROUP.registerVarargEvent("Build", new EventField[]{(EventField)systemField, (EventField)platformField, (EventField)pluginInfoField});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector$Companion;", "", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "buildEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "platformField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "pluginInfoField", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "systemField", "composePlatformFields", "", "", "kotlin.core"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final List<String> composePlatformFields() {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object[] objectArray = new List[2];
            objectArray[0] = CollectionsKt.listOf((Object[])new String[]{"jvm", "jvm.android", "js", "common", "native.unknown", "unknown"});
            Iterable iterable = KonanTarget.Companion.getPredefinedTargets().keySet();
            int n = 1;
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = objectArray;
            boolean $i$f$map = false;
            void var3_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string2 = "native." + (String)it;
                collection.add(string2);
            }
            collection = (List)destination$iv$iv;
            objectArray2[n] = collection;
            return CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray3));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

