/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.checkers.utils.DebugInfoUtil;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DebugInfoAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "Companion", "kotlin.core"})
public final class DebugInfoAnnotator
implements Annotator {
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!Companion.isDebugInfoEnabled() || !ProjectRootsUtil.isInProjectOrLibSource$default(element2, false, 2, null)) {
            return;
        }
        if (element2 instanceof KtFile && !(element2 instanceof KtCodeFragment)) {
            try {
                void $this$analyzeWithContent$iv$iv;
                KtDeclarationContainer $this$analyzeWithContent$iv = (KtDeclarationContainer)element2;
                boolean $i$f$analyzeWithContent = false;
                KtDeclarationContainer ktDeclarationContainer = $this$analyzeWithContent$iv;
                ResolutionFacade resolutionFacade$iv$iv = ResolutionUtils.getResolutionFacade((KtElement)((KtElement)$this$analyzeWithContent$iv));
                boolean $i$f$analyzeWithContent2 = false;
                BindingContext bindingContext = resolutionFacade$iv$iv.analyzeWithAllCompilerChecks((Collection)CollectionsKt.listOf((Object)$this$analyzeWithContent$iv$iv)).getBindingContext();
                DebugInfoUtil.markDebugAnnotations((PsiElement)element2, (BindingContext)bindingContext, (DebugInfoUtil.DebugInfoReporter)new DebugInfoUtil.DebugInfoReporter(holder){
                    final /* synthetic */ AnnotationHolder $holder;

                    public void reportElementWithErrorType(@NotNull KtReferenceExpression expression) {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        Annotation annotation = this.$holder.createErrorAnnotation((PsiElement)expression, "[DEBUG] Resolved to error element");
                        Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"holder.createErrorAnnota\u2026solved to error element\")");
                        annotation.setTextAttributes(KotlinHighlightingColors.RESOLVED_TO_ERROR);
                    }

                    public void reportMissingUnresolved(@NotNull KtReferenceExpression expression) {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        Annotation annotation = this.$holder.createErrorAnnotation((PsiElement)expression, "[DEBUG] Reference is not resolved to anything, but is not marked unresolved");
                        Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"holder.createErrorAnnota\u2026                        )");
                        annotation.setTextAttributes(KotlinHighlightingColors.DEBUG_INFO);
                    }

                    public void reportUnresolvedWithTarget(@NotNull KtReferenceExpression expression, @NotNull String target) {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                        Annotation annotation = this.$holder.createErrorAnnotation((PsiElement)expression, "[DEBUG] Reference marked as unresolved is actually resolved to " + target);
                        Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"holder.createErrorAnnota\u2026lly resolved to $target\")");
                        annotation.setTextAttributes(KotlinHighlightingColors.DEBUG_INFO);
                    }
                    {
                        this.$holder = $captured_local_variable$0;
                    }
                });
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Throwable e) {
                holder.createErrorAnnotation(element2, e.getClass().getCanonicalName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DebugInfoAnnotator$Companion;", "", "()V", "isDebugInfoEnabled", "", "()Z", "kotlin.core"})
    public static final class Companion {
        public final boolean isDebugInfoEnabled() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            return application.isInternal() && (KotlinPluginUtil.isSnapshotVersion() || KotlinPluginUtil.INSTANCE.isDevVersion());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

