/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve.util;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveScopeEnlarger;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.ScriptModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.util.KotlinResolveScopeEnlarger;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"enlargedSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "searchScope", "module", "Lcom/intellij/openapi/module/Module;", "isTestScope", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "getResolveScope", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.core"})
public final class ScopeUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GlobalSearchScope getResolveScope(@NotNull KtFile file) {
        GlobalSearchScope globalSearchScope;
        KtFile ktFile;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file instanceof KtCodeFragment && (ktFile = ((KtCodeFragment)file).getContextContainingFile()) != null && (ktFile = ktFile.getResolveScope()) != null) {
            GlobalSearchScope globalSearchScope2;
            KtFile ktFile2 = ktFile;
            boolean bl = false;
            boolean bl2 = false;
            KtFile it = ktFile2;
            boolean bl3 = false;
            IdeaModuleInfo ideaModuleInfo = GetModuleInfoKt.getModuleInfo((PsiElement)file);
            if (ideaModuleInfo instanceof SourceForBinaryModuleInfo) {
                KtFile ktFile3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)ktFile3, (String)"it");
                Project project = ((KtCodeFragment)file).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
                globalSearchScope2 = KotlinSourceFilterScope.Companion.libraryClassFiles((GlobalSearchScope)ktFile3, project);
            } else {
                KtFile ktFile4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)ktFile4, (String)"it");
                Project project = ((KtCodeFragment)file).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
                globalSearchScope2 = KotlinSourceFilterScope.Companion.sourceAndClassFiles((GlobalSearchScope)ktFile4, project);
            }
            return globalSearchScope2;
        }
        IdeaModuleInfo ideaModuleInfo = GetModuleInfoKt.getModuleInfo((PsiElement)file);
        if (ideaModuleInfo instanceof ModuleSourceInfo) {
            GlobalSearchScope globalSearchScope3 = file.getResolveScope();
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope3, (String)"file.resolveScope");
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
            globalSearchScope = ScopeUtilsKt.enlargedSearchScope(KotlinSourceFilterScope.Companion.projectSourceAndClassFiles(globalSearchScope3, project), (PsiFile)file);
        } else if (ideaModuleInfo instanceof ScriptModuleInfo) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = GetModuleInfoKt.getModuleInfo((PsiElement)file).dependencies();
            boolean $i$f$map = false;
            Iterable it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                IdeaModuleInfo ideaModuleInfo2 = (IdeaModuleInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                GlobalSearchScope globalSearchScope4 = it2.contentScope();
                collection.add(globalSearchScope4);
            }
            List list = (List)destination$iv$iv;
            boolean bl = false;
            boolean bl4 = false;
            List it3 = list;
            boolean bl5 = false;
            Collection $this$toTypedArray$iv = it3;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            GlobalSearchScope[] globalSearchScopeArray = thisCollection$iv.toArray(new GlobalSearchScope[0]);
            if (globalSearchScopeArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            GlobalSearchScope globalSearchScope5 = GlobalSearchScope.union((GlobalSearchScope[])globalSearchScopeArray);
            globalSearchScope = globalSearchScope5;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope5, (String)"GlobalSearchScope.union(it.toTypedArray())");
        } else {
            GlobalSearchScope globalSearchScope6 = GlobalSearchScope.EMPTY_SCOPE;
            globalSearchScope = globalSearchScope6;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope6, (String)"GlobalSearchScope.EMPTY_SCOPE");
        }
        return globalSearchScope;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GlobalSearchScope enlargedSearchScope(@NotNull GlobalSearchScope searchScope, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null || (psiFile2 = psiFile2.getOriginalFile()) == null || (psiFile2 = psiFile2.getVirtualFile()) == null) {
            return searchScope;
        }
        PsiFile vFile = psiFile2;
        ExtensionPointName extensionPointName = ResolveScopeEnlarger.EP_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ResolveScopeEnlarger.EP_NAME");
        Object[] objectArray = extensionPointName.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ResolveScopeEnlarger.EP_NAME.extensions");
        Object[] $this$fold$iv = objectArray;
        boolean $i$f$fold = false;
        GlobalSearchScope accumulator$iv = searchScope;
        for (Object element$iv : $this$fold$iv) {
            GlobalSearchScope globalSearchScope;
            void enlarger;
            ResolveScopeEnlarger resolveScopeEnlarger = (ResolveScopeEnlarger)element$iv;
            GlobalSearchScope scope2 = accumulator$iv;
            boolean bl = false;
            SearchScope extra = enlarger.getAdditionalResolveScope((VirtualFile)vFile, scope2.getProject());
            if (extra != null) {
                GlobalSearchScope globalSearchScope2 = scope2.union(extra);
                globalSearchScope = globalSearchScope2;
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"scope.union(extra)");
            } else {
                globalSearchScope = scope2;
            }
            accumulator$iv = globalSearchScope;
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GlobalSearchScope enlargedSearchScope(@NotNull GlobalSearchScope searchScope, @NotNull Module module, boolean isTestScope) {
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Object[] objectArray = KotlinResolveScopeEnlarger.Companion.getEP_NAME().getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"KotlinResolveScopeEnlarger.EP_NAME.extensions");
        Object[] $this$fold$iv = objectArray;
        boolean $i$f$fold = false;
        GlobalSearchScope accumulator$iv = searchScope;
        for (Object element$iv : $this$fold$iv) {
            GlobalSearchScope globalSearchScope;
            void enlarger;
            KotlinResolveScopeEnlarger kotlinResolveScopeEnlarger = (KotlinResolveScopeEnlarger)element$iv;
            GlobalSearchScope scope2 = accumulator$iv;
            boolean bl = false;
            SearchScope extra = enlarger.getAdditionalResolveScope(module, isTestScope);
            if (extra != null) {
                GlobalSearchScope globalSearchScope2 = scope2.union(extra);
                globalSearchScope = globalSearchScope2;
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"scope.union(extra)");
            } else {
                globalSearchScope = scope2;
            }
            accumulator$iv = globalSearchScope;
        }
        return accumulator$iv;
    }
}

