/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiSuperMethodUtil {
    private PsiSuperMethodUtil() {
    }

    public static boolean isSuperMethod(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (method == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(0);
        }
        if (superMethod == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(1);
        }
        HierarchicalMethodSignature signature = method.getHierarchicalMethodSignature();
        for (HierarchicalMethodSignature superSignature : signature.getSuperSignatures()) {
            PsiMethod supsigme = superSignature.getMethod();
            if (!superMethod.equals(supsigme) && !PsiSuperMethodUtil.isSuperMethod(supsigme, superMethod)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static PsiSubstitutor obtainFinalSubstitutor(@NotNull PsiClass superClass, @NotNull PsiSubstitutor superSubstitutor, @NotNull PsiSubstitutor derivedSubstitutor, boolean inRawContext) {
        if (superClass == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(2);
        }
        if (superSubstitutor == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(3);
        }
        if (derivedSubstitutor == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(4);
        }
        if (inRawContext) {
            Set<PsiTypeParameter> typeParams = superSubstitutor.getSubstitutionMap().keySet();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(superClass.getProject());
            superSubstitutor = factory.createRawSubstitutor(derivedSubstitutor, typeParams.toArray(PsiTypeParameter.EMPTY_ARRAY));
        }
        HashMap<PsiTypeParameter, PsiType> map = null;
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(superClass)) {
            PsiType type = superSubstitutor.substitute(typeParameter);
            PsiType t = derivedSubstitutor.substitute(type);
            if (map == null) {
                map = new HashMap<PsiTypeParameter, PsiType>();
            }
            map.put(typeParameter, t);
        }
        PsiSubstitutor psiSubstitutor = map == null ? PsiSubstitutor.EMPTY : JavaPsiFacade.getElementFactory(superClass.getProject()).createSubstitutor(map);
        if (psiSubstitutor == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(5);
        }
        return psiSubstitutor;
    }

    @NotNull
    public static Map<MethodSignature, Set<PsiMethod>> collectOverrideEquivalents(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(6);
        }
        Object2ObjectOpenCustomHashMap overrideEquivalent = new Object2ObjectOpenCustomHashMap(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        GlobalSearchScope resolveScope = aClass.getResolveScope();
        PsiClass[] supers = aClass.getSupers();
        for (int i = 0; i < supers.length; ++i) {
            PsiClass superClass = supers[i];
            boolean subType = false;
            for (int j = 0; j < supers.length; ++j) {
                if (j == i) continue;
                subType |= supers[j].isInheritor(supers[i], true);
            }
            if (subType) continue;
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass, PsiSubstitutor.EMPTY);
            for (HierarchicalMethodSignature hms : superClass.getVisibleSignatures()) {
                PsiSubstitutor containingClassSubstitutor;
                PsiClass containingClass;
                PsiClass methodClass;
                PsiMethod method = hms.getMethod();
                if (MethodSignatureUtil.findMethodBySignature(aClass, method.getSignature(superClassSubstitutor), false) != null || (methodClass = method.getContainingClass()) == null || (containingClass = PsiSuperMethodUtil.correctClassByScope(methodClass, resolveScope)) == null || (method = containingClass.findMethodBySignature(method, false)) == null || (containingClassSubstitutor = TypeConversionUtil.getClassSubstitutor(containingClass, aClass, PsiSubstitutor.EMPTY)) == null) continue;
                PsiSubstitutor finalSubstitutor = PsiSuperMethodUtil.obtainFinalSubstitutor(containingClass, containingClassSubstitutor, hms.getSubstitutor(), false);
                MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create(method, finalSubstitutor, false);
                Set methods = overrideEquivalent.computeIfAbsent(signature, __ -> new LinkedHashSet());
                methods.add(method);
            }
        }
        Object2ObjectOpenCustomHashMap object2ObjectOpenCustomHashMap = overrideEquivalent;
        if (object2ObjectOpenCustomHashMap == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(7);
        }
        return object2ObjectOpenCustomHashMap;
    }

    @Nullable
    public static PsiClass correctClassByScope(@NotNull PsiClass psiClass, @NotNull GlobalSearchScope resolveScope) {
        String qualifiedName;
        if (psiClass == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(8);
        }
        if (resolveScope == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(9);
        }
        if ((qualifiedName = psiClass.getQualifiedName()) == null) {
            return psiClass;
        }
        PsiFile file = psiClass.getContainingFile();
        if (file == null || !file.getViewProvider().isPhysical()) {
            return psiClass;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return psiClass;
        }
        FileIndexFacade index = FileIndexFacade.getInstance((Project)file.getProject());
        if (!(index.isInSource(vFile) || index.isInLibrarySource(vFile) || index.isInLibraryClasses(vFile))) {
            return psiClass;
        }
        return JavaPsiFacade.getInstance(psiClass.getProject()).findClass(qualifiedName, resolveScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superSubstitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedSubstitutor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiSuperMethodUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiSuperMethodUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainFinalSubstitutor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectOverrideEquivalents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuperMethod";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "obtainFinalSubstitutor";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectOverrideEquivalents";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "correctClassByScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

