/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public final class FunctionalExpressionSearch
extends ExtensibleQueryFactory<PsiFunctionalExpression, SearchParameters> {
    private static final FunctionalExpressionSearch INSTANCE = new FunctionalExpressionSearch();

    public static Query<PsiFunctionalExpression> search(@NotNull PsiClass aClass, @NotNull SearchScope scope) {
        if (aClass == null) {
            FunctionalExpressionSearch.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            FunctionalExpressionSearch.$$$reportNull$$$0(1);
        }
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(aClass, scope), SmartPointerManager::createPointer);
    }

    public static Query<PsiFunctionalExpression> search(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            FunctionalExpressionSearch.$$$reportNull$$$0(2);
        }
        return FunctionalExpressionSearch.search(psiMethod, (SearchScope)GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)psiMethod)));
    }

    public static Query<PsiFunctionalExpression> search(@NotNull PsiMethod psiMethod, @NotNull SearchScope scope) {
        if (psiMethod == null) {
            FunctionalExpressionSearch.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            FunctionalExpressionSearch.$$$reportNull$$$0(4);
        }
        return (Query)ReadAction.compute(() -> {
            PsiClass containingClass;
            if (!psiMethod.hasModifierProperty("static") && !psiMethod.hasModifierProperty("default") && (containingClass = psiMethod.getContainingClass()) != null) {
                return INSTANCE.createUniqueResultsQuery(new SearchParameters(containingClass, scope));
            }
            return EmptyQuery.getEmptyQuery();
        });
    }

    public static Query<PsiFunctionalExpression> search(@NotNull PsiClass aClass) {
        if (aClass == null) {
            FunctionalExpressionSearch.$$$reportNull$$$0(5);
        }
        return FunctionalExpressionSearch.search(aClass, (SearchScope)GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)aClass)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "scope";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "psiMethod";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/search/searches/FunctionalExpressionSearch";
        objectArray[2] = "search";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SearchParameters {
        private final PsiClass myElementToSearch;
        private final SearchScope myScope;

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope) {
            if (aClass == null) {
                SearchParameters.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(1);
            }
            this.myElementToSearch = aClass;
            this.myScope = scope;
        }

        public PsiClass getElementToSearch() {
            return this.myElementToSearch;
        }

        @NotNull
        public SearchScope getEffectiveSearchScope() {
            SearchScope searchScope = this.myScope.intersectWith(PsiSearchHelper.getInstance((Project)this.myElementToSearch.getProject()).getUseScope((PsiElement)this.myElementToSearch));
            if (searchScope == null) {
                SearchParameters.$$$reportNull$$$0(2);
            }
            return searchScope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/searches/FunctionalExpressionSearch$SearchParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/searches/FunctionalExpressionSearch$SearchParameters";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEffectiveSearchScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

