/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionInfo;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NegativeArraySizeExceptionInfo
extends ExceptionInfo {
    NegativeArraySizeExceptionInfo(int offset, String message) {
        super(offset, "java.lang.NegativeArraySizeException", message);
    }

    @Nullable
    public Integer getSuppliedSize() {
        try {
            return Integer.valueOf(this.getExceptionMessage());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    PsiElement matchSpecificExceptionElement(@NotNull PsiElement e) {
        if (e == null) {
            NegativeArraySizeExceptionInfo.$$$reportNull$$$0(0);
        }
        PsiExpression candidate = null;
        if (e instanceof PsiKeyword && e.textMatches((CharSequence)"new") && e.getParent() instanceof PsiNewExpression) {
            PsiExpression[] dimensions;
            for (PsiExpression dimension : dimensions = ((PsiNewExpression)e.getParent()).getArrayDimensions()) {
                PsiLiteral literal;
                if (dimension != null && (literal = (PsiLiteral)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown(dimension), PsiLiteral.class)) != null && literal.getValue() instanceof Integer) continue;
                if (candidate == null) {
                    candidate = dimension;
                    continue;
                }
                return null;
            }
        }
        return candidate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/filters/NegativeArraySizeExceptionInfo", "matchSpecificExceptionElement"));
    }
}

