/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.ObjectUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class JetBrainsNotNullInstrumentationExceptionInfo
extends ExceptionInfo {
    private static final Pattern INSTRUMENTATION_MESSAGE_PATTERN = Pattern.compile("Argument for @(?:\\w+) parameter '(\\w+)' of (\\S+)\\.(\\w+) must not be null");
    private final String myParameterName;
    private final String myClassName;
    private final String myMethodName;
    private final String myFullClassName;
    private final int myWantLines;

    private JetBrainsNotNullInstrumentationExceptionInfo(int offset, @NotNull String exceptionClassName, @NotNull String exceptionMessage, @NotNull String parameterName, @NotNull String className, @NotNull String methodName, int wantLines) {
        if (exceptionClassName == null) {
            JetBrainsNotNullInstrumentationExceptionInfo.$$$reportNull$$$0(0);
        }
        if (exceptionMessage == null) {
            JetBrainsNotNullInstrumentationExceptionInfo.$$$reportNull$$$0(1);
        }
        if (parameterName == null) {
            JetBrainsNotNullInstrumentationExceptionInfo.$$$reportNull$$$0(2);
        }
        if (className == null) {
            JetBrainsNotNullInstrumentationExceptionInfo.$$$reportNull$$$0(3);
        }
        if (methodName == null) {
            JetBrainsNotNullInstrumentationExceptionInfo.$$$reportNull$$$0(4);
        }
        super(offset, exceptionClassName, exceptionMessage);
        this.myParameterName = parameterName;
        this.myFullClassName = className;
        this.myClassName = StringUtil.getShortName((String)className, (char)'/');
        this.myMethodName = methodName;
        this.myWantLines = wantLines;
    }

    @Override
    PsiElement matchSpecificExceptionElement(@NotNull PsiElement element) {
        if (element == null) {
            JetBrainsNotNullInstrumentationExceptionInfo.$$$reportNull$$$0(5);
        }
        if (this.myWantLines != 0) {
            return null;
        }
        return this.getArgument(element);
    }

    private PsiExpression getArgument(PsiElement element) {
        if (!(element instanceof PsiIdentifier)) {
            return null;
        }
        if (!element.getText().equals(this.myMethodName)) {
            return null;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)element.getParent(), PsiReferenceExpression.class);
        if (ref == null) {
            return null;
        }
        PsiCallExpression call = (PsiCallExpression)ObjectUtils.tryCast((Object)ref.getParent(), PsiMethodCallExpression.class);
        if (call == null) {
            return null;
        }
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        if (!this.myClassName.equals(psiClass.getName())) {
            PsiClass aClass = ClassUtil.findPsiClass(method.getManager(), this.myFullClassName.replace('/', '.'), null, true);
            if (aClass == null || !aClass.isInheritor(psiClass, true)) {
                return null;
            }
            PsiMethod subClassMethod = aClass.findMethodBySignature(method, false);
            if (subClassMethod == null) {
                return null;
            }
            method = subClassMethod;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].getName().equals(this.myParameterName)) continue;
            PsiExpression[] expressions = argumentList.getExpressions();
            if (expressions.length > i) {
                return expressions[i];
            }
            return null;
        }
        return null;
    }

    @Override
    public ExceptionInfo consumeStackLine(String line) {
        switch (this.myWantLines) {
            case 2: {
                if (!line.contains(this.myClassName + ".$$$reportNull$$$0")) break;
                return new JetBrainsNotNullInstrumentationExceptionInfo(this.getClassNameOffset(), this.getExceptionClassName(), this.getExceptionMessage(), this.myParameterName, this.myFullClassName, this.myMethodName, 1);
            }
            case 1: {
                if (!line.contains(this.myClassName + "." + this.myMethodName)) break;
                return new JetBrainsNotNullInstrumentationExceptionInfo(this.getClassNameOffset(), this.getExceptionClassName(), this.getExceptionMessage(), this.myParameterName, this.myFullClassName, this.myMethodName, 0);
            }
        }
        return null;
    }

    static JetBrainsNotNullInstrumentationExceptionInfo tryCreate(int offset, @NotNull @NonNls String exceptionClassName, @NotNull @NonNls String exceptionMessage) {
        if (exceptionClassName == null) {
            JetBrainsNotNullInstrumentationExceptionInfo.$$$reportNull$$$0(6);
        }
        if (exceptionMessage == null) {
            JetBrainsNotNullInstrumentationExceptionInfo.$$$reportNull$$$0(7);
        }
        if (!exceptionClassName.equals("java.lang.IllegalArgumentException")) {
            return null;
        }
        if (!exceptionMessage.startsWith("Argument ")) {
            return null;
        }
        Matcher matcher = INSTRUMENTATION_MESSAGE_PATTERN.matcher(exceptionMessage);
        if (!matcher.matches()) {
            return null;
        }
        String parameterName = matcher.group(1);
        String className = matcher.group(2);
        String methodName = matcher.group(3);
        return new JetBrainsNotNullInstrumentationExceptionInfo(offset, exceptionClassName, exceptionMessage, parameterName, className, methodName, 2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClassName";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionMessage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/filters/JetBrainsNotNullInstrumentationExceptionInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "matchSpecificExceptionElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "tryCreate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

