/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.util;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.NullableConsumer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.CharsKt;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeaderImpl;
import org.intellij.plugins.markdown.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001)B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dJD\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\u000b2\b\u0010\"\u001a\u0004\u0018\u00010#2\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0%2\u000e\u0010&\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0'H\u0002J2\u0010\u001e\u001a\u00020\u001f2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u000e\u0010(\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0%2\u000e\u0010&\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0'H\u0007R&\u0010\u0003\u001a\u001a\u0012\u0016\u0012\u0014 \u0007*\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00060\u0005\u00a2\u0006\u0002\b\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/intellij/plugins/markdown/util/MarkdownPsiUtil;", "", "()V", "HEADER_ORDER", "", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm.PlatformType", "PRESENTABLE_TYPES", "TRANSPARENT_CONTAINERS", "findFirstChild", "Lcom/intellij/psi/PsiElement;", "myElement", "findNonWhiteSpacePrevSibling", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "getParentOfType", "types", "headerLevel", "curLevelType", "Lcom/intellij/psi/tree/IElementType;", "isSameLevelOrHigher", "", "psiA", "psiB", "isTopLevel", "node", "Lcom/intellij/lang/ASTNode;", "processContainer", "", "container", "sameLevelRestriction", "from", "Lorg/intellij/plugins/markdown/lang/psi/MarkdownPsiElement;", "resultConsumer", "Lcom/intellij/util/Consumer;", "nextHeaderConsumer", "Lcom/intellij/util/NullableConsumer;", "consumer", "WhiteSpaces", "intellij.markdown"})
public final class MarkdownPsiUtil {
    @JvmField
    @NotNull
    public static final TokenSet PRESENTABLE_TYPES;
    @JvmField
    @NotNull
    public static final TokenSet TRANSPARENT_CONTAINERS;
    private static final List<TokenSet> HEADER_ORDER;
    public static final MarkdownPsiUtil INSTANCE;

    public final boolean isTopLevel(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ASTNode aSTNode = node.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent");
        IElementType iElementType = MarkdownTokenTypeSets.MARKDOWN_FILE;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypeSets.MARKDOWN_FILE");
        return PsiUtilsKt.hasType(aSTNode, iElementType);
    }

    @Nullable
    public final PsiElement findNonWhiteSpacePrevSibling(@NotNull PsiFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        int offset2 = offset;
        while (offset2 > 0) {
            PsiElement element = file.findElementAt(offset2);
            if (element == null) {
                --offset2;
                continue;
            }
            ASTNode aSTNode = element.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.node");
            if (!MarkdownTokenTypeSets.WHITE_SPACES.contains(aSTNode.getElementType())) {
                return element;
            }
            int newOffset = element.getTextOffset();
            if (newOffset < offset2) {
                offset2 = newOffset;
                continue;
            }
            --offset2;
        }
        return null;
    }

    @JvmStatic
    public static final void processContainer(@Nullable PsiElement myElement, @NotNull Consumer<? super PsiElement> consumer, @NotNull NullableConsumer<? super PsiElement> nextHeaderConsumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter(nextHeaderConsumer, (String)"nextHeaderConsumer");
        if (myElement == null) {
            return;
        }
        PsiElement psiElement = myElement instanceof MarkdownFile ? INSTANCE.findFirstChild(myElement) : INSTANCE.getParentOfType(myElement, TRANSPARENT_CONTAINERS);
        if (psiElement == null) {
            return;
        }
        PsiElement structureContainer = psiElement;
        MarkdownPsiElement currentHeader = myElement instanceof MarkdownHeaderImpl ? (MarkdownPsiElement)myElement : null;
        INSTANCE.processContainer(structureContainer, (PsiElement)currentHeader, currentHeader, consumer, nextHeaderConsumer);
    }

    private final PsiElement findFirstChild(PsiElement myElement) {
        Object v2;
        block1: {
            Object[] objectArray = myElement.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"myElement.children");
            Sequence $this$firstOrNull$iv = ArraysKt.asSequence((Object[])objectArray);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                PsiElement psiElement = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"it");
                if (!Intrinsics.areEqual((Object)psiElement.getLanguage(), (Object)((Object)MarkdownLanguage.INSTANCE))) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private final void processContainer(PsiElement container, PsiElement sameLevelRestriction, MarkdownPsiElement from, Consumer<? super PsiElement> resultConsumer, NullableConsumer<? super PsiElement> nextHeaderConsumer) {
        PsiElement nextSibling = from == null ? container.getFirstChild() : from.getNextSibling();
        PsiElement maxContentLevel = null;
        while (nextSibling != null) {
            if (TRANSPARENT_CONTAINERS.contains(PsiUtilCore.getElementType((PsiElement)nextSibling)) && maxContentLevel == null) {
                this.processContainer(nextSibling, null, null, resultConsumer, nextHeaderConsumer);
            } else if (nextSibling instanceof MarkdownHeaderImpl) {
                if (sameLevelRestriction != null && this.isSameLevelOrHigher(nextSibling, sameLevelRestriction)) {
                    nextHeaderConsumer.consume((Object)nextSibling);
                    break;
                }
                if (maxContentLevel == null || this.isSameLevelOrHigher(nextSibling, maxContentLevel)) {
                    IElementType type;
                    maxContentLevel = nextSibling;
                    ASTNode aSTNode = ((MarkdownHeaderImpl)nextSibling).getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"nextSibling.node");
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode.getElementType(), (String)"nextSibling.node.elementType");
                    if (PRESENTABLE_TYPES.contains(type)) {
                        resultConsumer.consume((Object)nextSibling);
                    }
                }
            }
            if ((nextSibling = nextSibling.getNextSibling()) != null) continue;
            nextHeaderConsumer.consume(null);
        }
    }

    private final boolean isSameLevelOrHigher(PsiElement psiA, PsiElement psiB) {
        ASTNode aSTNode = psiA.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"psiA.node");
        IElementType iElementType = aSTNode.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"psiA.node.elementType");
        IElementType typeA = iElementType;
        ASTNode aSTNode2 = psiB.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"psiB.node");
        IElementType iElementType2 = aSTNode2.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"psiB.node.elementType");
        IElementType typeB = iElementType2;
        return this.headerLevel(typeA) <= this.headerLevel(typeB);
    }

    /*
     * WARNING - void declaration
     */
    private final int headerLevel(IElementType curLevelType) {
        int n = 0;
        int n2 = ((Collection)HEADER_ORDER).size();
        while (n < n2) {
            void i;
            if (HEADER_ORDER.get((int)i).contains(curLevelType)) {
                return (int)i;
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }

    private final PsiElement getParentOfType(PsiElement myElement, TokenSet types) {
        ASTNode parentNode;
        ASTNode aSTNode = parentNode = TreeUtil.findParent((ASTNode)myElement.getNode(), (TokenSet)types);
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    private MarkdownPsiUtil() {
    }

    static {
        MarkdownPsiUtil markdownPsiUtil;
        INSTANCE = markdownPsiUtil = new MarkdownPsiUtil();
        TokenSet tokenSet = MarkdownTokenTypeSets.HEADERS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"MarkdownTokenTypeSets.HEADERS");
        PRESENTABLE_TYPES = tokenSet;
        TokenSet tokenSet2 = TokenSet.create((IElementType[])new IElementType[]{MarkdownElementTypes.MARKDOWN_FILE, MarkdownElementTypes.UNORDERED_LIST, MarkdownElementTypes.ORDERED_LIST, MarkdownElementTypes.LIST_ITEM, MarkdownElementTypes.BLOCK_QUOTE});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"TokenSet.create(\n    Mar\u2026ElementTypes.BLOCK_QUOTE)");
        TRANSPARENT_CONTAINERS = tokenSet2;
        HEADER_ORDER = CollectionsKt.listOf((Object[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{(IElementType)MarkdownElementTypes.MARKDOWN_FILE_ELEMENT_TYPE}), MarkdownTokenTypeSets.HEADER_LEVEL_1_SET, MarkdownTokenTypeSets.HEADER_LEVEL_2_SET, MarkdownTokenTypeSets.HEADER_LEVEL_3_SET, MarkdownTokenTypeSets.HEADER_LEVEL_4_SET, MarkdownTokenTypeSets.HEADER_LEVEL_5_SET, MarkdownTokenTypeSets.HEADER_LEVEL_6_SET});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/util/MarkdownPsiUtil$WhiteSpaces;", "", "()V", "isNewLine", "", "element", "Lcom/intellij/psi/PsiElement;", "isWhiteSpace", "intellij.markdown"})
    public static final class WhiteSpaces {
        public static final WhiteSpaces INSTANCE;

        @JvmStatic
        public static final boolean isNewLine(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            TokenSet tokenSet = MarkdownTokenTypeSets.WHITE_SPACES;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"MarkdownTokenTypeSets.WHITE_SPACES");
            return PsiUtilsKt.hasType(element, tokenSet) && Intrinsics.areEqual((Object)element.getText(), (Object)"\n");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public static final boolean isWhiteSpace(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            TokenSet tokenSet = MarkdownTokenTypeSets.WHITE_SPACES;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"MarkdownTokenTypeSets.WHITE_SPACES");
            if (!PsiUtilsKt.hasType(element, tokenSet)) return false;
            String string = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
            CharSequence $this$all$iv = string;
            boolean $i$f$all = false;
            CharSequence charSequence = $this$all$iv;
            int n = 0;
            while (n < charSequence.length()) {
                char element$iv;
                char it = element$iv = charSequence.charAt(n);
                boolean bl = false;
                if (!CharsKt.isWhitespace((char)it)) return false;
                if (it == '\n') return false;
                boolean bl2 = true;
                if (!bl2) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private WhiteSpaces() {
        }

        static {
            WhiteSpaces whiteSpaces;
            INSTANCE = whiteSpaces = new WhiteSpaces();
        }
    }
}

