/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeaderImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDefinitionImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownParagraphImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MarkdownPsiElementFactory {
    private MarkdownPsiElementFactory() {
    }

    @NotNull
    public static MarkdownFile createFile(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(0);
        }
        if (text == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(1);
        }
        LightVirtualFile virtualFile = new LightVirtualFile("temp.rb", (Language)MarkdownLanguage.INSTANCE, (CharSequence)text);
        PsiFile psiFile = ((PsiFileFactoryImpl)PsiFileFactory.getInstance((Project)project)).trySetupPsiForFile(virtualFile, (Language)MarkdownLanguage.INSTANCE, true, true);
        if (!(psiFile instanceof MarkdownFile)) {
            throw new RuntimeException("Cannot create a new markdown file. Text: " + text);
        }
        MarkdownFile markdownFile = (MarkdownFile)psiFile;
        if (markdownFile == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(2);
        }
        return markdownFile;
    }

    @NotNull
    public static MarkdownCodeFenceImpl createCodeFence(@NotNull Project project, @Nullable String language, @NotNull String text) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(3);
        }
        if (text == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(4);
        }
        return MarkdownPsiElementFactory.createCodeFence(project, language, text, null);
    }

    @NotNull
    public static MarkdownCodeFenceImpl createCodeFence(@NotNull Project project, @Nullable String language, @NotNull String text, @Nullable String indent) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(5);
        }
        if (text == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(6);
        }
        text = StringUtil.isEmpty((String)text) ? "" : "\n" + (String)text;
        String content = "```" + StringUtil.notNullize((String)language) + (String)text + "\n" + StringUtil.notNullize((String)indent) + "```";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, content);
        MarkdownCodeFenceImpl markdownCodeFenceImpl = (MarkdownCodeFenceImpl)file.getFirstChild().getFirstChild();
        if (markdownCodeFenceImpl == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(7);
        }
        return markdownCodeFenceImpl;
    }

    @NotNull
    public static MarkdownPsiElement createTextElement(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(8);
        }
        if (text == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(9);
        }
        MarkdownPsiElement markdownPsiElement = (MarkdownPsiElement)MarkdownPsiElementFactory.createFile(project, text).getFirstChild().getFirstChild();
        if (markdownPsiElement == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(10);
        }
        return markdownPsiElement;
    }

    @NotNull
    public static MarkdownHeaderImpl createSetext(@NotNull Project project, @NotNull String text, @NotNull String symbol, int count) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(11);
        }
        if (text == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(12);
        }
        if (symbol == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(13);
        }
        MarkdownHeaderImpl markdownHeaderImpl = (MarkdownHeaderImpl)MarkdownPsiElementFactory.createFile(project, text + "\n" + StringUtil.repeat((String)symbol, (int)count)).getFirstChild().getFirstChild();
        if (markdownHeaderImpl == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(14);
        }
        return markdownHeaderImpl;
    }

    @NotNull
    public static MarkdownHeaderImpl createHeader(@NotNull Project project, @NotNull String text, int level) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(15);
        }
        if (text == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(16);
        }
        MarkdownHeaderImpl markdownHeaderImpl = (MarkdownHeaderImpl)MarkdownPsiElementFactory.createFile(project, StringUtil.repeat((String)"#", (int)level) + " " + text).getFirstChild().getFirstChild();
        if (markdownHeaderImpl == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(17);
        }
        return markdownHeaderImpl;
    }

    @NotNull
    public static PsiElement createNewLine(@NotNull Project project) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(18);
        }
        PsiElement psiElement = MarkdownPsiElementFactory.createFile(project, "\n").getFirstChild().getFirstChild();
        if (psiElement == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(19);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement createNewLines(@NotNull Project project, int num) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(20);
        }
        PsiElement psiElement = MarkdownPsiElementFactory.createFile(project, StringUtil.repeat((String)"\n", (int)num)).getFirstChild();
        if (psiElement == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(21);
        }
        return psiElement;
    }

    @NotNull
    public static Pair<PsiElement, PsiElement> createLinkDeclarationAndReference(@NotNull Project project, @NotNull String url, @NotNull String text, @Nullable String title, @NotNull String reference) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(22);
        }
        if (url == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(23);
        }
        if (text == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(24);
        }
        if (reference == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(25);
        }
        text = (String)ObjectUtils.notNull((Object)text, (Object)reference);
        title = title == null ? "" : " " + (String)title;
        String linkReference = "[" + text + "][" + reference + "]\n\n[" + reference + "]: " + url + (String)title;
        PsiElement linkReferenceElement = MarkdownPsiElementFactory.createFile(project, linkReference).getFirstChild();
        PsiElement ref = linkReferenceElement.getFirstChild();
        assert (ref instanceof MarkdownParagraphImpl);
        PsiElement declaration = linkReferenceElement.getLastChild();
        assert (declaration instanceof MarkdownParagraphImpl || declaration instanceof MarkdownLinkDefinitionImpl);
        Pair pair = Pair.create((Object)ref, (Object)declaration);
        if (pair == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(26);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/lang/psi/MarkdownPsiElementFactory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/lang/psi/MarkdownPsiElementFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeFence";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createSetext";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeader";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewLine";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewLines";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createLinkDeclarationAndReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 26: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCodeFence";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTextElement";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createSetext";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createHeader";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createNewLine";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createNewLines";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createLinkDeclarationAndReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

