/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.devkit.threadingModelHelper;

import com.intellij.compiler.instrumentation.FailSafeMethodVisitor;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jps.devkit.threadingModelHelper.TMHAssertionGenerator;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class TMHInstrumenter {
    static boolean instrument(ClassReader classReader, ClassVisitor classWriter, Set<TMHAssertionGenerator> generators) {
        AnnotatedMethodsCollector collector = new AnnotatedMethodsCollector(generators);
        classReader.accept((ClassVisitor)collector, 7);
        if (collector.annotatedMethods.isEmpty()) {
            return false;
        }
        Instrumenter instrumenter = new Instrumenter(classWriter, collector.annotatedMethods);
        classReader.accept((ClassVisitor)instrumenter, 0);
        return true;
    }

    public static boolean instrument(ClassReader classReader, ClassVisitor classWriter) {
        return TMHInstrumenter.instrument(classReader, classWriter, ContainerUtil.immutableSet((Object[])new TMHAssertionGenerator[]{new TMHAssertionGenerator.AssertEdt(), new TMHAssertionGenerator.AssertBackgroundThread(), new TMHAssertionGenerator.AssertReadAccess(), new TMHAssertionGenerator.AssertWriteAccess()}));
    }

    private static class MethodKey {
        final String name;
        final String descriptor;

        private MethodKey(String name, String descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.descriptor.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof MethodKey && ((MethodKey)obj).name.equals(this.name) && ((MethodKey)obj).descriptor.equals(this.descriptor);
        }
    }

    private static class Instrumenter
    extends ClassVisitor {
        private final Map<MethodKey, TMHAssertionGenerator> myAnnotatedMethods;

        Instrumenter(ClassVisitor writer, Map<MethodKey, TMHAssertionGenerator> annotatedMethods) {
            super(589824, writer);
            this.myAnnotatedMethods = annotatedMethods;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            final TMHAssertionGenerator generator = this.myAnnotatedMethods.get(new MethodKey(name, descriptor));
            if (generator == null) {
                return super.visitMethod(access, name, descriptor, signature, exceptions);
            }
            return new FailSafeMethodVisitor(589824, super.visitMethod(access, name, descriptor, signature, exceptions)){

                public void visitCode() {
                    generator.generateAssertion(this.mv);
                    super.visitCode();
                }
            };
        }
    }

    private static class AnnotatedMethodsCollector
    extends ClassVisitor {
        final Set<TMHAssertionGenerator> assertionGenerators;
        final Map<MethodKey, TMHAssertionGenerator> annotatedMethods = new HashMap<MethodKey, TMHAssertionGenerator>();

        AnnotatedMethodsCollector(Set<TMHAssertionGenerator> assertionGenerators) {
            super(589824);
            this.assertionGenerators = assertionGenerators;
        }

        public MethodVisitor visitMethod(int access, final String name, final String methodDescriptor, String signature, String[] exceptions) {
            return new MethodVisitor(589824){

                public AnnotationVisitor visitAnnotation(String annotationDescriptor, boolean visible) {
                    for (TMHAssertionGenerator assertionGenerator : assertionGenerators) {
                        if (!assertionGenerator.isMyAnnotation(annotationDescriptor)) continue;
                        return assertionGenerator.getAnnotationChecker(589824, () -> annotatedMethods.put(new MethodKey(name, methodDescriptor), assertionGenerator));
                    }
                    return super.visitAnnotation(annotationDescriptor, visible);
                }
            };
        }
    }
}

