/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.old.descriptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.archetype.old.descriptor.TemplateDescriptor;

public class ArchetypeDescriptor {
    private String id;
    private List sources = new ArrayList();
    private List testSources;
    private List resources = new ArrayList();
    private List testResources;
    private List siteResources;
    private Map sourcesDescriptors;
    private Map testSourcesDescriptors;
    private Map resourcesDescriptors;
    private Map testResourcesDescriptors;
    private Map siteResourcesDescriptors;
    private boolean allowPartial;

    public ArchetypeDescriptor() {
        this.testSources = new ArrayList();
        this.testResources = new ArrayList();
        this.siteResources = new ArrayList();
        this.sourcesDescriptors = new HashMap();
        this.testSourcesDescriptors = new HashMap();
        this.resourcesDescriptors = new HashMap();
        this.testResourcesDescriptors = new HashMap();
        this.siteResourcesDescriptors = new HashMap();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addSource(String source) {
        this.sources.add(source);
        this.putSourceDescriptor(source, new TemplateDescriptor());
    }

    public List getSources() {
        return this.sources;
    }

    public void putSourceDescriptor(String source, TemplateDescriptor descriptor) {
        this.sourcesDescriptors.put(source, descriptor);
    }

    public TemplateDescriptor getSourceDescriptor(String source) {
        return (TemplateDescriptor)this.sourcesDescriptors.get(source);
    }

    public Map getSourcesDescriptors() {
        return this.sourcesDescriptors;
    }

    public void addTestSource(String testSource) {
        this.testSources.add(testSource);
        this.putTestSourceDescriptor(testSource, new TemplateDescriptor());
    }

    public List getTestSources() {
        return this.testSources;
    }

    public void putTestSourceDescriptor(String testSource, TemplateDescriptor descriptor) {
        this.testSourcesDescriptors.put(testSource, descriptor);
    }

    public TemplateDescriptor getTestSourceDescriptor(String testSource) {
        return (TemplateDescriptor)this.testSourcesDescriptors.get(testSource);
    }

    public Map getTestSourcesDescriptors() {
        return this.testSourcesDescriptors;
    }

    public void addResource(String resource) {
        this.resources.add(resource);
        this.putResourceDescriptor(resource, new TemplateDescriptor());
    }

    public List getResources() {
        return this.resources;
    }

    public void putResourceDescriptor(String resource, TemplateDescriptor descriptor) {
        this.resourcesDescriptors.put(resource, descriptor);
    }

    public TemplateDescriptor getResourceDescriptor(String resource) {
        return (TemplateDescriptor)this.resourcesDescriptors.get(resource);
    }

    public Map getReourcesDescriptors() {
        return this.resourcesDescriptors;
    }

    public void addTestResource(String testResource) {
        this.testResources.add(testResource);
        this.putTestResourceDescriptor(testResource, new TemplateDescriptor());
    }

    public List getTestResources() {
        return this.testResources;
    }

    public void putTestResourceDescriptor(String testResource, TemplateDescriptor descriptor) {
        this.testResourcesDescriptors.put(testResource, descriptor);
    }

    public TemplateDescriptor getTestResourceDescriptor(String testResource) {
        return (TemplateDescriptor)this.testResourcesDescriptors.get(testResource);
    }

    public Map getTestReourcesDescriptors() {
        return this.testResourcesDescriptors;
    }

    public void addSiteResource(String siteResource) {
        this.siteResources.add(siteResource);
        this.putSiteResourceDescriptor(siteResource, new TemplateDescriptor());
    }

    public List getSiteResources() {
        return this.siteResources;
    }

    public void putSiteResourceDescriptor(String siteResource, TemplateDescriptor descriptor) {
        this.siteResourcesDescriptors.put(siteResource, descriptor);
    }

    public TemplateDescriptor getSiteResourceDescriptor(String siteResource) {
        return (TemplateDescriptor)this.siteResourcesDescriptors.get(siteResource);
    }

    public Map getSiteReourcesDescriptors() {
        return this.siteResourcesDescriptors;
    }

    public boolean isAllowPartial() {
        return this.allowPartial;
    }

    public void setAllowPartial(boolean allowPartial) {
        this.allowPartial = allowPartial;
    }
}

