/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.suggested;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.refactoring.suggested.LightJavaCodeInsightFixtureTestCaseWithUtils$executeEditingActions$;
import com.intellij.testFramework.fixtures.LightJavaCodeInsightFixtureTestCase;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J+\u0010\b\u001a\u00020\u00042\u0014\u0010\t\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00040\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0004\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0004\u00a8\u0006\u0012"}, d2={"Lcom/intellij/refactoring/suggested/LightJavaCodeInsightFixtureTestCaseWithUtils;", "Lcom/intellij/testFramework/fixtures/LightJavaCodeInsightFixtureTestCase;", "()V", "deleteTextAtCaret", "", "text", "", "deleteTextBeforeCaret", "executeEditingActions", "editingActions", "", "Lkotlin/Function0;", "wrapIntoCommandAndWriteActionAndCommitAll", "", "([Lkotlin/jvm/functions/Function0;Z)V", "replaceTextAtCaret", "oldText", "newText", "intellij.java.testFramework"})
public abstract class LightJavaCodeInsightFixtureTestCaseWithUtils
extends LightJavaCodeInsightFixtureTestCase {
    protected final void deleteTextAtCaret(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Editor editor = this.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"editor");
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        Editor editor2 = this.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor");
        String string = editor2.getDocument().getText(new TextRange(offset, offset + text.length()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"editor.document.getText(\u2026t, offset + text.length))");
        String actualText = string;
        boolean bl = Intrinsics.areEqual((Object)actualText, (Object)text);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Editor editor3 = this.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"editor");
        editor3.getDocument().deleteString(offset, offset + text.length());
    }

    protected final void deleteTextBeforeCaret(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Editor editor = this.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"editor");
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        Editor editor2 = this.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor");
        String string = editor2.getDocument().getText(new TextRange(offset - text.length(), offset));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"editor.document.getText(\u2026t - text.length, offset))");
        String actualText = string;
        boolean bl = Intrinsics.areEqual((Object)actualText, (Object)text);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Editor editor3 = this.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"editor");
        editor3.getDocument().deleteString(offset - text.length(), offset);
    }

    protected final void replaceTextAtCaret(@NotNull String oldText, @NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)oldText, (String)"oldText");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        Editor editor = this.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"editor");
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        Editor editor2 = this.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor");
        String string = editor2.getDocument().getText(new TextRange(offset, offset + oldText.length()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"editor.document.getText(\u2026offset + oldText.length))");
        String actualText = string;
        boolean bl = Intrinsics.areEqual((Object)actualText, (Object)oldText);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Editor editor3 = this.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"editor");
        editor3.getDocument().replaceString(offset, offset + oldText.length(), (CharSequence)newText);
    }

    protected final void executeEditingActions(@NotNull Function0<Unit>[] editingActions, boolean wrapIntoCommandAndWriteActionAndCommitAll) {
        Intrinsics.checkNotNullParameter(editingActions, (String)"editingActions");
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        for (Function0<Unit> action : editingActions) {
            if (wrapIntoCommandAndWriteActionAndCommitAll) {
                Project project$iv = null;
                String name$iv = null;
                String groupId$iv = null;
                boolean $i$f$executeCommand = false;
                CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this, action, psiDocumentManager){
                    final /* synthetic */ LightJavaCodeInsightFixtureTestCaseWithUtils this$0;
                    final /* synthetic */ Function0 $action$inlined;
                    final /* synthetic */ PsiDocumentManager $psiDocumentManager$inlined;
                    {
                        this.this$0 = lightJavaCodeInsightFixtureTestCaseWithUtils;
                        this.$action$inlined = function0;
                        this.$psiDocumentManager$inlined = psiDocumentManager;
                    }

                    public final void run() {
                        boolean bl = false;
                        boolean $i$f$runWriteAction = false;
                        ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(this){
                            final /* synthetic */ executeEditingActions$$inlined$executeCommand$1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final T compute() {
                                boolean bl = false;
                                this.this$0.$action$inlined.invoke();
                                this.this$0.$psiDocumentManager$inlined.commitAllDocuments();
                                PsiDocumentManager psiDocumentManager = this.this$0.$psiDocumentManager$inlined;
                                Editor editor = LightJavaCodeInsightFixtureTestCaseWithUtils.access$getEditor(this.this$0.this$0);
                                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"editor");
                                psiDocumentManager.doPostponedOperationsAndUnblockDocument(editor.getDocument());
                                return (T)Unit.INSTANCE;
                            }
                        });
                    }
                }, name$iv, (Object)groupId$iv);
                continue;
            }
            action.invoke();
        }
        psiDocumentManager.commitAllDocuments();
    }

    public static final /* synthetic */ Editor access$getEditor(LightJavaCodeInsightFixtureTestCaseWithUtils $this) {
        return $this.getEditor();
    }
}

