/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.monitor.Context;
import org.fest.swing.monitor.ContextMonitor;
import org.fest.swing.monitor.WindowAvailabilityMonitor;
import org.fest.swing.monitor.WindowStatus;
import org.fest.swing.monitor.Windows;
import org.fest.swing.util.ToolkitProvider;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

public class WindowMonitor {
    private final Context context;
    private final ContextMonitor contextMonitor;
    private final Windows windows;
    private final WindowStatus windowStatus;
    private final WindowAvailabilityMonitor windowAvailabilityMonitor;

    @RunsInCurrentThread
    WindowMonitor(@Nonnull Toolkit toolkit) {
        this(toolkit, new Context(toolkit), new WindowStatus(new Windows()));
    }

    @VisibleForTesting
    @RunsInCurrentThread
    WindowMonitor(@Nonnull Toolkit toolkit, @Nonnull Context context, @Nonnull WindowStatus windowStatus) {
        this.context = context;
        this.windowStatus = windowStatus;
        this.windows = windowStatus.windows();
        this.contextMonitor = new ContextMonitor(context, this.windows);
        this.contextMonitor.attachTo(toolkit);
        this.windowAvailabilityMonitor = new WindowAvailabilityMonitor(this.windows);
        this.windowAvailabilityMonitor.attachTo(toolkit);
        this.populateExistingWindows();
    }

    private void populateExistingWindows() {
        for (Frame f : Frame.getFrames()) {
            this.examine((Window)Preconditions.checkNotNull((Object)f));
        }
    }

    @RunsInCurrentThread
    private void examine(@Nonnull Window w) {
        this.windows.attachNewWindowVisibilityMonitor(w);
        for (Window owned : w.getOwnedWindows()) {
            this.examine((Window)Preconditions.checkNotNull((Object)owned));
        }
        this.windows.markExisting(w);
        this.context.addContextFor(w);
    }

    public boolean isWindowReady(@Nonnull Window w) {
        if (this.windows.isReady(w)) {
            return true;
        }
        this.windowStatus.checkIfReady(w);
        return false;
    }

    @Nullable
    public EventQueue eventQueueFor(@Nonnull Component c) {
        return this.context.eventQueueFor(c);
    }

    @Nonnull
    public Collection<EventQueue> allEventQueues() {
        return this.context.allEventQueues();
    }

    @Nonnull
    public Collection<Window> rootWindows() {
        return this.context.rootWindows();
    }

    @Nonnull
    @RunsInEDT
    public static WindowMonitor instance() {
        return SingletonLazyLoader.INSTANCE;
    }

    @RunsInEDT
    private static class SingletonLazyLoader {
        static final WindowMonitor INSTANCE = GuiActionRunner.execute(new GuiQuery<WindowMonitor>(){

            @Override
            @Nullable
            protected WindowMonitor executeInEDT() {
                return new WindowMonitor(ToolkitProvider.instance().defaultToolkit());
            }
        });

        private SingletonLazyLoader() {
        }
    }
}

